package com.aliyun.core.utils;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;

public final class Validate {
    private static final String DEFAULT_NULL_EX_MESSAGE = "The object is validated as null";

    private Validate() {
    }

    public static void isTrue(final boolean expression, final String message, final Object... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static <T> T notNull(final T object, final String message, final Object... values) {
        if (object == null) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return object;
    }

    public static <T> void isNull(final T object, final String message, final Object... values) {
        if (object != null) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static <T> T paramNotNull(final T object, final String paramName) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s must not be null.", paramName));
        }
        return object;
    }

    public static <T extends CharSequence> T paramNotBlank(final T chars, final String paramName) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("%s must not be null.", paramName));
        }
        if (StringUtils.isBlank(chars)) {
            throw new IllegalArgumentException(String.format("%s must not be blank or empty.", paramName));
        }
        return chars;
    }

    public static <T extends CharSequence> T notEmpty(final T chars, final String paramName) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("%s must not be null.", paramName));
        }
        if (StringUtils.isEmpty(chars)) {
            throw new IllegalArgumentException(String.format("%s must not be empty.", paramName));
        }
        return chars;
    }

    public static <T> T[] notEmpty(final T[] array, final String message, final Object... values) {
        if (array == null) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        if (array.length == 0) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(final T collection, final String message, final Object... values) {
        if (collection == null) {
            throw new NullPointerException(String.format(message, values));
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T notEmpty(final T map, final String message, final Object... values) {
        if (map == null) {
            throw new NullPointerException(String.format(message, values));
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException(String.format(message, values));
        }
        return map;
    }

    public static int isPositive(int num, String fieldName) {
        if (num <= 0) {
            throw new IllegalArgumentException(String.format("%s must be positive", fieldName));
        }
        return num;
    }

    public static long isPositive(long num, String fieldName) {
        if (num <= 0) {
            throw new IllegalArgumentException(String.format("%s must be positive", fieldName));
        }
        return num;
    }

    public static int isNotNegative(int num, String fieldName) {
        if (num < 0) {
            throw new IllegalArgumentException(String.format("%s must not be negative", fieldName));
        }
        return num;
    }

    public static long isNotNegative(long num, String fieldName) {
        if (num < 0) {
            throw new IllegalArgumentException(String.format("%s must not be negative", fieldName));
        }
        return num;
    }

    public static Duration isPositive(Duration duration, String fieldName) {
        if (duration == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null", fieldName));
        }
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException(String.format("%s must be positive", fieldName));
        }
        return duration;
    }


    public static Duration isNotNegative(Duration duration, String fieldName) {
        if (duration == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null", fieldName));
        }
        if (duration.isNegative()) {
            throw new IllegalArgumentException(String.format("%s must not be negative", fieldName));
        }
        return duration;
    }

    public static <T> Class<? extends T> isAssignableFrom(final Class<T> superType, final Class<?> type,
                                                          final String message, final Object... values) {
        if (!superType.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format(message, values));
        }

        return (Class<? extends T>) type;
    }
}
