/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client;

import com.aliyun.mqs.client.AsyncCallback;
import com.aliyun.mqs.client.AsyncResult;
import com.aliyun.mqs.client.CloudQueue;
import com.aliyun.mqs.client.MQSClient;
import com.aliyun.mqs.client.Utils;
import com.aliyun.mqs.client.impl.CreateQueueAction;
import com.aliyun.mqs.client.impl.ListQueueAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.ServiceException;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.ClientConfiguration;
import com.aliyun.mqs.common.http.DefaultServiceClient;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.model.CreateQueueRequest;
import com.aliyun.mqs.model.ListQueueRequest;
import com.aliyun.mqs.model.PagingListResult;
import com.aliyun.mqs.model.QueueMeta;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultMQSClient
implements MQSClient {
    private static Log log = LogFactory.getLog(DefaultMQSClient.class);
    private URI endpoint;
    private ServiceClient serviceClient;
    private ServiceCredentials credentials = new ServiceCredentials();

    public DefaultMQSClient(String endpoint, String accessId, String accessKey) {
        this(endpoint, accessId, accessKey, null);
    }

    public DefaultMQSClient(String endpoint, String accessId, String accessKey, ClientConfiguration config) {
        this.setEndpoint(endpoint);
        this.credentials = new ServiceCredentials(accessId, accessKey);
        if (config == null) {
            config = new ClientConfiguration();
            config.setExceptContinue(false);
        }
        this.serviceClient = new DefaultServiceClient(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initiated MQSClientImpl,accessId=" + accessId + ",accessKey=" + accessKey + ", endpoint=" + endpoint));
        }
    }

    protected DefaultMQSClient(ServiceCredentials credentials, ServiceClient serviceClient, String endpoint) {
        this.serviceClient = serviceClient;
        this.credentials = credentials;
        this.setEndpoint(endpoint);
    }

    @Override
    public CloudQueue getQueueRef(String queueURL) {
        return new CloudQueue(queueURL, this.serviceClient, this.credentials, this.endpoint);
    }

    private void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.endpoint = Utils.getHttpURI(endpoint);
    }

    public AsyncResult<String> createQueueAsync(QueueMeta queueMeta, AsyncCallback<String> callback) {
        CreateQueueAction action = new CreateQueueAction(this.serviceClient, this.credentials, this.endpoint);
        CreateQueueRequest request = new CreateQueueRequest();
        request.setRequestPath(queueMeta.getQueueName());
        request.setQueueMeta(queueMeta);
        AsyncResult<String> result = action.execute(request, callback);
        return result;
    }

    @Override
    public CloudQueue createQueue(QueueMeta queueMeta) throws ClientException, ServiceException {
        CreateQueueAction action = new CreateQueueAction(this.serviceClient, this.credentials, this.endpoint);
        CreateQueueRequest request = new CreateQueueRequest();
        request.setRequestPath(queueMeta.getQueueName());
        request.setQueueMeta(queueMeta);
        String queueLocation = (String)action.execute(request);
        return new CloudQueue(queueLocation, this.serviceClient, this.credentials, this.endpoint);
    }

    @Override
    public PagingListResult<String> listQueueURL(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        PagingListResult<String> results = new PagingListResult<String>();
        PagingListResult<QueueMeta> list = this.listQueue(prefix, marker, retNumber, false);
        if (list != null && list.getResult() != null) {
            ArrayList<String> queues = new ArrayList<String>();
            for (QueueMeta meta : list.getResult()) {
                queues.add(meta.getQueueURL());
            }
            if (list.getMarker() != null) {
                results.setMarker(list.getMarker());
            }
            results.setResult(queues);
            return results;
        }
        return results;
    }

    @Override
    public PagingListResult<QueueMeta> listQueue(String prefix, String marker, Integer retNumber) throws ClientException, ServiceException {
        return this.listQueue(prefix, marker, retNumber, true);
    }

    private PagingListResult<QueueMeta> listQueue(String prefix, String marker, Integer retNumber, boolean withMeta) throws ClientException, ServiceException {
        ListQueueAction action = new ListQueueAction(this.serviceClient, this.credentials, this.endpoint);
        ListQueueRequest request = new ListQueueRequest();
        request.setRequestPath("/");
        request.setMarker(marker);
        request.setPrefix(prefix);
        request.setMaxRet(retNumber);
        request.setWithMeta(withMeta);
        return (PagingListResult)action.execute(request);
    }

    @Override
    public void close() {
        if (this.serviceClient != null) {
            this.serviceClient.close();
        }
    }
}

