/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client.impl;

import com.aliyun.mqs.client.impl.AbstractAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.HttpMethod;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.RequestMessage;
import com.aliyun.mqs.common.http.ResponseMessage;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.common.parser.ResultParseException;
import com.aliyun.mqs.common.parser.ResultParser;
import com.aliyun.mqs.model.ListQueueRequest;
import com.aliyun.mqs.model.PagingListResult;
import com.aliyun.mqs.model.QueueArrayDeserializer;
import com.aliyun.mqs.model.QueueMeta;
import java.net.URI;

public class ListQueueAction
extends AbstractAction<ListQueueRequest, PagingListResult<QueueMeta>> {
    public ListQueueAction(ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(HttpMethod.GET, "ListQueue", client, credentials, endpoint);
    }

    @Override
    protected RequestMessage buildRequest(ListQueueRequest reqObject) throws ClientException {
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setResourcePath(reqObject.getRequestPath());
        if (reqObject.getPrefix() != null && !"".equals(reqObject.getPrefix())) {
            requestMessage.addHeader("x-mqs-prefix", reqObject.getPrefix());
        }
        if (reqObject.getMarker() != null && !"".equals(reqObject.getMarker())) {
            requestMessage.addHeader("x-mqs-marker", reqObject.getMarker());
        }
        if (reqObject.getMaxRet() != null) {
            requestMessage.addHeader("x-mqs-ret-number", reqObject.getMaxRet().toString());
        }
        if (reqObject.getWithMeta() != null) {
            requestMessage.addHeader("x-mqs-with-meta", reqObject.getWithMeta().toString());
        }
        return requestMessage;
    }

    @Override
    protected ResultParser<PagingListResult<QueueMeta>> buildResultParser() {
        return new ResultParser<PagingListResult<QueueMeta>>(){

            @Override
            public PagingListResult<QueueMeta> parse(ResponseMessage response) throws ResultParseException {
                QueueArrayDeserializer deserializer = new QueueArrayDeserializer();
                try {
                    return deserializer.deserialize(response.getContent());
                }
                catch (Exception e) {
                    throw new ResultParseException("Unmarshal error,cause by:" + e.getMessage(), e);
                }
            }
        };
    }
}

