/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.common.http;

import com.aliyun.mqs.client.AsyncCallback;
import com.aliyun.mqs.client.AsyncResult;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.http.ResponseMessage;
import com.aliyun.mqs.common.parser.ResultParser;
import com.aliyun.mqs.common.utils.HttpUtil;
import com.aliyun.mqs.common.utils.IOUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;

public class HttpCallback<T>
implements FutureCallback<HttpResponse> {
    private boolean success = false;
    private Exception exception = null;
    private ResponseMessage responseMessage = null;
    private boolean cancalled = false;
    private ResultParser<T> resultParser;
    private AsyncCallback<T> callback;
    private DefaultAsyncResult<T> result;
    private ResultParser<Exception> exceptionParser;
    private static Log log = LogFactory.getLog(HttpCallback.class);

    public HttpCallback(ResultParser<T> resultParser, ResultParser<Exception> exceptionParser, AsyncCallback<T> callback) {
        this.resultParser = resultParser;
        this.callback = callback;
        this.exceptionParser = exceptionParser;
        this.result = new DefaultAsyncResult(this);
    }

    public void completed(HttpResponse response) {
        this.buildResponseMessage(response);
    }

    protected void buildResponseMessage(HttpResponse response) {
        this.responseMessage = new ResponseMessage();
        if (response.getStatusLine() != null) {
            this.responseMessage.setStatusCode(response.getStatusLine().getStatusCode());
        }
        if (response.getEntity() != null) {
            try {
                this.responseMessage.setContent(response.getEntity().getContent());
            }
            catch (IllegalStateException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            resultHeaders.put(h.getName(), h.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(resultHeaders);
        this.responseMessage.setHeaders(resultHeaders);
        this.handleResult();
    }

    private void close() {
        if (this.responseMessage != null) {
            try {
                this.responseMessage.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleResult() {
        try {
            if (this.responseMessage.isSuccessful()) {
                Object obj = null;
                if (this.resultParser != null) {
                    obj = this.resultParser.parse(this.responseMessage);
                }
                if (this.callback != null) {
                    this.callback.onSuccess(obj);
                }
                this.result.onSuccess(obj);
                this.success = true;
            } else {
                Exception obj = this.exceptionParser.parse(this.responseMessage);
                if (this.callback != null) {
                    this.callback.onFail(obj);
                }
                this.result.onFail(obj);
            }
        }
        catch (Exception ex) {
            try {
                System.out.println(IOUtils.readStreamAsString(this.responseMessage.getContent(), "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.callback != null) {
                this.callback.onFail(ex);
            }
            this.result.onFail(ex);
        }
    }

    public void failed(Exception ex) {
        this.exception = ex;
        try {
            if (this.callback != null) {
                this.callback.onFail(ex);
            }
            this.result.onFail(ex);
        }
        catch (Exception e) {
            if (this.callback != null) {
                this.callback.onFail(e);
            }
            this.result.onFail(e);
        }
    }

    public void cancelled() {
        this.cancalled = true;
        this.exception = new ClientException("call is cancelled.");
        try {
            if (this.callback != null) {
                this.callback.onFail(this.exception);
            }
            this.result.onFail(this.exception);
        }
        catch (Exception e) {
            if (this.callback != null) {
                this.callback.onFail(e);
            }
            this.result.onFail(e);
        }
    }

    public boolean isCancelled() {
        return this.cancalled;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Exception getException() {
        return this.exception;
    }

    public ResponseMessage getResponseMessage() {
        return this.responseMessage;
    }

    public AsyncResult<T> getAsyncResult() {
        return this.result;
    }

    static class DefaultAsyncResult<T>
    implements AsyncResult<T> {
        private ReentrantLock rlock = new ReentrantLock();
        private Condition lock = this.rlock.newCondition();
        private boolean completed = false;
        private T result = null;
        private boolean success;
        private Exception exception;
        private HttpCallback<T> callback;

        protected DefaultAsyncResult(HttpCallback<T> callback) {
            this.callback = callback;
        }

        @Override
        public T getResult() {
            return this.getResult(0L);
        }

        @Override
        public T getResult(long timewait) {
            if (!this.completed) {
                try {
                    this.rlock.lock();
                    if (!this.completed) {
                        if (timewait <= 0L) {
                            this.lock.await();
                        } else {
                            this.lock.await(timewait, TimeUnit.MILLISECONDS);
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.rlock.unlock();
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(T result) {
            try {
                this.rlock.lock();
                this.result = result;
                this.success = true;
                this.completed = true;
                this.lock.signal();
            }
            finally {
                this.rlock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFail(Exception ex) {
            try {
                this.rlock.lock();
                this.exception = ex;
                this.success = false;
                this.completed = true;
                this.lock.signal();
            }
            finally {
                this.rlock.unlock();
            }
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        public void close() {
            ((HttpCallback)this.callback).close();
        }
    }
}

