/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.model;

import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.model.Message;
import com.aliyun.mqs.model.serialize.XMLDeserializer;
import java.io.InputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageDeserializer
extends XMLDeserializer<Message> {
    @Override
    public Message deserialize(InputStream stream) throws Exception {
        Element root = null;
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.parse(stream);
        root = doc.getDocumentElement();
        return this.parseMessage(root);
    }

    private Message parseMessage(Element root) throws ClientException {
        String dequeueCount;
        String firstDequeueTime;
        String nextVisibleTime;
        String receiptHandle;
        String messageBodyMD5;
        String messageId;
        Message message = new Message();
        message.messageId = messageId = this.safeGetElementContent(root, "MessageId", null);
        String messageBody = this.safeGetElementContent(root, "MessageBody", null);
        if (messageBody != null) {
            message.setMessageBody(Base64.decodeBase64((String)messageBody));
        }
        message.messageBodyMD5 = messageBodyMD5 = this.safeGetElementContent(root, "MessageBodyMD5", null);
        message.receiptHandle = receiptHandle = this.safeGetElementContent(root, "ReceiptHandle", null);
        String enqueTime = this.safeGetElementContent(root, "EnqueueTime", null);
        if (enqueTime != null) {
            message.enqueueTime = new Date(Long.parseLong(enqueTime));
        }
        if ((nextVisibleTime = this.safeGetElementContent(root, "NextVisibleTime", null)) != null) {
            message.nextVisibleTime = new Date(Long.parseLong(nextVisibleTime));
        }
        if ((firstDequeueTime = this.safeGetElementContent(root, "FirstDequeueTime", null)) != null) {
            message.firstDequeueTime = new Date(Long.parseLong(firstDequeueTime));
        }
        if ((dequeueCount = this.safeGetElementContent(root, "DequeueCount", null)) != null) {
            message.dequeueCount = Integer.parseInt(dequeueCount);
        }
        return message;
    }
}

