/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.model;

import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.model.Message;
import com.aliyun.mqs.model.serialize.XMLDeserializer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MessageListDeserializer
extends XMLDeserializer<List<Message>> {
    @Override
    public List<Message> deserialize(InputStream stream) throws Exception {
        Document doc = factory.newDocumentBuilder().parse(stream);
        NodeList list = doc.getElementsByTagName("Message");
        if (list != null && list.getLength() > 0) {
            ArrayList<Message> results = new ArrayList<Message>();
            for (int i = 0; i < list.getLength(); ++i) {
                Message msg = this.parseMessage((Element)list.item(i));
                results.add(msg);
            }
            return results;
        }
        return null;
    }

    private Message.ErrorMessageResult parseErrorMessageResult(Element root) {
        Message.ErrorMessageResult result = new Message.ErrorMessageResult();
        String errorCode = this.safeGetElementContent(root, "ErrorCode", null);
        result.setErrorCode(errorCode);
        String errorMessage = this.safeGetElementContent(root, "ErrorCode", null);
        result.setErrorMessage(errorMessage);
        return result;
    }

    private Message parseMessage(Element root) throws ClientException {
        String priority;
        String dequeueCount;
        String firstDequeueTime;
        String nextVisibleTime;
        String receiptHandle;
        String messageBodyMD5;
        Message message = new Message();
        String messageId = this.safeGetElementContent(root, "MessageId", null);
        if (messageId == null) {
            message.errorMessage = this.parseErrorMessageResult(root);
            return message;
        }
        message.messageId = messageId;
        String messageBody = this.safeGetElementContent(root, "MessageBody", null);
        if (messageBody != null) {
            message.setMessageBody(Base64.decodeBase64((String)messageBody));
        }
        message.messageBodyMD5 = messageBodyMD5 = this.safeGetElementContent(root, "MessageBodyMD5", null);
        message.receiptHandle = receiptHandle = this.safeGetElementContent(root, "ReceiptHandle", null);
        String enqueTime = this.safeGetElementContent(root, "EnqueueTime", null);
        if (enqueTime != null) {
            message.enqueueTime = new Date(Long.parseLong(enqueTime));
        }
        if ((nextVisibleTime = this.safeGetElementContent(root, "NextVisibleTime", null)) != null) {
            message.nextVisibleTime = new Date(Long.parseLong(nextVisibleTime));
        }
        if ((firstDequeueTime = this.safeGetElementContent(root, "FirstDequeueTime", null)) != null) {
            message.firstDequeueTime = new Date(Long.parseLong(firstDequeueTime));
        }
        if ((dequeueCount = this.safeGetElementContent(root, "DequeueCount", null)) != null) {
            message.dequeueCount = Integer.parseInt(dequeueCount);
        }
        if ((priority = this.safeGetElementContent(root, "Priority", null)) != null) {
            message.priority = Integer.parseInt(priority);
        }
        return message;
    }
}

