/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.boot;

import com.alibaba.cola.event.EventHandlerI;
import com.alibaba.cola.event.EventHub;
import com.alibaba.cola.event.EventI;
import com.alibaba.cola.exception.framework.ColaException;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class EventRegister {
    @Resource
    private EventHub eventHub;

    private Class<? extends EventI> getEventFromExecutor(Class<?> eventExecutorClz) {
        Method[] methods;
        for (Method method : methods = eventExecutorClz.getDeclaredMethods()) {
            if (!this.isExecuteMethod(method)) continue;
            return this.checkAndGetEventParamType(method);
        }
        throw new ColaException("Event param in " + eventExecutorClz + " " + "execute" + "() is not detected");
    }

    public void doRegistration(EventHandlerI eventHandler) {
        Class<? extends EventI> eventClz = this.getEventFromExecutor(eventHandler.getClass());
        this.eventHub.register(eventClz, eventHandler);
    }

    private boolean isExecuteMethod(Method method) {
        return "execute".equals(method.getName()) && !method.isBridge();
    }

    private Class checkAndGetEventParamType(Method method) {
        Class<?>[] exeParams = method.getParameterTypes();
        if (exeParams.length == 0) {
            throw new ColaException("Execute method in " + method.getDeclaringClass() + " should at least have one parameter");
        }
        if (!EventI.class.isAssignableFrom(exeParams[0])) {
            throw new ColaException("Execute method in " + method.getDeclaringClass() + " should be the subClass of Event");
        }
        return exeParams[0];
    }
}

