/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.boot;

import com.alibaba.cola.exception.framework.ColaException;
import com.alibaba.cola.extension.BizScenario;
import com.alibaba.cola.extension.Extension;
import com.alibaba.cola.extension.ExtensionCoordinate;
import com.alibaba.cola.extension.ExtensionPointI;
import com.alibaba.cola.extension.ExtensionRepository;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ExtensionRegister {
    @Resource
    private ExtensionRepository extensionRepository;

    public void doRegistration(ExtensionPointI extensionObject) {
        Class<?> extensionClz = extensionObject.getClass();
        Extension extensionAnn = extensionClz.getDeclaredAnnotation(Extension.class);
        BizScenario bizScenario = BizScenario.valueOf((String)extensionAnn.bizId(), (String)extensionAnn.useCase(), (String)extensionAnn.scenario());
        ExtensionCoordinate extensionCoordinate = new ExtensionCoordinate(this.calculateExtensionPoint(extensionClz), bizScenario.getUniqueIdentity());
        ExtensionPointI preVal = this.extensionRepository.getExtensionRepo().put(extensionCoordinate, extensionObject);
        if (preVal != null) {
            throw new ColaException("Duplicate registration is not allowed for :" + extensionCoordinate);
        }
    }

    private String calculateExtensionPoint(Class<?> targetClz) {
        Class<?>[] interfaces = targetClz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            throw new ColaException("Please assign a extension point interface for " + targetClz);
        }
        for (Class<?> intf : interfaces) {
            String extensionPoint = intf.getSimpleName();
            if (!extensionPoint.contains("ExtPt")) continue;
            return intf.getName();
        }
        throw new ColaException("Your name of ExtensionPoint for " + targetClz + " is not valid, must be end of " + "ExtPt");
    }
}

