/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.common;

import com.alibaba.cola.exception.SysException;
import com.alibaba.cola.exception.framework.BasicErrorCode;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ApplicationContextHelper
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextHelper.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static <T> T getBean(Class<T> targetClz) {
        Object beanInstance = null;
        try {
            beanInstance = applicationContext.getBean(targetClz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanInstance == null) {
            String simpleName = targetClz.getSimpleName();
            simpleName = Character.toLowerCase(simpleName.charAt(0)) + simpleName.substring(1);
            beanInstance = applicationContext.getBean(simpleName);
        }
        if (beanInstance == null) {
            new SysException(BasicErrorCode.COLA_ERROR, "Component " + targetClz + " can not be found in Spring Container");
        }
        return (T)beanInstance;
    }

    public static Object getBean(String claz) {
        return applicationContext.getBean(claz);
    }
}

