/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.extension;

import com.alibaba.cola.boot.AbstractComponentExecutor;
import com.alibaba.cola.exception.framework.ColaException;
import com.alibaba.cola.extension.BizScenario;
import com.alibaba.cola.extension.ExtensionCoordinate;
import com.alibaba.cola.extension.ExtensionPointI;
import com.alibaba.cola.extension.ExtensionRepository;
import com.alibaba.cola.logger.Logger;
import com.alibaba.cola.logger.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExtensionExecutor
extends AbstractComponentExecutor {
    private Logger logger = LoggerFactory.getLogger(ExtensionExecutor.class);
    @Autowired
    private ExtensionRepository extensionRepository;

    @Override
    protected <C> C locateComponent(Class<C> targetClz, BizScenario bizScenario) {
        C extension = this.locateExtension(targetClz, bizScenario);
        this.logger.debug("[Located Extension]: " + extension.getClass().getSimpleName());
        return extension;
    }

    protected <Ext> Ext locateExtension(Class<Ext> targetClz, BizScenario bizScenario) {
        this.checkNull(bizScenario);
        String bizScenarioUniqueIdentity = bizScenario.getUniqueIdentity();
        this.logger.debug("BizScenario in locateExtension is : " + bizScenarioUniqueIdentity);
        Ext extension = this.firstTry(targetClz, bizScenarioUniqueIdentity);
        if (extension != null) {
            return extension;
        }
        extension = this.loopTry(targetClz, bizScenarioUniqueIdentity);
        if (extension != null) {
            return extension;
        }
        throw new ColaException("Can not find extension with ExtensionPoint: " + targetClz + " BizScenario:" + bizScenarioUniqueIdentity);
    }

    private <Ext> Ext firstTry(Class<Ext> targetClz, String bizScenario) {
        return (Ext)this.extensionRepository.getExtensionRepo().get(new ExtensionCoordinate(targetClz.getName(), bizScenario));
    }

    private <Ext> Ext loopTry(Class<Ext> targetClz, String bizScenario) {
        if (bizScenario == null) {
            return null;
        }
        int lastDotIndex = bizScenario.lastIndexOf(".");
        while (lastDotIndex != -1) {
            bizScenario = bizScenario.substring(0, lastDotIndex);
            ExtensionPointI extension = this.extensionRepository.getExtensionRepo().get(new ExtensionCoordinate(targetClz.getName(), bizScenario));
            if (extension != null) {
                return (Ext)extension;
            }
            lastDotIndex = bizScenario.lastIndexOf(".");
        }
        return null;
    }

    private void checkNull(BizScenario bizScenario) {
        if (bizScenario == null) {
            throw new ColaException("BizScenario can not be null for extension");
        }
    }
}

