/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.logger;

import com.alibaba.cola.logger.Logger;
import com.alibaba.cola.logger.SLFJLogger;
import com.alibaba.cola.logger.SysLogger;

public class LoggerFactory {
    private static boolean useSysLogger = false;

    public static Logger getLogger(Class<?> clazz) {
        if (useSysLogger) {
            return SysLogger.getLogger(clazz);
        }
        org.slf4j.Logger slfjLogger = org.slf4j.LoggerFactory.getLogger(clazz);
        return new SLFJLogger(slfjLogger);
    }

    public static Logger getLogger(String loggerName) {
        if (useSysLogger) {
            return SysLogger.getLogger(loggerName);
        }
        org.slf4j.Logger slfjLogger = org.slf4j.LoggerFactory.getLogger((String)loggerName);
        return new SLFJLogger(slfjLogger);
    }

    public static void activateSysLogger() {
        useSysLogger = true;
    }

    public static void deactivateSysLogger() {
        useSysLogger = false;
    }
}

