package darabonba.core.internal.sync;

import com.aliyun.core.utils.FunctionalUtils;
import darabonba.core.sync.ContentStreamProvider;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileContentStreamProvider implements ContentStreamProvider {
    private final Path filePath;
    private final long offset;
    private InputStream currentStream;

    public FileContentStreamProvider(Path filePath) {
        this(filePath, 0);
    }

    public FileContentStreamProvider(Path filePath, long offset) {
        this.filePath = filePath;
        this.offset = offset;
    }

    public long getOffset() {
        return offset;
    }

    @Override
    public InputStream newStream() {
        closeCurrentStream();
        currentStream = FunctionalUtils.invokeSafely(() -> Files.newInputStream(filePath));
        FunctionalUtils.invokeSafely(() -> currentStream.skip(offset));
        return currentStream;
    }

    private void closeCurrentStream() {
        if (currentStream != null) {
            FunctionalUtils.invokeSafely(currentStream::close);
            currentStream = null;
        }
    }
}