package darabonba.core.policy.retry;

import com.aliyun.core.execption.AliyunException;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

import static java.util.Collections.unmodifiableSet;

public class RetryUtil {
    public static final int TOKEN_BUCKET_SIZE = 500;
    public static final Duration BASE_DELAY = Duration.ofMillis(100);
    public static final Duration THROTTLED_BASE_DELAY = Duration.ofMillis(500);
    public static final Duration MAX_BACKOFF = Duration.ofMillis(20_000);
    public static final Integer DEFAULT_MAX_RETRIES = 3;
    private static int HTTP_STATUS_TOO_MANY_REQUESTS = 429;
    public static final Set<Integer> RETRYABLE_STATUS_CODES;
    public static final Set<Class<? extends Exception>> RETRYABLE_EXCEPTIONS;

    static {
        Set<Integer> retryableStatusCodes = new HashSet<>();
        retryableStatusCodes.add(HttpURLConnection.HTTP_CLIENT_TIMEOUT);
        retryableStatusCodes.add(HTTP_STATUS_TOO_MANY_REQUESTS);
        retryableStatusCodes.add(HttpURLConnection.HTTP_INTERNAL_ERROR);
        retryableStatusCodes.add(HttpURLConnection.HTTP_BAD_GATEWAY);
        retryableStatusCodes.add(HttpURLConnection.HTTP_UNAVAILABLE);
        retryableStatusCodes.add(HttpURLConnection.HTTP_GATEWAY_TIMEOUT);
        RETRYABLE_STATUS_CODES = unmodifiableSet(retryableStatusCodes);

        Set<Class<? extends Exception>> retryableExceptions = new HashSet<>();
        retryableExceptions.add(AliyunException.class);
        retryableExceptions.add(IOException.class);
        RETRYABLE_EXCEPTIONS = unmodifiableSet(retryableExceptions);
    }
}
