package darabonba.core;

import com.aliyun.core.utils.FunctionalUtils;
import com.aliyun.core.utils.IOUtils;
import com.aliyun.core.utils.Validate;

import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class ResponseBytes<ResponseT> {
    private final ResponseT response;
    private final byte[] bytes;

    ResponseBytes(ResponseT response, byte[] bytes) {
        this.response = Validate.paramNotNull(response, "response");
        this.bytes = Validate.paramNotNull(bytes, "bytes");
    }

    public static <ResponseT> ResponseBytes<ResponseT> fromInputStream(ResponseT response, InputStream stream)
            throws UncheckedIOException {
        return new ResponseBytes<>(response, FunctionalUtils.invokeSafely(() -> IOUtils.toByteArray(stream)));
    }

    public static <ResponseT> ResponseBytes<ResponseT> fromByteArray(ResponseT response, byte[] bytes) {
        return new ResponseBytes<>(response, Arrays.copyOf(bytes, bytes.length));
    }

    public static <ResponseT> ResponseBytes<ResponseT> fromByteArrayUnsafe(ResponseT response, byte[] bytes) {
        return new ResponseBytes<>(response, bytes);
    }

    public ResponseT response() {
        return response;
    }

    public final ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(bytes).asReadOnlyBuffer();
    }

    public final byte[] asByteArray() {
        return Arrays.copyOf(bytes, bytes.length);
    }

    public final byte[] asByteArrayUnsafe() {
        return bytes;
    }
}
