package darabonba.core.client;

import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.signature.Signer;
import com.aliyun.core.http.HttpClient;
import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.AttributeMap;
import darabonba.core.ServiceConfiguration;
import darabonba.core.interceptor.InterceptorChain;
import darabonba.core.policy.retry.RetryPolicy;

import java.net.URI;
import java.time.Duration;

public final class ClientOption<T> extends AttributeMap.Key<T> {

    public static final ClientOption<String> SERVICE_NAME = new ClientOption<>(String.class);

    public static final ClientOption<String> REGION = new ClientOption<>(String.class);

    public static final ClientOption<String> ENDPOINT_TYPE = new ClientOption<>(String.class);

    public static final ClientOption<String> ENDPOINT = new ClientOption<>(String.class);

    public static final ClientOption<URI> ENDPOINT_URI = new ClientOption<>(URI.class);

    public static final ClientOption<ServiceConfiguration> SERVICE_CONFIGURATION = new ClientOption<>(ServiceConfiguration.class);

    public static final ClientOption<Duration> CONNECT_TIMEOUT = new ClientOption<>(Duration.class);

    public static final ClientOption<Duration> RESPONSE_TIMEOUT = new ClientOption<>(Duration.class);

    public static final ClientOption<Duration> READ_TIMEOUT = new ClientOption<>(Duration.class);

    public static final ClientOption<Duration> WRITE_TIMEOUT = new ClientOption<>(Duration.class);

    public static final ClientOption<RetryPolicy> RETRY_POLICY = new ClientOption<>(RetryPolicy.class);

    public static final ClientOption<InterceptorChain> INTERCEPTOR_CHAIN = new ClientOption<>(new UnsafeValueType(InterceptorChain.class));

    public static final ClientOption<String> HTTP_PROTOCOL = new ClientOption<>(String.class);

    public static final ClientOption<Integer> HTTP_PORT = new ClientOption<>(Integer.class);

    public static final ClientOption<HttpMethod> HTTP_METHOD = new ClientOption<>(HttpMethod.class);

    public static final ClientOption<HttpHeaders> ADDITIONAL_HTTP_HEADERS = new ClientOption<>(new UnsafeValueType(HttpHeaders.class));

    public static final ClientOption<ICredentialProvider> CREDENTIALS_PROVIDER = new ClientOption<>(ICredentialProvider.class);

    public static final ClientOption<HttpClient> ASYNC_HTTP_CLIENT = new ClientOption<>(HttpClient.class);

    public static final ClientOption<Signer> SIGNER = new ClientOption<>(Signer.class);

    public static final ClientOption<Long> CLOCK_SKEW_DIFF = new ClientOption<>(Long.class);

    public static final ClientOption<String> USER_AGENT = new ClientOption<>(String.class);
    public static final ClientOption<String> USER_AGENT_SERVICE_SUFFIX = new ClientOption<>(String.class);
    public static final ClientOption<String> USER_AGENT_USER_SUFFIX = new ClientOption<>(String.class);

    protected ClientOption(Class<T> valueType) {
        super(valueType);
    }

    protected ClientOption(UnsafeValueType unsafeValueType) {
        super(unsafeValueType);
    }
}
