package darabonba.core.client;

import com.aliyun.core.http.HttpHeaders;
import darabonba.core.policy.retry.RetryPolicy;

import java.time.Duration;

public final class ClientOverrideConfiguration {
    private String endpointOverride;
    private String endpointType;
    private Duration connectTimeout;
    private Duration responseTimeout;
//    private Duration readTimeout;
//    private Duration writeTimeout;
    private RetryPolicy retryPolicy;
    private HttpHeaders httpHeaders;
    private String protocol;
    private String additionalUserAgent;
//    private InterceptorChain interceptorChain;

    private ClientOverrideConfiguration() {
    }

    public static ClientOverrideConfiguration create() {
        return new ClientOverrideConfiguration();
    }

    public String endpointOverride() {
        return this.endpointOverride;
    }

    public ClientOverrideConfiguration setEndpointOverride(String endpointOverride) {
        this.endpointOverride = endpointOverride;
        return this;
    }

    public String endpointType() {
        return this.endpointType;
    }

    public ClientOverrideConfiguration setEndpointType(String endpointType) {
        this.endpointType = endpointType;
        return this;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public ClientOverrideConfiguration setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

//    public Duration readTimeout() {
//        return this.readTimeout;
//    }
//
//    public ClientOverrideConfiguration setReadTimeout(Duration readTimeout) {
//        this.readTimeout = readTimeout;
//        return this;
//    }

    public Duration responseTimeout() {
        return this.responseTimeout;
    }

    public ClientOverrideConfiguration setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
        return this;
    }

//    public Duration writeTimeout() {
//        return this.writeTimeout;
//    }
//
//    public ClientOverrideConfiguration setWriteTimeout(Duration writeTimeout) {
//        this.writeTimeout = writeTimeout;
//        return this;
//    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public ClientOverrideConfiguration setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public HttpHeaders httpHeaders() {
        return this.httpHeaders;
    }

    public ClientOverrideConfiguration setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public String protocol() {
        return protocol;
    }

    public ClientOverrideConfiguration setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String additionalUserAgent() {
        return additionalUserAgent;
    }

    public ClientOverrideConfiguration setAdditionalUserAgent(String additionalUserAgent) {
        this.additionalUserAgent = additionalUserAgent;
        return this;
    }

//    private InterceptorChain interceptorChain() {
//        return interceptorChain;
//    }
//
//    private void setInterceptorChain(InterceptorChain interceptorChain) {
//        this.interceptorChain = interceptorChain;
//    }
}
