package darabonba.core.policy.retry.conditions;

import darabonba.core.policy.retry.RetryPolicyContext;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class OrRetryCondition implements RetryCondition {

    private final Set<RetryCondition> conditions = new LinkedHashSet<>();

    private OrRetryCondition(RetryCondition... conditions) {
        Collections.addAll(this.conditions, conditions);
    }

    public static OrRetryCondition create(RetryCondition... conditions) {
        return new OrRetryCondition(conditions);
    }

    /**
     * @return True if any condition returns true. False otherwise.
     */
    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        return conditions.stream().anyMatch(r -> r.shouldRetry(context));
    }

    @Override
    public void requestWillNotBeRetried(RetryPolicyContext context) {
        conditions.forEach(c -> c.requestWillNotBeRetried(context));
    }

    @Override
    public void requestSucceeded(RetryPolicyContext context) {
        conditions.forEach(c -> c.requestSucceeded(context));
    }
}
