package darabonba.core;

import darabonba.core.sse.SSEResponseIterator;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

public class ResponseIterable<T> implements Iterable<T> {
    private final ResponseIterator<T> iterator;

    public ResponseIterable(ResponseIterator<T> iterator) {
        super();
        this.iterator = iterator;
    }

    @Override
    public @NotNull ResponseIterator<T> iterator() {
        return iterator;
    }

    public Map<String, String> getHeaders() {
        if (iterator instanceof SSEResponseIterator) {
            return ((SSEResponseIterator<T>) iterator).getHeaders();
        }
        return null;
    }

    public Integer getStatusCode() {
        if (iterator instanceof SSEResponseIterator) {
            return ((SSEResponseIterator<T>) iterator).getStatusCode();
        }
        return null;
    }

}

