package darabonba.core.policy.retry.conditions;

import darabonba.core.policy.retry.RetryPolicyContext;
import darabonba.core.policy.retry.RetryUtil;

@FunctionalInterface
public interface RetryCondition {

    boolean shouldRetry(RetryPolicyContext context);

    default void requestWillNotBeRetried(RetryPolicyContext context) {
    }

    default void requestSucceeded(RetryPolicyContext context) {
    }

    static RetryCondition defaultRetryCondition() {
        return OrRetryCondition.create(
                StatusCodeCondition.create(RetryUtil.RETRYABLE_STATUS_CODES),
                ExceptionsCondition.create(RetryUtil.RETRYABLE_EXCEPTIONS));
    }

    /**
     * A retry condition that will NEVER allow retries.
     */
    static RetryCondition none() {
        return MaxRetriesCondition.create(0);
    }
}
