/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client;

import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.TSDB;
import com.aliyun.hitsdb.client.TSDBClientFactory;
import com.aliyun.hitsdb.client.TSDBConfig;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.QueryCallback;
import com.aliyun.hitsdb.client.exception.NotImplementedException;
import com.aliyun.hitsdb.client.exception.http.HttpUnknowStatusException;
import com.aliyun.hitsdb.client.http.Host;
import com.aliyun.hitsdb.client.util.FileWatcher;
import com.aliyun.hitsdb.client.util.HealthManager;
import com.aliyun.hitsdb.client.util.HealthWatcher;
import com.aliyun.hitsdb.client.util.PropKit;
import com.aliyun.hitsdb.client.util.WatchManager;
import com.aliyun.hitsdb.client.value.Result;
import com.aliyun.hitsdb.client.value.request.DeleteMetaRequest;
import com.aliyun.hitsdb.client.value.request.LastPointQuery;
import com.aliyun.hitsdb.client.value.request.LookupRequest;
import com.aliyun.hitsdb.client.value.request.LookupTagFilter;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.MultiFieldQuery;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.request.Query;
import com.aliyun.hitsdb.client.value.request.Timeline;
import com.aliyun.hitsdb.client.value.response.LastDataValue;
import com.aliyun.hitsdb.client.value.response.LookupResult;
import com.aliyun.hitsdb.client.value.response.MultiFieldQueryLastResult;
import com.aliyun.hitsdb.client.value.response.MultiFieldQueryResult;
import com.aliyun.hitsdb.client.value.response.QueryResult;
import com.aliyun.hitsdb.client.value.response.SQLResult;
import com.aliyun.hitsdb.client.value.response.TagResult;
import com.aliyun.hitsdb.client.value.response.UserResult;
import com.aliyun.hitsdb.client.value.type.Suggest;
import com.aliyun.hitsdb.client.value.type.UserPrivilege;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalTSDBClient
implements TSDB {
    private static final Logger LOG = LoggerFactory.getLogger(BalTSDBClient.class);
    private Config config;
    private volatile Map<String, TSDB> healthClientMap = new ConcurrentHashMap<String, TSDB>();
    private volatile Map<String, TSDB> nonHealthClientMap = new ConcurrentHashMap<String, TSDB>();
    private volatile List<TSDB> clients = new ArrayList<TSDB>();
    private AtomicBoolean SYNC = new AtomicBoolean(true);
    private WatchManager watchManager;
    private HealthManager healthManager;
    private volatile int idx = 0;
    private static final int DEFAULT_WATCH_FILE_INTERVALS = 2;
    private final HealthWatcher healthWatcher = new HealthWatcher(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void health(String host, boolean health) {
            if (health) {
                if (BalTSDBClient.this.healthClientMap.containsKey(host)) {
                    LOG.info("the tsdb is work well : {}", (Object)host);
                } else {
                    TSDB client = (TSDB)BalTSDBClient.this.nonHealthClientMap.remove(host);
                    BalTSDBClient.this.healthClientMap.put(host, client);
                    ArrayList list = new ArrayList();
                    list.addAll(BalTSDBClient.this.healthClientMap.values());
                    BalTSDBClient.this.SYNC.set(false);
                    try {
                        List temp = BalTSDBClient.this.clients;
                        BalTSDBClient.this.clients = list;
                        temp.clear();
                    }
                    finally {
                        BalTSDBClient.this.SYNC.set(true);
                    }
                }
            } else {
                BalTSDBClient.this.SYNC.set(false);
                try {
                    LOG.info("the host: {} may be not health, so remove it", (Object)host);
                    TSDB client = (TSDB)BalTSDBClient.this.healthClientMap.remove(host);
                    BalTSDBClient.this.nonHealthClientMap.put(host, client);
                    ArrayList list = new ArrayList();
                    list.addAll(BalTSDBClient.this.healthClientMap.values());
                    BalTSDBClient.this.clients = list;
                }
                finally {
                    BalTSDBClient.this.SYNC.set(true);
                }
            }
        }
    };
    private static int MAX_RETRY_SIZE = 3;

    public BalTSDBClient(File configFile) throws IOException {
        this(configFile, null);
    }

    public BalTSDBClient(String configFilePath) throws IOException {
        this(new File(configFilePath));
    }

    public BalTSDBClient(File configFile, AbstractBatchPutCallback<?> callback) throws IOException {
        this.initFileWatchManager(configFile);
        TSDBConfig config = this.loadConfig(configFile);
        if (callback != null) {
            config.setBatchPutCallback(callback);
        }
        this.init(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TSDBConfig loadConfig(File configFile) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileReader(configFile));
        PropKit propKit = new PropKit(properties);
        TSDBConfig.Builder builder = TSDBConfig.builder();
        if (propKit.containsKey("host")) {
            if (propKit.containsKey("port")) {
                builder.addAddress(propKit.get("host").trim(), propKit.getInt("port"));
            } else {
                builder.addAddress(propKit.get("host").trim());
            }
        } else {
            if (!propKit.containsKey("address")) throw new IllegalStateException("Specify at least one tsdb address");
            String address = propKit.get("address");
            String[] hosts = address.split(",");
            if (hosts.length <= 0) throw new IllegalStateException("the address must not be empty");
            for (String hostString : hosts) {
                String[] hh = hostString.split(":");
                if (hh.length == 1) {
                    builder.addAddress(hh[0].trim());
                    continue;
                }
                builder.addAddress(hh[0].trim(), Integer.parseInt(hh[1]));
            }
        }
        if (propKit.containsKey("batchPutSize")) {
            builder.batchPutSize(propKit.getInt("batchPutSize"));
        }
        if (propKit.containsKey("batchPutTimeLimit")) {
            builder.batchPutTimeLimit(propKit.getInt("batchPutTimeLimit"));
        }
        if (propKit.containsKey("batchPutBufferSize")) {
            builder.batchPutBufferSize(propKit.getInt("batchPutBufferSize"));
        }
        if (propKit.containsKey("batchPutRetryCount")) {
            builder.batchPutRetryCount(propKit.getInt("batchPutRetryCount"));
        }
        if (propKit.containsKey("httpConnectionPool")) {
            builder.httpConnectionPool(propKit.getInt("httpConnectionPool"));
        }
        if (propKit.containsKey("httpConnectTimeout")) {
            builder.httpConnectTimeout(propKit.getInt("httpConnectTimeout"));
        }
        if (propKit.containsKey("putRequestLimit")) {
            builder.putRequestLimit(propKit.getInt("putRequestLimit"));
        }
        if (propKit.containsKey("batchPutConsumerThreadCount")) {
            builder.batchPutConsumerThreadCount(propKit.getInt("batchPutConsumerThreadCount"));
        }
        if (propKit.containsKey("httpCompress")) {
            builder.httpCompress(propKit.getBoolean("httpCompress"));
        }
        if (propKit.containsKey("ioThreadCount")) {
            builder.ioThreadCount(propKit.getInt("ioThreadCount"));
        }
        if (propKit.containsKey("backpressure")) {
            builder.backpressure(propKit.getBoolean("backpressure"));
        }
        if (propKit.containsKey("httpConnectionLiveTime")) {
            builder.httpConnectionLiveTime(propKit.getInt("httpConnectionLiveTime"));
        }
        if (propKit.containsKey("httpKeepaliveTime")) {
            builder.httpKeepaliveTime(propKit.getInt("httpKeepaliveTime"));
        }
        if (propKit.containsKey("maxTPS")) {
            builder.maxTPS(propKit.getInt("maxTPS"));
        }
        if (!propKit.containsKey("asyncPut")) return builder.config();
        builder.asyncPut(propKit.getBoolean("asyncPut"));
        return builder.config();
    }

    private void initFileWatchManager(File configFile) {
        this.watchManager = new WatchManager();
        this.watchManager.setIntervalSeconds(2);
        this.watchManager.watchFile(configFile, new FileWatcher(){

            @Override
            public void fileModified(File file) {
                LOG.info("the file {} is changed", (Object)file.getAbsolutePath());
                try {
                    BalTSDBClient.this.doHandle(file);
                }
                catch (Exception e) {
                    LOG.error("Do handle changed file error", (Throwable)e);
                }
            }
        });
        this.watchManager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandle(File file) {
        LOG.info("the config file {} has been modified, so reload it", (Object)file.getName());
        TSDBConfig newConfig = null;
        try {
            newConfig = this.loadConfig(file);
        }
        catch (IOException e) {
            LOG.error("Load config file error", (Throwable)e);
        }
        if (newConfig == null) {
            return;
        }
        ConcurrentHashMap<String, TSDB> tHealthMap = new ConcurrentHashMap<String, TSDB>();
        ConcurrentHashMap<String, TSDB> tNonHealthMap = new ConcurrentHashMap<String, TSDB>();
        ArrayList<TSDB> tClients = new ArrayList<TSDB>();
        Map<String, TSDB> thHolder = this.healthClientMap;
        Map<String, TSDB> tnhHolder = this.nonHealthClientMap;
        List<TSDB> tcHolder = this.clients;
        Config tConfigHolder = this.config;
        List<Object> wathers = new ArrayList<String>();
        this.SYNC.set(false);
        try {
            wathers.clear();
            for (String string : this.healthClientMap.keySet()) {
                this.healthManager.unWatch(string);
            }
            for (String string : this.nonHealthClientMap.keySet()) {
                this.healthManager.unWatch(string);
            }
            this.config = newConfig;
            this.nonHealthClientMap = tNonHealthMap;
            this.healthClientMap = tHealthMap;
            this.clients = tClients;
            wathers = this.initInstance(this.config);
            LOG.info("success load config and replace client instance");
            try {
                for (TSDB tSDB : thHolder.values()) {
                    tSDB.close();
                }
                for (TSDB tSDB : tnhHolder.values()) {
                    tSDB.close();
                }
                tcHolder.clear();
            }
            catch (Exception e) {
                LOG.error("closed the origin tsdb client instance error", (Throwable)e);
            }
        }
        catch (Exception e) {
            wathers.clear();
            try {
                for (TSDB tsdb : this.healthClientMap.values()) {
                    tsdb.close();
                }
                for (TSDB tsdb : this.nonHealthClientMap.values()) {
                    tsdb.close();
                }
            }
            catch (IOException iOException) {
                LOG.error("closed the new tsdb client instance error", (Throwable)iOException);
            }
            this.clients.clear();
            LOG.info("An error occurred, so the original configuration is maintained");
            this.healthClientMap = thHolder;
            this.nonHealthClientMap = tnhHolder;
            this.clients = tcHolder;
            this.config = tConfigHolder;
            wathers.addAll(this.healthClientMap.keySet());
            wathers.addAll(this.nonHealthClientMap.keySet());
        }
        finally {
            this.SYNC.set(true);
        }
        for (String string : wathers) {
            this.healthManager.watch(string, this.healthWatcher);
        }
    }

    private void initHealthWatchManager() {
        this.healthManager = new HealthManager();
        this.healthManager.setIntervalSeconds(2);
        this.healthManager.start();
    }

    public BalTSDBClient(Config config) {
        this.init(config);
    }

    private void init(Config config) {
        this.config = config;
        this.initHealthWatchManager();
        List<String> wathers = this.initInstance(config);
        for (String host : wathers) {
            this.healthManager.watch(host, this.healthWatcher);
        }
    }

    public List<String> initInstance(Config config) {
        List<Host> hosts = config.getAddresses();
        ArrayList<String> wathers = new ArrayList<String>();
        if (!hosts.isEmpty()) {
            for (Host host : hosts) {
                Config newConfig = config.copy(host.getIp(), host.getPort());
                wathers.add(this.initClient(newConfig));
            }
        } else if (config.getHost() != null && !config.getHost().isEmpty()) {
            wathers.add(this.initClient(config));
        } else {
            throw new IllegalStateException("Specify at least one tsdb address, but there is zero");
        }
        return wathers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initClient(Config config) {
        TSDB client = TSDBClientFactory.connect(config);
        String host = config.getHost() + ":" + config.getPort();
        this.SYNC.set(false);
        try {
            this.healthClientMap.put(host, client);
            this.clients.add(client);
        }
        finally {
            this.SYNC.set(true);
        }
        return host;
    }

    private TSDB client() {
        TSDB client;
        while (!this.SYNC.get()) {
        }
        if (this.clients.isEmpty()) {
            throw new RuntimeException("The number of available clients is zero, please check it");
        }
        int index = this.idx++;
        this.idx %= this.clients.size();
        if (index >= this.clients.size()) {
            index = 0;
        }
        if ((client = this.clients.get(index)) == null) {
            throw new RuntimeException("The client is null");
        }
        return client;
    }

    @Override
    public void put(Point point) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().put(point);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void put(Point ... points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().put(points);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void put(Collection<Point> points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().put(points);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public Result putSync(Collection<Point> points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().putSync(points);
            }
            catch (Exception e) {
                for (Point point : points) {
                }
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public Result putSync(Point ... points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().putSync(points);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public <T extends Result> T putSync(Collection<Point> points, Class<T> resultType) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().putSync(points, resultType);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public <T extends Result> T putSync(Class<T> resultType, Collection<Point> points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().putSync(resultType, points);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public <T extends Result> T putSync(Class<T> resultType, Point ... points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().putSync(resultType, points);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void query(Query query, QueryCallback callback) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().query(query, callback);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<QueryResult> query(Query query) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().query(query);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public SQLResult queryBySQL(String sql) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().queryBySQL(sql);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<QueryResult> last(Query query, int num) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().last(query, num);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void delete(Query query) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().delete(query);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteData(String metric, long startTime, long endTime) throws HttpUnknowStatusException {
        this.deleteData(metric, null, null, startTime, endTime);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, long startTime, long endTime) throws HttpUnknowStatusException {
        this.deleteData(metric, tags, null, startTime, endTime);
    }

    @Override
    public void deleteData(String metric, List<String> fields, long startTime, long endTime) throws HttpUnknowStatusException {
        this.deleteData(metric, null, fields, startTime, endTime);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, List<String> fields, long startTime, long endTime) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteData(metric, tags, fields, startTime, endTime);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteData(String metric, Date startDate, Date endDate) throws HttpUnknowStatusException {
        this.deleteData(metric, null, null, startDate, endDate);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, Date startDate, Date endDate) throws HttpUnknowStatusException {
        this.deleteData(metric, tags, null, startDate, endDate);
    }

    @Override
    public void deleteData(String metric, List<String> fields, Date startDate, Date endDate) throws HttpUnknowStatusException {
        this.deleteData(metric, null, fields, startDate, endDate);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, List<String> fields, Date startDate, Date endDate) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteData(metric, tags, fields, startDate, endDate);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteMeta(String metric, Map<String, String> tags) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteMeta(metric, tags);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteMeta(String metric, List<String> fields, Map<String, String> tags) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteMeta(metric, fields, tags);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteMeta(Timeline timeline) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteMeta(timeline);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteMeta(String metric, Map<String, String> tags, boolean deleteData, boolean recursive) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteMeta(metric, tags, deleteData, recursive);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteMeta(String metric, List<String> fields, Map<String, String> tags, boolean deleteData, boolean recursive) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteMeta(metric, fields, tags, deleteData, recursive);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void deleteMeta(DeleteMetaRequest request) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().deleteMeta(request);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void ttl(int lifetime) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().ttl(lifetime);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void ttl(int lifetime, TimeUnit unit) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().ttl(lifetime, unit);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public int ttl() throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().ttl();
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<String> suggest(Suggest type, String prefix, int max) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().suggest(type, prefix, max);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<String> suggest(Suggest type, String metric, String prefix, int max) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().suggest(type, metric, prefix, max);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<LookupResult> lookup(String metric, List<LookupTagFilter> tags, int max) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().lookup(metric, tags, max);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<LookupResult> lookup(LookupRequest lookupRequest) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().lookup(lookupRequest);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<TagResult> dumpMeta(String tagkey, String tagValuePrefix, int max) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().dumpMeta(tagkey, tagValuePrefix, max);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<TagResult> dumpMeta(String metric, String tagkey, String tagValuePrefix, int max) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().dumpMeta(metric, tagkey, tagValuePrefix, max);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<String> dumpMetric(String tagkey, String tagValuePrefix, int max) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().dumpMetric(tagkey, tagValuePrefix, max);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<LastDataValue> queryLast(Collection<Timeline> timelines) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().queryLast(timelines);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<LastDataValue> queryLast(Timeline ... timelines) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().queryLast(timelines);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<LastDataValue> queryLast(List<String> tsuids) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().queryLast(tsuids);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<LastDataValue> queryLast(LastPointQuery query) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().queryLast(query);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public boolean truncate() throws HttpUnknowStatusException {
        return this.client().truncate();
    }

    @Override
    public List<LastDataValue> queryLast(String ... tsuids) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().queryLast(tsuids);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public <T extends Result> T multiFieldPutSync(MultiFieldPoint point, Class<T> resultType) {
        return this.multiFieldPutSync(Collections.singletonList(point), resultType);
    }

    @Override
    public <T extends Result> T multiFieldPutSync(Collection<MultiFieldPoint> points, Class<T> resultType) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().multiFieldPutSync(points, resultType);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public Result multiFieldPutSync(MultiFieldPoint ... points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().multiFieldPutSync(points);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public Result multiFieldPutSync(Collection<MultiFieldPoint> points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().multiFieldPutSync(points);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void multiFieldPut(MultiFieldPoint point) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().multiFieldPut(point);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void multiFieldPut(MultiFieldPoint ... points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().multiFieldPut(points);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void multiFieldPut(Collection<MultiFieldPoint> points) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().multiFieldPut(points);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<MultiFieldQueryResult> multiFieldQuery(MultiFieldQuery query) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().multiFieldQuery(query);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<MultiFieldQueryLastResult> multiFieldQueryLast(LastPointQuery lastPointQuery) throws HttpUnknowStatusException {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                return this.client().multiFieldQueryLast(lastPointQuery);
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void createUser(String username, String password, UserPrivilege privilege) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().createUser(username, password, privilege);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void dropUser(String username) {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                this.client().dropUser(username);
                return;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public List<UserResult> listUsers() {
        Exception exception = null;
        for (int i = 0; i < MAX_RETRY_SIZE; ++i) {
            try {
                List<UserResult> result = this.client().listUsers();
                return result;
            }
            catch (Exception e) {
                exception = e;
                continue;
            }
        }
        throw new RuntimeException(exception);
    }

    @Override
    public void flush() {
        throw new NotImplementedException();
    }

    @Override
    public String version() throws HttpUnknowStatusException {
        return this.client().version();
    }

    @Override
    public Map<String, String> getVersionInfo() throws HttpUnknowStatusException {
        return this.client().getVersionInfo();
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean force) throws IOException {
        this.SYNC.set(false);
        try {
            for (TSDB client : this.healthClientMap.values()) {
                client.close(force);
            }
            for (TSDB client : this.nonHealthClientMap.values()) {
                client.close(force);
            }
            this.clients.clear();
            if (this.watchManager != null) {
                this.watchManager.stop();
            }
            if (this.healthManager != null) {
                this.healthManager.stop();
            }
        }
        finally {
            this.SYNC.set(true);
        }
    }

    @Override
    public void put(Collection<Point> points, AbstractBatchPutCallback batchPutCallback) {
        throw new NotImplementedException();
    }

    @Override
    public void multiFieldPut(Collection<MultiFieldPoint> points, AbstractMultiFieldBatchPutCallback batchPutCallback) {
        throw new NotImplementedException();
    }
}

