/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.HAPolicy;
import com.aliyun.hitsdb.client.TSDB;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.callback.AbstractMultiFieldBatchPutCallback;
import com.aliyun.hitsdb.client.callback.QueryCallback;
import com.aliyun.hitsdb.client.callback.http.BatchPutHttpResponseCallback;
import com.aliyun.hitsdb.client.callback.http.HttpResponseCallbackFactory;
import com.aliyun.hitsdb.client.callback.http.MultiFieldBatchPutHttpResponseCallback;
import com.aliyun.hitsdb.client.consumer.Consumer;
import com.aliyun.hitsdb.client.consumer.ConsumerFactory;
import com.aliyun.hitsdb.client.exception.http.HttpClientException;
import com.aliyun.hitsdb.client.exception.http.HttpClientInitException;
import com.aliyun.hitsdb.client.exception.http.HttpServerErrorException;
import com.aliyun.hitsdb.client.exception.http.HttpServerNotSupportException;
import com.aliyun.hitsdb.client.exception.http.HttpServerUnauthorizedException;
import com.aliyun.hitsdb.client.exception.http.HttpUnknowStatusException;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.http.HttpClientFactory;
import com.aliyun.hitsdb.client.http.response.HttpStatus;
import com.aliyun.hitsdb.client.http.response.ResultResponse;
import com.aliyun.hitsdb.client.queue.DataQueue;
import com.aliyun.hitsdb.client.queue.DataQueueFactory;
import com.aliyun.hitsdb.client.util.LinkedHashMapUtils;
import com.aliyun.hitsdb.client.util.guava.RateLimiter;
import com.aliyun.hitsdb.client.value.JSONValue;
import com.aliyun.hitsdb.client.value.Result;
import com.aliyun.hitsdb.client.value.request.AbstractPoint;
import com.aliyun.hitsdb.client.value.request.DeleteMetaRequest;
import com.aliyun.hitsdb.client.value.request.DumpMetaValue;
import com.aliyun.hitsdb.client.value.request.LastPointQuery;
import com.aliyun.hitsdb.client.value.request.LookupRequest;
import com.aliyun.hitsdb.client.value.request.LookupTagFilter;
import com.aliyun.hitsdb.client.value.request.MetricTimeRange;
import com.aliyun.hitsdb.client.value.request.MultiFieldPoint;
import com.aliyun.hitsdb.client.value.request.MultiFieldQuery;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.request.PointsCollection;
import com.aliyun.hitsdb.client.value.request.Query;
import com.aliyun.hitsdb.client.value.request.SQLValue;
import com.aliyun.hitsdb.client.value.request.SuggestValue;
import com.aliyun.hitsdb.client.value.request.TTLValue;
import com.aliyun.hitsdb.client.value.request.Timeline;
import com.aliyun.hitsdb.client.value.request.UniqueUtil;
import com.aliyun.hitsdb.client.value.response.LastDataValue;
import com.aliyun.hitsdb.client.value.response.LookupResult;
import com.aliyun.hitsdb.client.value.response.MultiFieldQueryLastResult;
import com.aliyun.hitsdb.client.value.response.MultiFieldQueryResult;
import com.aliyun.hitsdb.client.value.response.MultiValuedQueryResult;
import com.aliyun.hitsdb.client.value.response.MultiValuedTupleComparator;
import com.aliyun.hitsdb.client.value.response.QueryResult;
import com.aliyun.hitsdb.client.value.response.SQLResult;
import com.aliyun.hitsdb.client.value.response.TTLResult;
import com.aliyun.hitsdb.client.value.response.TagResult;
import com.aliyun.hitsdb.client.value.response.UserResult;
import com.aliyun.hitsdb.client.value.response.batch.DetailsResult;
import com.aliyun.hitsdb.client.value.response.batch.IgnoreErrorsResult;
import com.aliyun.hitsdb.client.value.response.batch.MultiFieldDetailsResult;
import com.aliyun.hitsdb.client.value.response.batch.MultiFieldIgnoreErrorsResult;
import com.aliyun.hitsdb.client.value.response.batch.SummaryResult;
import com.aliyun.hitsdb.client.value.type.Suggest;
import com.aliyun.hitsdb.client.value.type.UserPrivilege;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSDBClient
implements TSDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSDBClient.class);
    private final DataQueue queue;
    private final Consumer consumer;
    private final HttpResponseCallbackFactory httpResponseCallbackFactory;
    protected final boolean httpCompress;
    protected final HttpClient httpclient;
    private final HttpClient secondaryClient;
    private RateLimiter rateLimiter;
    private final Config config;
    private static Field queryDeleteField;
    private static final String EMPTY_HOLDER;
    private static final String VIP_API = "/api/vip_health";
    private static final String EMPTY_JSON_STR;

    public TSDBClient(Config config) throws HttpClientInitException {
        if (config.getHAPolicy() == null) {
            this.config = config;
            this.httpclient = HttpClientFactory.createHttpClient(config);
            this.secondaryClient = null;
        } else {
            this.config = config;
            this.httpclient = HttpClientFactory.createHttpClient(config);
            Config secondaryConfig = config.copy(config.getHAPolicy().getSecondaryHost(), config.getHAPolicy().getSecondaryPort());
            this.secondaryClient = HttpClientFactory.createHttpClient(secondaryConfig);
        }
        this.httpCompress = config.isHttpCompress();
        boolean asyncPut = config.isAsyncPut();
        int maxTPS = config.getMaxTPS();
        if (maxTPS > 0) {
            this.rateLimiter = RateLimiter.create(maxTPS);
        }
        if (asyncPut) {
            this.httpResponseCallbackFactory = this.httpclient.getHttpResponseCallbackFactory();
            int batchPutBufferSize = config.getBatchPutBufferSize();
            int multiFieldBatchPutBufferSize = config.getMultiFieldBatchPutBufferSize();
            int batchPutTimeLimit = config.getBatchPutTimeLimit();
            boolean backpressure = config.isBackpressure();
            this.queue = DataQueueFactory.createDataPointQueue(batchPutBufferSize, multiFieldBatchPutBufferSize, batchPutTimeLimit, backpressure);
            this.consumer = ConsumerFactory.createConsumer(this.queue, this.httpclient, this.rateLimiter, config);
            this.consumer.start();
        } else {
            this.httpResponseCallbackFactory = null;
            this.queue = null;
            this.consumer = null;
        }
        this.httpclient.start();
        if (this.secondaryClient != null) {
            this.secondaryClient.start();
        }
        LOGGER.info("The tsdb client has started.");
        try {
            this.checkConnection();
        }
        catch (Exception e) {
            try {
                if (asyncPut) {
                    this.consumer.stop(true);
                }
                this.httpclient.close(true);
                if (this.secondaryClient != null) {
                    this.secondaryClient.close(true);
                }
                LOGGER.info("when connected to tsdb server failure, so the tsdb client has closed");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    private void checkConnection() {
        this.httpclient.post(VIP_API, EMPTY_HOLDER);
        if (this.secondaryClient != null) {
            this.secondaryClient.post(VIP_API, EMPTY_HOLDER);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    private void forceClose() throws IOException {
        boolean async = this.config.isAsyncPut();
        if (async) {
            this.consumer.stop(true);
        }
        this.httpclient.close(true);
        if (this.secondaryClient != null) {
            this.secondaryClient.close(true);
        }
    }

    private void gracefulClose() throws IOException {
        boolean async = this.config.isAsyncPut();
        if (async) {
            this.queue.forbiddenSend();
            this.queue.waitEmpty();
            this.consumer.stop();
        }
        this.httpclient.close();
        if (this.secondaryClient != null) {
            this.secondaryClient.close();
        }
    }

    @Override
    public void close(boolean force) throws IOException {
        if (force) {
            this.forceClose();
        } else {
            this.gracefulClose();
        }
        LOGGER.info("The tsdb client has closed.");
    }

    @Override
    public void deleteData(String metric, long startTime, long endTime) {
        MetricTimeRange metricTimeRange = new MetricTimeRange(metric, startTime, endTime);
        HttpResponse httpResponse = this.httpclient.post("/api/delete_data", metricTimeRange.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, long startTime, long endTime) {
        MetricTimeRange metricTimeRange = new MetricTimeRange(metric, tags, startTime, endTime);
        HttpResponse httpResponse = this.httpclient.post("/api/delete_data", metricTimeRange.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public void deleteData(String metric, List<String> fields, long startTime, long endTime) {
        MetricTimeRange metricTimeRange = new MetricTimeRange(metric, fields, startTime, endTime);
        HttpResponse httpResponse = this.httpclient.post("/api/delete_data", metricTimeRange.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, List<String> fields, long startTime, long endTime) {
        MetricTimeRange metricTimeRange = new MetricTimeRange(metric, tags, fields, startTime, endTime);
        HttpResponse httpResponse = this.httpclient.post("/api/delete_data", metricTimeRange.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    protected void handleVoid(ResultResponse resultResponse) {
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccessNoContent: {
                return;
            }
            case ServerSuccess: {
                return;
            }
            case ServerNotSupport: {
                throw new HttpServerNotSupportException(resultResponse);
            }
            case ServerError: {
                throw new HttpServerErrorException(resultResponse);
            }
            case ServerUnauthorized: {
                throw new HttpServerUnauthorizedException(resultResponse);
            }
        }
        throw new HttpUnknowStatusException(resultResponse);
    }

    protected Object handleStatus(ResultResponse resultResponse) {
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerNotSupport: {
                throw new HttpServerNotSupportException(resultResponse);
            }
            case ServerError: {
                throw new HttpServerErrorException(resultResponse);
            }
            case ServerUnauthorized: {
                throw new HttpServerUnauthorizedException(resultResponse);
            }
            case ServerSuccessNoContent: {
                return null;
            }
            case ServerSuccess: {
                return null;
            }
        }
        throw new HttpUnknowStatusException(resultResponse);
    }

    @Override
    public void deleteData(String metric, Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        this.deleteData(metric, startTime, endTime);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        this.deleteData(metric, tags, startTime, endTime);
    }

    @Override
    public void deleteData(String metric, List<String> fields, Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        this.deleteData(metric, fields, startTime, endTime);
    }

    @Override
    public void deleteData(String metric, Map<String, String> tags, List<String> fields, Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        this.deleteData(metric, tags, fields, startTime, endTime);
    }

    @Override
    public void deleteMeta(String metric, Map<String, String> tags) {
        Timeline timeline = Timeline.metric(metric).tag(tags).build();
        this.deleteMeta(timeline);
    }

    @Override
    public void deleteMeta(String metric, List<String> fields, Map<String, String> tags) {
        Timeline timeline = Timeline.metric(metric).tag(tags).fields(fields).build();
        this.deleteMeta(timeline);
    }

    @Override
    public void deleteMeta(Timeline timeline) {
        HttpResponse httpResponse = this.httpclient.post("/api/delete_meta", timeline.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public void deleteMeta(String metric, Map<String, String> tags, boolean deleteData, boolean recursive) {
        DeleteMetaRequest request = ((DeleteMetaRequest.Builder)DeleteMetaRequest.metric(metric).tag((Map)tags)).deleteData(deleteData).recursive(recursive).build();
        this.deleteMeta(request);
    }

    @Override
    public void deleteMeta(String metric, List<String> fields, Map<String, String> tags, boolean deleteData, boolean recursive) {
        DeleteMetaRequest request = ((DeleteMetaRequest.Builder)((DeleteMetaRequest.Builder)DeleteMetaRequest.metric(metric).tag((Map)tags)).fields((List)fields)).deleteData(deleteData).recursive(recursive).build();
        this.deleteMeta(request);
    }

    @Override
    public void deleteMeta(DeleteMetaRequest request) {
        HttpResponse httpResponse = this.httpclient.post("/api/delete_meta", request.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public List<TagResult> dumpMeta(String tagkey, String tagValuePrefix, int max) {
        DumpMetaValue dumpMetaValue = new DumpMetaValue(tagkey, tagValuePrefix, max);
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.doDumpMeta(dumpMetaValue);
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.doDumpMeta(dumpMetaValue);
    }

    @Override
    public List<TagResult> dumpMeta(String metric, String tagkey, String tagValuePrefix, int max) {
        DumpMetaValue dumpMetaValue = new DumpMetaValue(metric, tagkey, tagValuePrefix, max);
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.doDumpMeta(dumpMetaValue);
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.doDumpMeta(dumpMetaValue);
    }

    private List<TagResult> doDumpMeta(DumpMetaValue dumpMetaValue) {
        HttpResponse httpResponse = this.httpclient.post("/api/dump_meta", dumpMetaValue.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List<TagResult> tagResults = TagResult.parseList(content);
                return tagResults;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public List<String> dumpMetric(String tagkey, String tagValuePrefix, int max) throws HttpUnknowStatusException {
        DumpMetaValue dumpMetaValue = new DumpMetaValue(tagkey, tagValuePrefix, max, true);
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.doDumpMetric(dumpMetaValue);
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.doDumpMetric(dumpMetaValue);
    }

    private List<String> doDumpMetric(DumpMetaValue dumpMetaValue) {
        HttpResponse httpResponse = this.httpclient.post("/api/dump_meta", dumpMetaValue.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                return JSON.parseArray((String)content, String.class);
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public void put(Point point) {
        this.queue.send(point);
    }

    public static void setTypeIfNeeded(Query query, List<QueryResult> queryResultList) {
        if (query == null || !query.isShowType()) {
            return;
        }
        Class<?> showType = query.getType();
        for (QueryResult queryResult : queryResultList) {
            if (showType != null) {
                queryResult.setType(showType);
                continue;
            }
            LinkedHashMap<Long, Object> dps = queryResult.getDps();
            if (dps == null || dps.size() == 0) continue;
            Class typeExist = null;
            for (Map.Entry<Long, Object> entry : dps.entrySet()) {
                Object value;
                Long ts = entry.getKey();
                Class<?> type = TSDBClient.getType4Single(ts, value = entry.getValue(), dps);
                if (type == BigDecimal.class) {
                    typeExist = BigDecimal.class;
                    break;
                }
                if (typeExist == null) {
                    typeExist = type;
                    continue;
                }
                if (typeExist == type) continue;
                typeExist = BigDecimal.class;
                break;
            }
            queryResult.setType(typeExist);
        }
    }

    public static void setTypeIfNeeded4MultiField(MultiFieldQuery query, List<MultiFieldQueryResult> queryResultList) {
        if (query == null || !query.isShowType()) {
            return;
        }
        List<Class<?>> queryType = query.getTypes();
        for (MultiFieldQueryResult queryResult : queryResultList) {
            if (queryType != null) {
                queryResult.setTypes(queryType);
                continue;
            }
            List<List<Object>> dps = queryResult.getValues();
            if (dps == null || dps.size() == 0) continue;
            LinkedList typeList = new LinkedList();
            int columnSize = queryResult.getColumns().size();
            for (int i = 1; i < columnSize; ++i) {
                Class typeExist = null;
                for (List<Object> dp : dps) {
                    Object value = dp.get(i);
                    Class<?> type = TSDBClient.getType4Multi(i, value, dp);
                    if (type == BigDecimal.class) {
                        typeExist = BigDecimal.class;
                        break;
                    }
                    if (typeExist == null) {
                        typeExist = type;
                        continue;
                    }
                    if (typeExist == type) continue;
                    typeExist = BigDecimal.class;
                    break;
                }
                typeList.add(typeExist);
            }
            queryResult.setTypes(typeList);
        }
    }

    public static Class<?> getType4Single(Long ts, Object value, LinkedHashMap<Long, Object> dps) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return Long.class;
        }
        if (value instanceof Float) {
            return Double.class;
        }
        if (value instanceof Double) {
            return Double.class;
        }
        return TSDBClient.getOtherClass(value);
    }

    public static Class<?> getType4Multi(int index, Object value, List<Object> dps) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return Long.class;
        }
        if (value instanceof Float) {
            if (((Float)value).floatValue() % 1.0f == 0.0f) {
                dps.set(index, ((Float)value).longValue());
                return Long.class;
            }
            return Double.class;
        }
        if (value instanceof Double) {
            if ((Double)value % 1.0 == 0.0) {
                dps.set(index, ((Double)value).longValue());
                return Long.class;
            }
            return Double.class;
        }
        return TSDBClient.getOtherClass(value);
    }

    private static Class<?> getOtherClass(Object value) {
        if (value instanceof BigDecimal) {
            return BigDecimal.class;
        }
        if (value instanceof Boolean) {
            return Boolean.class;
        }
        if (value instanceof String) {
            return String.class;
        }
        LOGGER.warn("There is a data type that has not been considered, detail: " + value);
        return Object.class;
    }

    @Deprecated
    public MultiValuedQueryResult convertQueryResultIntoTupleFormat(Map<String, String> fieldAndDpValueFilter, List<QueryResult> queryResults, String metric, Integer limit, Integer offset) {
        int n;
        TreeSet<Object> alignedTimestamps;
        long startTime = System.currentTimeMillis();
        long dpsCounter = 0L;
        Boolean reverseOrder = false;
        if (limit != null && limit < 0) {
            limit = limit * -1;
            reverseOrder = true;
            alignedTimestamps = new TreeSet(Collections.reverseOrder());
        } else {
            alignedTimestamps = new TreeSet();
        }
        TreeSet<String> tagks = new TreeSet<String>();
        TreeSet<String> fields = new TreeSet<String>();
        ArrayList<List<String>> aggregateTags = new ArrayList<List<String>>();
        if (metric == null || metric.isEmpty()) {
            LOGGER.error("Failed to obtain measurement metric from tags. This should never happen");
            return null;
        }
        if (fieldAndDpValueFilter != null && !fieldAndDpValueFilter.isEmpty()) {
            boolean firstFlag = true;
            for (QueryResult queryResult2 : queryResults) {
                String field = queryResult2.getMetric();
                if (fieldAndDpValueFilter.containsKey(field)) {
                    if (firstFlag) {
                        alignedTimestamps.addAll(queryResult2.getDps().keySet());
                        firstFlag = false;
                    } else {
                        alignedTimestamps.retainAll(queryResult2.getDps().keySet());
                    }
                }
                tagks.addAll(queryResult2.getTags().keySet());
                fields.add(field);
                aggregateTags.add(queryResult2.getAggregateTags());
                dpsCounter += (long)queryResult2.getDps().size();
            }
        } else {
            for (QueryResult queryResult3 : queryResults) {
                alignedTimestamps.addAll(queryResult3.getDps().keySet());
                tagks.addAll(queryResult3.getTags().keySet());
                fields.add(queryResult3.getMetric());
                aggregateTags.add(queryResult3.getAggregateTags());
                dpsCounter += (long)queryResult3.getDps().size();
            }
        }
        ArrayList<String> finalColumns = new ArrayList<String>();
        finalColumns.add("timestamp");
        finalColumns.addAll(tagks);
        finalColumns.addAll(fields);
        TreeSet<List<Object>> resultTuples = new TreeSet<List<Object>>(new MultiValuedTupleComparator(reverseOrder));
        HashMap<String, ArrayList<QueryResult>> queryResultsWithSameTags = new HashMap<String, ArrayList<QueryResult>>();
        for (QueryResult queryResult : queryResults) {
            String tags = queryResult.tagsToString();
            ArrayList<QueryResult> existingList = (ArrayList<QueryResult>)queryResultsWithSameTags.get(tags);
            if (existingList == null) {
                existingList = new ArrayList<QueryResult>();
                queryResultsWithSameTags.put(tags, existingList);
            }
            existingList.add(queryResult);
        }
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        Iterator iterator = alignedTimestamps.iterator();
        while (iterator.hasNext()) {
            long timestamp = (Long)iterator.next();
            for (Map.Entry entry : queryResultsWithSameTags.entrySet()) {
                ArrayList<Object> tupleValues = new ArrayList<Object>();
                tupleValues.add(timestamp);
                Boolean tagValueFilled = false;
                TreeMap<String, Object> fieldsMap = new TreeMap<String, Object>();
                for (int index = 0; index < ((List)entry.getValue()).size(); ++index) {
                    QueryResult result = (QueryResult)((List)entry.getValue()).get(index);
                    if (!tagValueFilled.booleanValue()) {
                        for (String tagk : tagks) {
                            String tagv = result.getTags().get(tagk);
                            tupleValues.add(tagv);
                        }
                        tagValueFilled = true;
                    }
                    fieldsMap.put(result.getMetric(), result.getDps().get(timestamp));
                }
                for (String field : fields) {
                    if (fieldsMap.containsKey(field)) continue;
                    fieldsMap.put(field, null);
                }
                Boolean keepTuple = false;
                for (Map.Entry fieldValue : fieldsMap.entrySet()) {
                    if (fieldValue.getValue() != null) {
                        keepTuple = true;
                    }
                    tupleValues.add(fieldValue.getValue());
                }
                if (!keepTuple.booleanValue()) continue;
                resultTuples.add(tupleValues);
            }
        }
        boolean bl = false;
        int dpsEndIndex = resultTuples.size();
        if (offset != null && offset >= dpsEndIndex) {
            return null;
        }
        if (offset != null && offset != 0 || limit != null && limit != 0) {
            int newDpsEndIndex;
            n = offset == null ? 0 : offset;
            int n2 = newDpsEndIndex = limit == null ? dpsEndIndex : n + limit;
            if (newDpsEndIndex < dpsEndIndex) {
                dpsEndIndex = newDpsEndIndex;
            }
        }
        values.addAll(resultTuples);
        values = values.subList(n, dpsEndIndex);
        MultiValuedQueryResult tupleFormat = new MultiValuedQueryResult();
        tupleFormat.setName(metric);
        tupleFormat.setColumns(finalColumns);
        tupleFormat.setValues(values);
        tupleFormat.setAggregateTags(aggregateTags);
        for (List list : values) {
            HashMap dp = new HashMap();
            for (int index = 0; index < finalColumns.size(); ++index) {
                dp.put(finalColumns.get(index), list.get(index));
            }
            tupleFormat.getDps().add(dp);
        }
        LOGGER.info("Total convertQueryResultIntoTupleFormat conversion time : {}ms. | Total DPS Processed : {}", (Object)(System.currentTimeMillis() - startTime), (Object)dpsCounter);
        return tupleFormat;
    }

    private void doQueryRetry(HAPolicy.QueryContext queryContext, Exception e) {
        if (!queryContext.doQuery()) {
            if (e instanceof HttpServerErrorException) {
                throw (HttpServerErrorException)e;
            }
            if (e instanceof HttpClientException) {
                throw (HttpClientException)e;
            }
            throw new RuntimeException("Unexpected exception!");
        }
        queryContext.addRetryTimes();
        LOGGER.error("Read failed in one client, try again!");
    }

    @Override
    public List<QueryResult> query(Query query) {
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.query(query, queryContext.getClient());
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.query(query, this.httpclient);
    }

    private List<QueryResult> query(Query query, HttpClient client) {
        HttpResponse httpResponse = client.post("/api/query", query.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List queryResultList = JSON.parseArray((String)content, QueryResult.class);
                TSDBClient.setTypeIfNeeded(query, queryResultList);
                return queryResultList;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public SQLResult queryBySQL(String sql) throws HttpUnknowStatusException {
        SQLValue sqlValue = new SQLValue(sql);
        HttpResponse httpResponse = this.httpclient.post("/api/sqlquery", sqlValue.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                return (SQLResult)JSON.parseObject((String)content, SQLResult.class);
            }
        }
        return (SQLResult)this.handleStatus(resultResponse);
    }

    @Override
    public void query(Query query, QueryCallback callback) {
        FutureCallback<HttpResponse> httpCallback = null;
        String address = this.httpclient.getHttpAddressManager().getAddress();
        if (callback != null) {
            httpCallback = this.httpResponseCallbackFactory.createQueryCallback(address, callback, query);
        }
        this.httpclient.postToAddress(address, "/api/query", query.toJSON(), httpCallback);
    }

    @Override
    public List<String> suggest(Suggest type, String prefix, int max) {
        SuggestValue suggestValue = new SuggestValue(type.getName(), prefix, max);
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.suggest(suggestValue);
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.suggest(suggestValue);
    }

    private List<String> suggest(SuggestValue suggestValue) {
        HttpResponse httpResponse = this.httpclient.post("/api/suggest", suggestValue.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List list = JSON.parseArray((String)content, String.class);
                return list;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public List<String> suggest(Suggest type, String metric, String prefix, int max) {
        SuggestValue suggestValue = new SuggestValue(type.getName(), metric, prefix, max);
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.suggest(suggestValue);
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.suggest(suggestValue);
    }

    @Override
    public List<LookupResult> lookup(String metric, List<LookupTagFilter> tags, int max) {
        LookupRequest lookupRequest = new LookupRequest(metric, tags, max);
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.lookup(lookupRequest);
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.lookup(lookupRequest);
    }

    @Override
    public List<LookupResult> lookup(LookupRequest lookupRequest) {
        HttpResponse httpResponse = this.httpclient.post("/api/search/lookup", lookupRequest.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List list = JSON.parseArray((String)("[" + content + "]"), LookupResult.class);
                return list;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public int ttl() {
        HttpResponse httpResponse = this.httpclient.get("/api/ttl", null);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccessNoContent: {
                return 0;
            }
            case ServerSuccess: {
                String content = resultResponse.getContent();
                TTLResult ttlResult = JSONValue.parseObject(content, TTLResult.class);
                return ttlResult.getVal();
            }
        }
        this.handleVoid(resultResponse);
        return -1;
    }

    @Override
    public void ttl(int lifetime) {
        TTLValue ttlValue = new TTLValue(lifetime);
        HttpResponse httpResponse = this.httpclient.post("/api/ttl", ttlValue.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public void ttl(int lifetime, TimeUnit unit) {
        int seconds = (int)unit.toSeconds(lifetime);
        TTLValue ttlValue = new TTLValue(seconds);
        HttpResponse httpResponse = this.httpclient.post("/api/ttl", ttlValue.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public List<QueryResult> last(Query query, int num) throws HttpUnknowStatusException {
        List<QueryResult> queryResults = this.query(query);
        for (QueryResult queryResult : queryResults) {
            LinkedHashMap<Long, String> sdps;
            Map.Entry<Long, Object> beforeEntry;
            int count;
            Map.Entry<Long, Object> lastEntry;
            LinkedHashMap<Long, Object> newDps;
            LinkedHashMap<Long, Object> dps = queryResult.getDps();
            if (dps != null) {
                newDps = new LinkedHashMap<Long, Object>(num);
                lastEntry = LinkedHashMapUtils.getTail(dps);
                if (lastEntry != null) {
                    newDps.put(lastEntry.getKey(), lastEntry.getValue());
                    for (count = 1; count < num && (beforeEntry = LinkedHashMapUtils.getBefore(lastEntry)) != null; ++count) {
                        newDps.put(beforeEntry.getKey(), beforeEntry.getValue());
                        lastEntry = beforeEntry;
                    }
                }
                queryResult.setDps(newDps);
            }
            if ((sdps = queryResult.getSdps()) == null) continue;
            newDps = new LinkedHashMap(num);
            lastEntry = LinkedHashMapUtils.getTail(sdps);
            if (lastEntry != null) {
                newDps.put(lastEntry.getKey(), lastEntry.getValue());
                for (count = 1; count < num && (beforeEntry = LinkedHashMapUtils.getBefore(lastEntry)) != null; ++count) {
                    newDps.put(beforeEntry.getKey(), beforeEntry.getValue());
                    lastEntry = beforeEntry;
                }
            }
            queryResult.setSdps(sdps);
        }
        return queryResults;
    }

    @Override
    public Result putSync(Collection<Point> points) {
        return this.putSync(points, Result.class);
    }

    @Override
    public void put(Collection<Point> points, AbstractBatchPutCallback batchPutCallback) {
        UniqueUtil.uniquePoints(points, this.config.isDeduplicationEnable());
        PointsCollection pc = new PointsCollection(points, batchPutCallback);
        this.queue.sendPoints(pc);
    }

    @Override
    public <T extends Result> T putSync(Collection<Point> points, Class<T> resultType) {
        UniqueUtil.uniquePoints(points, this.config.isDeduplicationEnable());
        return this.putSync("default", points, resultType);
    }

    public <T extends Result> T putSync(String database, Collection<Point> points, Class<T> resultType) {
        HashMap<String, String> paramsMap;
        HttpResponse httpResponse;
        String jsonString = JSON.toJSONString(points, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        if (resultType.equals(Result.class)) {
            httpResponse = this.httpclient.post("/api/put", jsonString);
        } else if (resultType.equals(SummaryResult.class)) {
            paramsMap = new HashMap<String, String>();
            paramsMap.put("summary", "true");
            httpResponse = this.httpclient.post("/api/put", jsonString, paramsMap);
        } else if (resultType.equals(DetailsResult.class)) {
            paramsMap = new HashMap();
            paramsMap.put("details", "true");
            httpResponse = this.httpclient.post("/api/put", jsonString, paramsMap);
        } else if (resultType.equals(IgnoreErrorsResult.class)) {
            paramsMap = new HashMap();
            paramsMap.put("ignoreErrors", "true");
            httpResponse = this.httpclient.post("/api/put", jsonString, paramsMap);
        } else {
            throw new HttpClientException("This result type is not supported");
        }
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        Result result = null;
        switch (httpStatus) {
            case ServerSuccessNoContent: {
                result = new Result();
                return (T)result;
            }
            case ServerSuccess: {
                String content = resultResponse.getContent();
                if (resultType.equals(SummaryResult.class)) {
                    result = (Result)JSON.parseObject((String)content, SummaryResult.class);
                } else if (resultType.equals(DetailsResult.class)) {
                    result = (Result)JSON.parseObject((String)content, DetailsResult.class);
                } else if (resultType.equals(IgnoreErrorsResult.class)) {
                    result = (Result)JSON.parseObject((String)content, IgnoreErrorsResult.class);
                }
                return (T)result;
            }
        }
        return (T)((Result)this.handleStatus(resultResponse));
    }

    void putAsync(List<Point> pointList, Map<String, String> paramsMap) {
        String address = this.httpclient.getAddressAndSemaphoreAcquire();
        String jsonString = JSON.toJSONString(pointList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        FutureCallback<HttpResponse> postHttpCallback = this.config.getBatchPutCallback() != null ? this.httpResponseCallbackFactory.createBatchPutDataCallback(address, this.config.getBatchPutCallback(), pointList, this.config, this.config.getBatchPutRetryCount()) : this.httpResponseCallbackFactory.createNoLogicBatchPutHttpFutureCallback(address, pointList, this.config, this.config.getBatchPutRetryCount());
        try {
            this.httpclient.postToAddress(address, "/api/put", jsonString, paramsMap, postHttpCallback);
        }
        catch (Exception ex) {
            this.httpclient.getSemaphoreManager().release(address);
            if (postHttpCallback instanceof BatchPutHttpResponseCallback) {
                BatchPutHttpResponseCallback batchPutCallback = (BatchPutHttpResponseCallback)postHttpCallback;
                if (batchPutCallback.getLogicalBatchPutCallback() != null) {
                    batchPutCallback.getLogicalBatchPutCallback().failed(address, pointList, ex);
                } else {
                    batchPutCallback.failed(ex);
                }
            }
            postHttpCallback.failed(ex);
        }
    }

    @Override
    public void delete(Query query) throws HttpUnknowStatusException {
        try {
            queryDeleteField.set(query, true);
        }
        catch (IllegalArgumentException e) {
            throw new HttpClientException(e);
        }
        catch (IllegalAccessException e) {
            throw new HttpClientException(e);
        }
        HttpResponse httpResponse = this.httpclient.post("/api/query", query.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public List<LastDataValue> queryLast(Collection<Timeline> timelines) throws HttpUnknowStatusException {
        Object timelinesJSON = JSON.toJSON(timelines);
        JSONObject obj = new JSONObject();
        obj.put("queries", timelinesJSON);
        String jsonString = obj.toJSONString();
        return this.queryLastInner(jsonString);
    }

    private List<LastDataValue> queryLastInner(String jsonString) throws HttpUnknowStatusException {
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.queryLast(jsonString, queryContext.getClient());
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.queryLast(jsonString, this.httpclient);
    }

    private List<LastDataValue> queryLast(String jsonString, HttpClient client) throws HttpUnknowStatusException {
        HttpResponse httpResponse = client.post("/api/query/last", jsonString);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List queryResultList = JSON.parseArray((String)content, LastDataValue.class);
                if (this.config.isLastResultReverseEnable()) {
                    this.reverseSingleValueTimestamp(queryResultList);
                }
                return queryResultList;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    void reverseSingleValueTimestamp(List<LastDataValue> queryResultList) {
        for (LastDataValue lastDataValue : queryResultList) {
            TSDBClient.reverseSingleValueTimestamp(lastDataValue);
        }
    }

    static void reverseSingleValueTimestamp(LastDataValue lastDataValue) {
        TreeMap<Long, Object> retMap = new TreeMap<Long, Object>(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                return o2.compareTo(o1);
            }
        });
        retMap.putAll(lastDataValue.getDps());
        lastDataValue.getDps().clear();
        lastDataValue.getDps().putAll(retMap);
    }

    @Override
    public List<LastDataValue> queryLast(Timeline ... timelines) throws HttpUnknowStatusException {
        return this.queryLast((Collection<Timeline>)Arrays.asList(timelines));
    }

    @Override
    public List<LastDataValue> queryLast(List<String> tsuids) throws HttpUnknowStatusException {
        Object tsuidsJSONList = JSON.toJSON(tsuids);
        JSONObject tsuidsJSONObj = new JSONObject();
        tsuidsJSONObj.put("tsuids", tsuidsJSONList);
        LinkedList<JSONObject> tsuidsJSONObjList = new LinkedList<JSONObject>();
        tsuidsJSONObjList.add(tsuidsJSONObj);
        JSONObject obj = new JSONObject();
        obj.put("queries", tsuidsJSONObjList);
        String jsonString = obj.toJSONString();
        return this.queryLastInner(jsonString);
    }

    @Override
    public List<LastDataValue> queryLast(String ... tsuids) throws HttpUnknowStatusException {
        return this.queryLast(Arrays.asList(tsuids));
    }

    @Override
    public String version() throws HttpUnknowStatusException {
        HttpResponse httpResponse = this.httpclient.post("/api/version", EMPTY_JSON_STR);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                JSONObject result = JSONObject.parseObject((String)resultResponse.getContent());
                return result.getString("version");
            }
        }
        return (String)this.handleStatus(resultResponse);
    }

    @Override
    public Map<String, String> getVersionInfo() throws HttpUnknowStatusException {
        HttpResponse httpResponse = this.httpclient.post("/api/version", EMPTY_JSON_STR);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                JSONObject result = JSONObject.parseObject((String)resultResponse.getContent());
                HashMap<String, String> map = new HashMap<String, String>();
                for (Map.Entry entry : result.entrySet()) {
                    map.put((String)entry.getKey(), entry.getValue().toString());
                }
                return map;
            }
        }
        return (Map)this.handleStatus(resultResponse);
    }

    @Override
    public void put(Point ... points) {
        for (Point p : points) {
            this.put(p);
        }
    }

    @Override
    public void put(Collection<Point> points) {
        for (Point p : points) {
            this.put(p);
        }
    }

    @Override
    public Result putSync(Point ... points) {
        return this.putSync(Arrays.asList(points));
    }

    @Override
    public <T extends Result> T putSync(Class<T> resultType, Collection<Point> points) {
        return this.putSync(points, resultType);
    }

    @Override
    public <T extends Result> T putSync(Class<T> resultType, Point ... points) {
        return this.putSync(resultType, Arrays.asList(points));
    }

    @Override
    public List<LastDataValue> queryLast(LastPointQuery query) throws HttpUnknowStatusException {
        if (query.getTupleFormat() != null && query.getTupleFormat().booleanValue()) {
            throw new HttpClientException("Tuple format query result is not supported. If you want to query fields' latest data and receive tuple format results, please use multiFieldQueryLast() instead.");
        }
        String jsonString = query.toJSON();
        return this.queryLastInner(jsonString);
    }

    @Override
    public boolean truncate() throws HttpUnknowStatusException {
        HttpResponse httpResponse = this.httpclient.post("/api/truncate", EMPTY_JSON_STR);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccessNoContent: 
            case ServerSuccess: {
                LOGGER.info("truncate result: {}", (Object)resultResponse.getContent());
                return true;
            }
        }
        return (Boolean)this.handleStatus(resultResponse);
    }

    @Override
    public <T extends Result> T multiFieldPutSync(MultiFieldPoint point, Class<T> resultType) {
        return this.multiFieldPutSync(Collections.singletonList(point), resultType);
    }

    @Override
    public <T extends Result> T multiFieldPutSync(Collection<MultiFieldPoint> points, Class<T> resultType) {
        UniqueUtil.uniqueMultiFieldPoints(points, this.config.isDeduplicationEnable());
        return this.multiFieldPutSync("default", points, resultType);
    }

    public <T extends Result> T multiFieldPutSync(String database, Collection<MultiFieldPoint> points, Class<T> resultType) {
        HashMap<String, String> paramsMap;
        HttpResponse httpResponse;
        String jsonString = JSON.toJSONString(points, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        if (resultType.equals(Result.class)) {
            httpResponse = this.httpclient.post("/api/mput", jsonString);
        } else if (resultType.equals(SummaryResult.class)) {
            paramsMap = new HashMap<String, String>();
            paramsMap.put("summary", "true");
            httpResponse = this.httpclient.post("/api/mput", jsonString, paramsMap);
        } else if (resultType.equals(MultiFieldDetailsResult.class)) {
            paramsMap = new HashMap();
            paramsMap.put("details", "true");
            httpResponse = this.httpclient.post("/api/mput", jsonString, paramsMap);
        } else if (resultType.equals(MultiFieldIgnoreErrorsResult.class)) {
            paramsMap = new HashMap();
            paramsMap.put("ignoreErrors", "true");
            httpResponse = this.httpclient.post("/api/mput", jsonString, paramsMap);
        } else {
            throw new HttpClientException("This result type is not supported");
        }
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        Result result = null;
        switch (httpStatus) {
            case ServerSuccessNoContent: {
                result = new Result();
                return (T)result;
            }
            case ServerSuccess: {
                String content = resultResponse.getContent();
                if (resultType.equals(SummaryResult.class)) {
                    result = (Result)JSON.parseObject((String)content, SummaryResult.class);
                } else if (resultType.equals(MultiFieldDetailsResult.class)) {
                    result = (Result)JSON.parseObject((String)content, MultiFieldDetailsResult.class);
                } else if (resultType.equals(MultiFieldIgnoreErrorsResult.class)) {
                    result = (Result)JSON.parseObject((String)content, MultiFieldIgnoreErrorsResult.class);
                }
                return (T)result;
            }
        }
        return (T)((Result)this.handleStatus(resultResponse));
    }

    @Override
    public Result multiFieldPutSync(MultiFieldPoint ... points) {
        return this.multiFieldPutSync(Arrays.asList(points));
    }

    @Override
    public Result multiFieldPutSync(Collection<MultiFieldPoint> points) {
        return this.multiFieldPutSync(points, Result.class);
    }

    void multiFieldPutAsync(List<MultiFieldPoint> pointList, Map<String, String> paramsMap) {
        String address = this.httpclient.getAddressAndSemaphoreAcquire();
        String jsonString = JSON.toJSONString(pointList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        FutureCallback<HttpResponse> postHttpCallback = this.config.getMultiFieldBatchPutCallback() != null ? this.httpResponseCallbackFactory.createMultiFieldBatchPutDataCallback(address, this.config.getMultiFieldBatchPutCallback(), pointList, this.config, this.config.getBatchPutRetryCount()) : this.httpResponseCallbackFactory.createMultiFieldNoLogicBatchPutHttpFutureCallback(address, pointList, this.config, this.config.getBatchPutRetryCount());
        try {
            this.httpclient.postToAddress(address, "/api/mput", jsonString, paramsMap, postHttpCallback);
        }
        catch (Exception ex) {
            this.httpclient.getSemaphoreManager().release(address);
            if (postHttpCallback instanceof MultiFieldBatchPutHttpResponseCallback) {
                MultiFieldBatchPutHttpResponseCallback batchPutCallback = (MultiFieldBatchPutHttpResponseCallback)postHttpCallback;
                if (batchPutCallback.getLogicalBatchPutCallback() != null) {
                    batchPutCallback.getLogicalBatchPutCallback().failed(address, pointList, ex);
                } else {
                    batchPutCallback.failed(ex);
                }
            }
            postHttpCallback.failed(ex);
        }
    }

    @Override
    public void multiFieldPut(Collection<MultiFieldPoint> points, AbstractMultiFieldBatchPutCallback batchPutCallback) {
        UniqueUtil.uniqueMultiFieldPoints(points, this.config.isDeduplicationEnable());
        PointsCollection pc = new PointsCollection(points, batchPutCallback);
        this.queue.sendPoints(pc);
    }

    @Override
    public void multiFieldPut(MultiFieldPoint point) {
        this.queue.sendMultiFieldPoint(point);
    }

    @Override
    public void multiFieldPut(MultiFieldPoint ... points) {
        for (MultiFieldPoint p : points) {
            this.queue.sendMultiFieldPoint(p);
        }
    }

    @Override
    public void multiFieldPut(Collection<MultiFieldPoint> points) {
        for (MultiFieldPoint p : points) {
            this.queue.sendMultiFieldPoint(p);
        }
    }

    @Override
    public List<MultiFieldQueryResult> multiFieldQuery(MultiFieldQuery query) throws HttpUnknowStatusException {
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.multiFieldQuery(query, queryContext.getClient());
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.multiFieldQuery(query, this.httpclient);
    }

    private List<MultiFieldQueryResult> multiFieldQuery(MultiFieldQuery query, HttpClient client) throws HttpUnknowStatusException {
        HttpResponse httpResponse = client.post("/api/mquery", query.toJSON());
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List queryResultList = JSON.parseArray((String)content, MultiFieldQueryResult.class);
                TSDBClient.setTypeIfNeeded4MultiField(query, queryResultList);
                return queryResultList;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public List<MultiFieldQueryLastResult> multiFieldQueryLast(LastPointQuery lastPointQuery) throws HttpUnknowStatusException {
        if (lastPointQuery.getTupleFormat() == null || !lastPointQuery.getTupleFormat().booleanValue()) {
            lastPointQuery.setTupleFormat(true);
        }
        String jsonString = lastPointQuery.toJSON();
        if (this.config.getHAPolicy() != null) {
            HAPolicy.QueryContext queryContext = new HAPolicy.QueryContext(this.config.getHAPolicy(), this.httpclient, this.secondaryClient);
            while (true) {
                try {
                    return this.multiFieldQueryLast(jsonString, queryContext.getClient());
                }
                catch (HttpServerErrorException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                catch (HttpClientException e) {
                    this.doQueryRetry(queryContext, e);
                    continue;
                }
                break;
            }
        }
        return this.multiFieldQueryLast(jsonString, this.httpclient);
    }

    private List<MultiFieldQueryLastResult> multiFieldQueryLast(String jsonString, HttpClient client) throws HttpUnknowStatusException {
        HttpResponse httpResponse = client.post("/api/query/mlast", jsonString);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List result = JSON.parseArray((String)content, MultiFieldQueryLastResult.class);
                if (this.config.isLastResultReverseEnable()) {
                    this.reverseMultiValueTimestamp(result);
                }
                return result;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    void reverseMultiValueTimestamp(List<MultiFieldQueryLastResult> result) {
        for (MultiFieldQueryLastResult multiFieldQueryLastResult : result) {
            TSDBClient.reverseMultiValueTimestamp(multiFieldQueryLastResult);
        }
    }

    static void reverseMultiValueTimestamp(MultiFieldQueryLastResult multiFieldQueryLastResult) {
        Collections.sort(multiFieldQueryLastResult.getValues(), new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                Long t1 = (Long)o1.get(0);
                Long t2 = (Long)o2.get(0);
                return t2.compareTo(t1);
            }
        });
    }

    @Override
    public void createUser(String username, String password, UserPrivilege privilege) {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            throw new IllegalArgumentException("username or password cannot be empty");
        }
        String base64Password = Base64.encodeBase64String((byte[])password.getBytes());
        UserResult createRequest = new UserResult(username, base64Password, privilege.id());
        String jsonRequest = createRequest.toJSON();
        HttpResponse httpResponse = this.httpclient.post("/api/users", jsonRequest);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public void dropUser(String username) {
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("username cannot be empty");
        }
        HttpResponse httpResponse = this.httpclient.delete("/api/users?u=" + username, null);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        this.handleVoid(resultResponse);
    }

    @Override
    public List<UserResult> listUsers() {
        HttpResponse httpResponse = this.httpclient.get("/api/users", null);
        ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.httpCompress);
        HttpStatus httpStatus = resultResponse.getHttpStatus();
        switch (httpStatus) {
            case ServerSuccess: {
                String content = resultResponse.getContent();
                List result = JSON.parseArray((String)content, UserResult.class);
                return result;
            }
        }
        return (List)this.handleStatus(resultResponse);
    }

    @Override
    public void flush() {
        AbstractPoint[] points = this.queue.getPoints();
        AbstractPoint[] mpoints = this.queue.getMultiFieldPoints();
        if (points != null && points.length > 0) {
            this.flushPoints(points);
            LOGGER.info("{} single field points flushed", (Object)points.length);
        }
        if (mpoints != null && mpoints.length > 0) {
            this.flushPoints(mpoints);
            LOGGER.info("{} multi-field points flushed", (Object)mpoints.length);
        }
    }

    private <T extends AbstractPoint> void flushPoints(T[] points) {
        int batchPutSize = this.config.getBatchPutSize();
        ArrayList pointList = new ArrayList(points.length);
        Collections.addAll(pointList, points);
        boolean singleValue = true;
        if (points.length > 0) {
            if (points[0] instanceof MultiFieldPoint) {
                singleValue = false;
            } else if (!(points[0] instanceof Point)) {
                throw new IllegalArgumentException(String.format("unrecognised implementation of AbstractPoint: %s", points[0].getClass().getName()));
            }
        }
        for (int i = 0; i <= points.length - 1; i += batchPutSize) {
            List<Point> subPoints;
            int endBound = Math.min(points.length, i + batchPutSize);
            List<Point> sub = pointList.subList(i, endBound);
            if (singleValue) {
                subPoints = sub;
                this.putAsync(subPoints, AbstractBatchPutCallback.getPutQueryParamMap(this.config.getBatchPutCallback()));
                continue;
            }
            subPoints = sub;
            this.multiFieldPutAsync(subPoints, AbstractMultiFieldBatchPutCallback.getMultiFieldPutQueryParamMap(this.config.getMultiFieldBatchPutCallback()));
        }
    }

    static {
        try {
            queryDeleteField = Query.class.getDeclaredField("delete");
            queryDeleteField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        JSON.DEFAULT_PARSER_FEATURE &= ~Feature.UseBigDecimal.getMask();
        EMPTY_HOLDER = new JSONObject().toJSONString();
        EMPTY_JSON_STR = new JSONObject().toJSONString();
    }
}

