/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.callback.http;

import com.alibaba.fastjson.JSON;
import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.AbstractBatchPutCallback;
import com.aliyun.hitsdb.client.callback.BatchPutCallback;
import com.aliyun.hitsdb.client.callback.BatchPutDetailsCallback;
import com.aliyun.hitsdb.client.callback.BatchPutIgnoreErrorsCallback;
import com.aliyun.hitsdb.client.callback.BatchPutSummaryCallback;
import com.aliyun.hitsdb.client.callback.http.HttpResponseCallbackFactory;
import com.aliyun.hitsdb.client.exception.http.HttpClientConnectionRefusedException;
import com.aliyun.hitsdb.client.exception.http.HttpClientSocketTimeoutException;
import com.aliyun.hitsdb.client.exception.http.HttpServerErrorException;
import com.aliyun.hitsdb.client.exception.http.HttpServerNotSupportException;
import com.aliyun.hitsdb.client.exception.http.HttpUnknowStatusException;
import com.aliyun.hitsdb.client.http.HttpAddressManager;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.http.response.HttpStatus;
import com.aliyun.hitsdb.client.http.response.ResultResponse;
import com.aliyun.hitsdb.client.value.Result;
import com.aliyun.hitsdb.client.value.request.Point;
import com.aliyun.hitsdb.client.value.response.batch.DetailsResult;
import com.aliyun.hitsdb.client.value.response.batch.IgnoreErrorsResult;
import com.aliyun.hitsdb.client.value.response.batch.SummaryResult;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPutHttpResponseCallback
implements FutureCallback<HttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchPutHttpResponseCallback.class);
    private final AbstractBatchPutCallback<?> batchPutCallback;
    private final List<Point> pointList;
    private final int batchPutRetryTimes;
    private final boolean compress;
    private final HttpClient hitsdbHttpClient;
    private final Config config;
    private final String address;

    public BatchPutHttpResponseCallback(String address, HttpClient httpclient, AbstractBatchPutCallback<?> batchPutCallback, List<Point> pointList, Config config, int batchPutRetryTimes) {
        this.address = address;
        this.hitsdbHttpClient = httpclient;
        this.batchPutCallback = batchPutCallback;
        this.pointList = pointList;
        this.batchPutRetryTimes = batchPutRetryTimes;
        this.compress = config.isHttpCompress();
        this.config = config;
    }

    public AbstractBatchPutCallback<?> getLogicalBatchPutCallback() {
        return this.batchPutCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(HttpResponse httpResponse) {
        try {
            if (httpResponse.getStatusLine().getStatusCode() == 307) {
                this.hitsdbHttpClient.setSslEnable(true);
                if (this.errorRetry()) {
                    return;
                }
            }
            ResultResponse resultResponse = ResultResponse.simplify(httpResponse, this.compress);
            HttpStatus httpStatus = resultResponse.getHttpStatus();
            switch (httpStatus) {
                case ServerSuccess: 
                case ServerSuccessNoContent: {
                    if (this.batchPutCallback == null) {
                        return;
                    }
                    if (this.batchPutCallback instanceof BatchPutCallback) {
                        ((BatchPutCallback)this.batchPutCallback).response(this.address, this.pointList, new Result());
                        return;
                    }
                    if (this.batchPutCallback instanceof BatchPutSummaryCallback) {
                        SummaryResult summaryResult = null;
                        if (!httpStatus.equals((Object)HttpStatus.ServerSuccessNoContent)) {
                            String content = resultResponse.getContent();
                            summaryResult = (SummaryResult)JSON.parseObject((String)content, SummaryResult.class);
                        }
                        ((BatchPutSummaryCallback)this.batchPutCallback).response(this.address, this.pointList, summaryResult);
                        return;
                    }
                    if (this.batchPutCallback instanceof BatchPutDetailsCallback) {
                        DetailsResult detailsResult = null;
                        if (!httpStatus.equals((Object)HttpStatus.ServerSuccessNoContent)) {
                            String content = resultResponse.getContent();
                            detailsResult = (DetailsResult)JSON.parseObject((String)content, DetailsResult.class);
                        }
                        ((BatchPutDetailsCallback)this.batchPutCallback).response(this.address, this.pointList, detailsResult);
                        return;
                    }
                    if (this.batchPutCallback instanceof BatchPutIgnoreErrorsCallback) {
                        IgnoreErrorsResult ignoreErrorsResult = null;
                        if (!httpStatus.equals((Object)HttpStatus.ServerSuccessNoContent)) {
                            String content = resultResponse.getContent();
                            ignoreErrorsResult = (IgnoreErrorsResult)JSON.parseObject((String)content, IgnoreErrorsResult.class);
                        }
                        ((BatchPutIgnoreErrorsCallback)this.batchPutCallback).response(this.address, this.pointList, ignoreErrorsResult);
                        return;
                    }
                }
                case ServerNotSupport: {
                    HttpServerNotSupportException ex = new HttpServerNotSupportException(resultResponse);
                    this.failedWithResponse(ex);
                    return;
                }
                case ServerError: {
                    if (this.batchPutRetryTimes == 0) {
                        HttpServerErrorException ex = new HttpServerErrorException(resultResponse);
                        this.failedWithResponse(ex);
                    } else if (!this.errorRetry()) {
                        LOGGER.warn("batch put retry limit {} reached", (Object)this.batchPutRetryTimes);
                        HttpServerErrorException ex = new HttpServerErrorException(resultResponse);
                        this.failedWithResponse(ex);
                    }
                    return;
                }
            }
            HttpUnknowStatusException ex = new HttpUnknowStatusException(resultResponse);
            this.failedWithResponse(ex);
        }
        finally {
            this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
        }
    }

    private void failedWithResponse(Exception ex) {
        if (this.batchPutCallback == null) {
            LOGGER.error("No callback logic exception. address:" + this.address, (Throwable)ex);
        } else {
            this.batchPutCallback.failed(this.address, this.pointList, ex);
        }
    }

    private String getNextAddress() {
        HttpAddressManager httpAddressManager = this.hitsdbHttpClient.getHttpAddressManager();
        String newAddress = httpAddressManager.getAddress();
        return newAddress;
    }

    private boolean errorRetry() {
        String newAddress;
        boolean acquire;
        int retryTimes = this.batchPutRetryTimes;
        do {
            newAddress = this.getNextAddress();
        } while (!(acquire = this.hitsdbHttpClient.getSemaphoreManager().acquire(newAddress)) && --retryTimes > 0);
        if (retryTimes == 0) {
            this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
            return false;
        }
        LOGGER.warn("retry put data!");
        HttpResponseCallbackFactory httpResponseCallbackFactory = this.hitsdbHttpClient.getHttpResponseCallbackFactory();
        FutureCallback<HttpResponse> retryCallback = this.batchPutCallback != null ? httpResponseCallbackFactory.createBatchPutDataCallback(newAddress, this.batchPutCallback, this.pointList, this.config, retryTimes) : httpResponseCallbackFactory.createNoLogicBatchPutHttpFutureCallback(newAddress, this.pointList, this.config, retryTimes);
        String jsonString = JSON.toJSONString(this.pointList);
        this.hitsdbHttpClient.post("/api/put", jsonString, retryCallback);
        return true;
    }

    public void failed(Exception ex) {
        try {
            if (ex instanceof SocketTimeoutException) {
                if (this.batchPutRetryTimes == 0) {
                    ex = new HttpClientSocketTimeoutException(ex);
                } else if (this.errorRetry()) {
                    return;
                }
            } else if (ex instanceof ConnectException) {
                if (this.batchPutRetryTimes == 0) {
                    ex = new HttpClientConnectionRefusedException(this.address, ex);
                } else if (this.errorRetry()) {
                    return;
                }
            }
            if (this.batchPutCallback == null) {
                LOGGER.error("No callback logic exception.", (Throwable)ex);
            } else {
                this.batchPutCallback.failed(this.address, this.pointList, ex);
            }
        }
        finally {
            this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
        }
    }

    public void cancelled() {
        this.hitsdbHttpClient.getSemaphoreManager().release(this.address);
        LOGGER.info("the HttpAsyncClient has been cancelled");
    }
}

