/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.http;

import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.callback.http.HttpResponseCallbackFactory;
import com.aliyun.hitsdb.client.exception.http.HttpClientException;
import com.aliyun.hitsdb.client.exception.http.HttpClientInitException;
import com.aliyun.hitsdb.client.http.HttpAddressManager;
import com.aliyun.hitsdb.client.http.request.HttpDeleteWithEntity;
import com.aliyun.hitsdb.client.http.request.HttpGetWithEntity;
import com.aliyun.hitsdb.client.http.semaphore.SemaphoreManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.ExceptionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String version = "0.1";
    private Map<String, String> headerParamsMap;
    private String host;
    private int port;
    private final CloseableHttpAsyncClient httpclient;
    private final HttpResponseCallbackFactory httpResponseCallbackFactory;
    private final AtomicInteger unCompletedTaskNum;
    private final SemaphoreManager semaphoreManager;
    private final HttpAddressManager httpAddressManager;
    private final boolean httpCompress;
    private ScheduledExecutorService connectionGcService;
    private DefaultConnectingIOReactor ioReactor;
    private boolean sslEnable;
    private String authType;
    private String instanceId;
    private String tsdbUser;
    private String basicPwd;
    private byte[] certContent;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setSslEnable(boolean sslEnable) {
        this.sslEnable = sslEnable;
    }

    HttpClient(Config config, CloseableHttpAsyncClient httpclient, SemaphoreManager semaphoreManager, ScheduledExecutorService connectionGcService, DefaultConnectingIOReactor connectingIOReactor) throws HttpClientInitException {
        this.host = config.getHost();
        this.port = config.getPort();
        this.httpCompress = config.isHttpCompress();
        this.httpclient = httpclient;
        this.semaphoreManager = semaphoreManager;
        this.httpAddressManager = HttpAddressManager.createHttpAddressManager(config);
        this.unCompletedTaskNum = new AtomicInteger(0);
        this.httpResponseCallbackFactory = new HttpResponseCallbackFactory(this.unCompletedTaskNum, this, this.httpCompress);
        this.connectionGcService = connectionGcService;
        this.sslEnable = config.isSslEnable();
        this.authType = config.getAuthType();
        this.instanceId = config.getInstanceId();
        this.tsdbUser = config.getTsdbUser();
        this.basicPwd = config.getBasicPwd();
        this.certContent = config.getCertContent();
        this.ioReactor = connectingIOReactor;
    }

    public void setHeaderParamsMap(Map<String, String> headerParamsMap) {
        this.headerParamsMap = headerParamsMap;
    }

    public Map<String, String> getHeaderParamsMap() {
        return this.headerParamsMap;
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean force) throws IOException {
        if (!force) {
            int i;
            while (this.httpclient.isRunning() && (i = this.unCompletedTaskNum.get()) != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("The thread {} is Interrupted", (Object)Thread.currentThread().getName());
                }
            }
        }
        this.connectionGcService.shutdownNow();
        this.httpclient.close();
    }

    public HttpResponse delete(String apiPath, String json) throws HttpClientException {
        HttpDeleteWithEntity request = new HttpDeleteWithEntity(this.getUrl(apiPath));
        return this.execute(request, json);
    }

    public void delete(String apiPath, String json, FutureCallback<HttpResponse> httpCallback) {
        HttpDeleteWithEntity request = new HttpDeleteWithEntity(this.getUrl(apiPath));
        this.executeCallback(request, json, httpCallback);
    }

    private HttpResponse execute(HttpEntityEnclosingRequestBase request, String json) throws HttpClientException {
        if (json != null && json.length() > 0) {
            request.addHeader("Content-Type", "application/json");
            if (!this.httpCompress) {
                request.setEntity((HttpEntity)this.generateStringEntity(json));
            } else {
                request.addHeader("Accept-Encoding", "gzip, deflate");
                request.setEntity((HttpEntity)this.generateGZIPCompressEntity(json));
            }
        }
        if (this.headerParamsMap != null && !this.headerParamsMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headerParamsMap.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.authType != null && !this.authType.trim().equals("")) {
            this.setAuthHeader(request);
        }
        this.unCompletedTaskNum.incrementAndGet();
        Future future = this.httpclient.execute((HttpUriRequest)request, null);
        try {
            HttpResponse httpResponse = (HttpResponse)future.get();
            int retry = 0;
            while (httpResponse.getStatusLine().getStatusCode() == 307 || httpResponse.getStatusLine().getStatusCode() == 401) {
                if (httpResponse.getStatusLine().getStatusCode() == 307) {
                    this.sslEnable = true;
                    httpResponse = HttpClient.redirectResponse(httpResponse, request, this.httpclient);
                } else if (httpResponse.getStatusLine().getStatusCode() == 401) {
                    LOGGER.info("need authentication.....");
                    this.setAuthHeader(request);
                    httpResponse = HttpClient.authResponse(request, this.httpclient);
                }
                if (++retry < 10) continue;
            }
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (InterruptedException e) {
            throw new HttpClientException(e);
        }
        catch (ExecutionException e) {
            throw new HttpClientException(e);
        }
        catch (UnsupportedOperationException e) {
            throw new HttpClientException(e);
        }
        finally {
            this.unCompletedTaskNum.decrementAndGet();
        }
    }

    public static HttpResponse redirectResponse(HttpResponse httpResponse, HttpEntityEnclosingRequestBase request, CloseableHttpAsyncClient httpclient) throws ExecutionException, InterruptedException {
        Header[] headers;
        HttpResponse result = null;
        for (Header header : headers = httpResponse.getHeaders("Location")) {
            if (!header.getName().equalsIgnoreCase("Location")) continue;
            String newUrl = header.getValue();
            request.setURI(URI.create(newUrl));
            Future future = httpclient.execute((HttpUriRequest)request, null);
            result = (HttpResponse)future.get();
            break;
        }
        if (result == null) {
            return httpResponse;
        }
        return result;
    }

    public void checkAuthInfo() {
        if ("Basic".equalsIgnoreCase(this.authType)) {
            if (this.tsdbUser == null || this.tsdbUser.trim().equals("")) {
                throw new HttpClientException("sorry, basic authentication need user name");
            }
            if (this.basicPwd == null || this.basicPwd.trim().equals("")) {
                throw new HttpClientException("sorry, basic authentication need user password");
            }
        } else if ("alibaba-signature".equalsIgnoreCase(this.authType)) {
            if ((this.instanceId == null || this.instanceId.trim().equals("")) && !this.host.startsWith("ts-")) {
                throw new HttpClientException("sorry, authentication need instance id");
            }
            if (this.tsdbUser == null || this.tsdbUser.trim().equals("")) {
                throw new HttpClientException("sorry, ali authentication need user name");
            }
            if (this.certContent == null || this.certContent.length == 0) {
                throw new HttpClientException("sorry, ali authentication need cert content");
            }
            String certCStr = new String(this.certContent);
            if (certCStr.trim().equals("")) {
                throw new HttpClientException("sorry, ali authentication need cert content");
            }
        } else {
            throw new HttpClientException("sorry, authentication type unknown");
        }
    }

    public void setAuthHeader(HttpEntityEnclosingRequestBase request) {
        this.checkAuthInfo();
        if ("Basic".equalsIgnoreCase(this.authType)) {
            String auth = this.instanceId == null || this.instanceId.trim().equals("") ? this.tsdbUser + ":" + this.basicPwd : this.tsdbUser + "@" + this.instanceId + ":" + this.basicPwd;
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("US-ASCII")));
            String authHeader = this.authType + " " + new String(encodedAuth);
            request.removeHeaders("Authorization");
            request.addHeader("Authorization", authHeader);
        } else if ("alibaba-signature".equalsIgnoreCase(this.authType)) {
            String auth = this.instanceId == null || this.instanceId.trim().equals("") ? "0.1:" + this.tsdbUser + ":" + Base64.encodeBase64String((byte[])this.certContent) : "0.1:" + this.tsdbUser + "@" + this.instanceId + ":" + Base64.encodeBase64String((byte[])this.certContent);
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("US-ASCII")));
            String authHeader = this.authType + " " + new String(encodedAuth);
            request.removeHeaders("Authorization");
            request.addHeader("Authorization", authHeader);
        }
    }

    public static HttpResponse authResponse(HttpEntityEnclosingRequestBase request, CloseableHttpAsyncClient httpclient) throws ExecutionException, InterruptedException {
        Future future = httpclient.execute((HttpUriRequest)request, null);
        return (HttpResponse)future.get();
    }

    private void executeCallback(HttpEntityEnclosingRequestBase request, String json, FutureCallback<HttpResponse> httpCallback) {
        if (json != null && json.length() > 0) {
            request.addHeader("Content-Type", "application/json");
            if (!this.httpCompress) {
                request.setEntity((HttpEntity)this.generateStringEntity(json));
            } else {
                request.addHeader("Accept-Encoding", "gzip, deflate");
                request.setEntity((HttpEntity)this.generateGZIPCompressEntity(json));
            }
        }
        if (this.headerParamsMap != null && !this.headerParamsMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.headerParamsMap.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.authType != null && !this.authType.trim().equals("")) {
            this.setAuthHeader(request);
        }
        FutureCallback<HttpResponse> responseCallback = null;
        if (httpCallback != null) {
            this.unCompletedTaskNum.incrementAndGet();
            responseCallback = this.httpResponseCallbackFactory.wrapUpBaseHttpFutureCallback(httpCallback);
        }
        try {
            this.httpclient.execute((HttpUriRequest)request, responseCallback);
        }
        catch (IllegalStateException ex) {
            List innerException = this.ioReactor.getAuditLog();
            StringBuilder sb = new StringBuilder();
            sb.append("[Critical] unexpected error caused the status changing in IoReactor: \n");
            for (ExceptionEvent e : innerException) {
                sb.append(e.toString() + "\n");
            }
            LOGGER.error(sb.toString());
            throw ex;
        }
    }

    private StringEntity generateStringEntity(String json) {
        StringEntity stringEntity = new StringEntity(json, Charset.forName("UTF-8"));
        return stringEntity;
    }

    private ByteArrayEntity generateGZIPCompressEntity(String json) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(baos);
            gzip.write(json.getBytes(DEFAULT_CHARSET));
        }
        catch (IOException e) {
            throw new HttpClientException(e);
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (IOException e) {
                    throw new HttpClientException(e);
                }
            }
        }
        ByteArrayEntity byteEntity = new ByteArrayEntity(baos.toByteArray());
        byteEntity.setContentType("application/json");
        byteEntity.setContentEncoding("gzip");
        return byteEntity;
    }

    public HttpResponse get(String apiPath, String json) throws HttpClientException {
        HttpGetWithEntity request = new HttpGetWithEntity(this.getUrl(apiPath));
        return this.execute(request, json);
    }

    public void get(String apiPath, String json, FutureCallback<HttpResponse> httpCallback) {
        HttpGetWithEntity request = new HttpGetWithEntity(this.getUrl(apiPath));
        this.executeCallback(request, json, httpCallback);
    }

    public HttpResponseCallbackFactory getHttpResponseCallbackFactory() {
        return this.httpResponseCallbackFactory;
    }

    private String getUrl(String apiPath) {
        if (this.sslEnable) {
            return "https://" + this.httpAddressManager.getAddress() + apiPath;
        }
        return "http://" + this.httpAddressManager.getAddress() + apiPath;
    }

    public HttpResponse post(String apiPath, String json) throws HttpClientException {
        return this.post(apiPath, json, new HashMap<String, String>());
    }

    public void post(String apiPath, String json, FutureCallback<HttpResponse> httpCallback) {
        this.post(apiPath, json, null, httpCallback);
    }

    public void postToAddress(String address, String apiPath, String json, FutureCallback<HttpResponse> httpCallback) {
        this.postToAddress(address, apiPath, json, null, httpCallback);
    }

    public void post(String apiPath, String json, Map<String, String> params, FutureCallback<HttpResponse> httpCallback) {
        String httpFullAPI = this.getUrl(apiPath);
        URI uri = this.createURI(httpFullAPI, params);
        HttpPost request = new HttpPost(uri);
        this.executeCallback((HttpEntityEnclosingRequestBase)request, json, httpCallback);
    }

    public void postToAddress(String address, String apiPath, String json, Map<String, String> params, FutureCallback<HttpResponse> httpCallback) {
        String httpFullAPI = this.sslEnable ? "https://" + address + apiPath : "http://" + address + apiPath;
        URI uri = this.createURI(httpFullAPI, params);
        HttpPost request = new HttpPost(uri);
        this.executeCallback((HttpEntityEnclosingRequestBase)request, json, httpCallback);
    }

    public HttpResponse post(String apiPath, String json, Map<String, String> params) throws HttpClientException {
        String httpFullAPI = this.getUrl(apiPath);
        URI uri = this.createURI(httpFullAPI, params);
        HttpPost request = new HttpPost(uri);
        return this.execute((HttpEntityEnclosingRequestBase)request, json);
    }

    private URI createURI(String httpFullAPI, Map<String, String> params) {
        URI uri;
        URIBuilder builder;
        try {
            builder = new URIBuilder(httpFullAPI);
        }
        catch (URISyntaxException e) {
            throw new HttpClientException(e);
        }
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        try {
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new HttpClientException(e);
        }
        return uri;
    }

    public HttpResponse put(String apiPath, String json) throws HttpClientException {
        HttpPut request = new HttpPut(this.getUrl(apiPath));
        return this.execute((HttpEntityEnclosingRequestBase)request, json);
    }

    public void put(String apiPath, String json, FutureCallback<HttpResponse> httpCallback) {
        HttpPost request = new HttpPost(this.getUrl(apiPath));
        this.executeCallback((HttpEntityEnclosingRequestBase)request, json, httpCallback);
    }

    public void start() {
        this.httpclient.start();
    }

    public SemaphoreManager getSemaphoreManager() {
        return this.semaphoreManager;
    }

    public HttpAddressManager getHttpAddressManager() {
        return this.httpAddressManager;
    }

    public String getAddressAndSemaphoreAcquire() {
        String address;
        boolean acquire;
        while (!(acquire = this.semaphoreManager.acquire(address = this.httpAddressManager.getAddress()))) {
        }
        return address;
    }
}

