/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.http;

import com.aliyun.hitsdb.client.Config;
import com.aliyun.hitsdb.client.exception.http.HttpClientInitException;
import com.aliyun.hitsdb.client.http.HiTSDBConnectionKeepAliveStrategy;
import com.aliyun.hitsdb.client.http.HiTSDBConnectionReuseStrategy;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.http.TSDBHttpAsyncCallbackExecutor;
import com.aliyun.hitsdb.client.http.semaphore.SemaphoreManager;
import com.aliyun.hitsdb.client.util.Objects;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final String[] certDNList = new String[]{"*.tsdb.aliyuncs.com", "*.hitsdb.rds.aliyuncs.com"};
    private static final AtomicInteger NUM = new AtomicInteger();

    public static HttpClient createHttpClient(Config config) throws HttpClientInitException {
        PoolingNHttpClientConnectionManager cm;
        Objects.requireNonNull(config);
        DefaultConnectingIOReactor ioReactor = HttpClientFactory.initIOReactorConfig(config);
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs == null) {
                    throw new IllegalArgumentException("checkServerTrusted:x509Certificate array isnull");
                }
                if (certs.length <= 0) {
                    throw new IllegalArgumentException("checkServerTrusted: X509Certificate is empty");
                }
                if (null == authType || !authType.contains("RSA")) {
                    throw new CertificateException("checkServerTrusted: AuthType is not RSA");
                }
                for (X509Certificate cert : certs) {
                    cert.checkValidity();
                    if (cert.getSubjectDN().getName().contains(certDNList[0]) || cert.getSubjectDN().getName().contains(certDNList[1])) continue;
                    throw new IllegalArgumentException("checkServerTrusted: host is invalid");
                }
            }
        }};
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                try {
                    X509Certificate[] peerCertificates;
                    String peerHost = session.getPeerHost();
                    for (X509Certificate certificate : peerCertificates = (X509Certificate[])session.getPeerCertificates()) {
                        String[] split;
                        X500Principal subjectX500Principal = certificate.getSubjectX500Principal();
                        String name = subjectX500Principal.getName();
                        for (String str : split = name.split(",")) {
                            if (!str.startsWith("CN") || !peerHost.equals(hostname) || !str.contains(certDNList[0]) && !str.contains(certDNList[0])) continue;
                            return true;
                        }
                    }
                }
                catch (SSLPeerUnverifiedException e1) {
                    throw new IllegalArgumentException("host check failed: SSLPeerUnverifiedException");
                }
                return false;
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, null);
            Registry sessionStrategyRegistry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(sslContext, null, null, hostnameVerifier)).build();
            cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, sessionStrategyRegistry);
        }
        catch (Exception e) {
            throw new HttpClientInitException();
        }
        SemaphoreManager semaphoreManager = HttpClientFactory.createSemaphoreManager(config);
        CloseableHttpAsyncClient httpAsyncClient = HttpClientFactory.createPoolingHttpClient(config, cm);
        ScheduledExecutorService connectionGcService = HttpClientFactory.initFixedCycleCloseConnection(cm);
        HttpClient httpClientImpl = new HttpClient(config, httpAsyncClient, semaphoreManager, connectionGcService, ioReactor);
        return httpClientImpl;
    }

    private static RequestConfig initRequestConfig(Config config) {
        int httpConnectionRequestTimeout;
        int httpSocketTimeout;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        int httpConnectTimeout = config.getHttpConnectTimeout();
        if (httpConnectTimeout >= 0) {
            requestConfigBuilder.setConnectTimeout(httpConnectTimeout * 1000);
        }
        if ((httpSocketTimeout = config.getHttpSocketTimeout()) >= 0) {
            requestConfigBuilder.setSocketTimeout(httpSocketTimeout * 1000);
        }
        if ((httpConnectionRequestTimeout = config.getHttpConnectionRequestTimeout()) >= 0) {
            requestConfigBuilder.setConnectionRequestTimeout(httpConnectionRequestTimeout * 1000);
        }
        return requestConfigBuilder.build();
    }

    private static DefaultConnectingIOReactor initIOReactorConfig(Config config) {
        int ioThreadCount = config.getIoThreadCount();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(ioThreadCount).build();
        try {
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ex) {
                    LOGGER.error("[Critical] unexpected IOException might cause IoReactor unstable: ", (Throwable)ex);
                    return false;
                }

                public boolean handle(RuntimeException ex) {
                    LOGGER.error("[Critical] unexpected RuntimeException might cause IoReactor unstable: ", (Throwable)ex);
                    return false;
                }
            });
            return ioReactor;
        }
        catch (IOReactorException e) {
            throw new HttpClientInitException();
        }
    }

    private static ScheduledExecutorService initFixedCycleCloseConnection(final PoolingNHttpClientConnectionManager cm) {
        ScheduledExecutorService connectionGcService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Fixed-Cycle-Close-Connection-" + NUM.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        connectionGcService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Close idle connections, fixed cycle operation");
                    }
                    cm.closeIdleConnections(3L, TimeUnit.MINUTES);
                }
                catch (Exception ex) {
                    LOGGER.error("", (Throwable)ex);
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
        return connectionGcService;
    }

    private static SemaphoreManager createSemaphoreManager(Config config) {
        int httpConnectionPool = config.getHttpConnectionPool();
        SemaphoreManager semaphoreManager = null;
        if (httpConnectionPool > 0) {
            String host = config.getHost();
            int port = config.getPort();
            int putRequestLimit = config.getPutRequestLimit();
            String address = String.format("%s:%d", host, port);
            semaphoreManager = SemaphoreManager.create(address, putRequestLimit, config.isPutRequestLimitSwitch());
        }
        return semaphoreManager;
    }

    private static CloseableHttpAsyncClient createPoolingHttpClient(Config config, PoolingNHttpClientConnectionManager cm) throws HttpClientInitException {
        int httpConnectionPool = config.getHttpConnectionPool();
        int httpConnectionLiveTime = config.getHttpConnectionLiveTime();
        int httpKeepaliveTime = config.getHttpKeepaliveTime();
        RequestConfig requestConfig = HttpClientFactory.initRequestConfig(config);
        if (httpConnectionPool > 0) {
            cm.setMaxTotal(httpConnectionPool);
            cm.setDefaultMaxPerRoute(httpConnectionPool);
            cm.closeExpiredConnections();
        }
        HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom();
        httpAsyncClientBuilder.setConnectionManager((NHttpClientConnectionManager)cm);
        if (requestConfig != null) {
            httpAsyncClientBuilder.setDefaultRequestConfig(requestConfig);
        }
        if (httpKeepaliveTime > 0) {
            HiTSDBConnectionKeepAliveStrategy hiTSDBConnectionKeepAliveStrategy = new HiTSDBConnectionKeepAliveStrategy(httpConnectionLiveTime);
            httpAsyncClientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)hiTSDBConnectionKeepAliveStrategy);
        } else if (httpKeepaliveTime == 0) {
            HiTSDBConnectionReuseStrategy hiTSDBConnectionReuseStrategy = new HiTSDBConnectionReuseStrategy();
            httpAsyncClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)hiTSDBConnectionReuseStrategy);
        }
        if (httpConnectionLiveTime > 0) {
            TSDBHttpAsyncCallbackExecutor httpAsyncCallbackExecutor = new TSDBHttpAsyncCallbackExecutor(httpConnectionLiveTime);
            httpAsyncClientBuilder.setEventHandler((NHttpClientEventHandler)httpAsyncCallbackExecutor);
        }
        CloseableHttpAsyncClient client = httpAsyncClientBuilder.build();
        return client;
    }
}

