/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.http.response;

import com.aliyun.hitsdb.client.exception.http.HttpClientException;
import com.aliyun.hitsdb.client.http.HttpClient;
import com.aliyun.hitsdb.client.http.response.HttpStatus;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.util.EntityUtils;

public class ResultResponse {
    private int statusCode;
    private HttpStatus httpStatus;
    private String content;
    private HttpResponse httpResponse;
    private boolean compress;

    public ResultResponse(int statusCode) {
        this.statusCode = statusCode;
        this.httpStatus = statusCode >= 200 && statusCode < 300 ? (statusCode == 204 ? HttpStatus.ServerSuccessNoContent : HttpStatus.ServerSuccess) : (statusCode >= 400 && statusCode < 500 ? (statusCode == 401 ? HttpStatus.ServerUnauthorized : HttpStatus.ServerNotSupport) : (statusCode >= 500 && statusCode < 600 ? HttpStatus.ServerError : HttpStatus.UnKnow));
    }

    public boolean isSuccess() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public ResultResponse(int status, String content) {
        this.statusCode = status;
        this.content = content;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContent() {
        if (this.content == null) {
            HttpEntity entity = this.httpResponse.getEntity();
            try {
                String content = null;
                Header[] headers = this.httpResponse.getHeaders("Content-Encoding");
                if (headers != null && headers.length > 0 && headers[0].getValue().equalsIgnoreCase("gzip")) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(entity);
                    content = EntityUtils.toString((HttpEntity)gzipEntity, (Charset)HttpClient.DEFAULT_CHARSET);
                } else {
                    content = EntityUtils.toString((HttpEntity)entity, (Charset)HttpClient.DEFAULT_CHARSET);
                }
                this.content = content;
            }
            catch (ParseException e) {
                throw new HttpClientException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new HttpClientException(e);
            }
        }
        return this.content;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public static ResultResponse simplify(HttpResponse httpResponse, boolean compress) {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        ResultResponse resultResponse = new ResultResponse(statusCode);
        resultResponse.httpResponse = httpResponse;
        resultResponse.compress = compress;
        return resultResponse;
    }
}

