/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.http.semaphore;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemaphoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemaphoreManager.class);
    private ConcurrentHashMap<String, Semaphore> addressSemaphoreMap;
    private int poolNum;
    private boolean putRequestLimitSwitch = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemaphoreManager(List<String> addresses, int poolNum, boolean putRequestLimitSwitch) {
        SemaphoreManager semaphoreManager = this;
        synchronized (semaphoreManager) {
            this.poolNum = poolNum;
            this.addressSemaphoreMap = new ConcurrentHashMap();
            for (String address : addresses) {
                Semaphore semaphore = new Semaphore(poolNum);
                this.addressSemaphoreMap.put(address, semaphore);
            }
            this.putRequestLimitSwitch = putRequestLimitSwitch;
        }
    }

    private SemaphoreManager(String address, int poolNum, boolean putRequestLimitSwitch) {
        this(Arrays.asList(address), poolNum, putRequestLimitSwitch);
    }

    public static SemaphoreManager create(List<String> addresses, int poolNum, boolean putRequestLimitSwitch) {
        SemaphoreManager semaphoreManager = new SemaphoreManager(addresses, poolNum, putRequestLimitSwitch);
        return semaphoreManager;
    }

    public static SemaphoreManager create(String address, int poolNum, boolean putRequestLimitSwitch) {
        SemaphoreManager semaphoreManager = new SemaphoreManager(address, poolNum, putRequestLimitSwitch);
        return semaphoreManager;
    }

    public void putAddress(String address) {
        this.addressSemaphoreMap.put(address, new Semaphore(this.poolNum));
    }

    public boolean acquire(String address) {
        return this.acquire(address, 3L, 10L, TimeUnit.MILLISECONDS);
    }

    public boolean acquire(String address, long retry, long timeout, TimeUnit unit) {
        if (!this.putRequestLimitSwitch) {
            return true;
        }
        Semaphore semaphore = this.addressSemaphoreMap.get(address);
        if (semaphore == null) {
            LOGGER.warn("the host:{} does not exist in the SemaphoreManager", (Object)address);
            return false;
        }
        int i = 0;
        while ((long)i < retry) {
            boolean acquire = false;
            try {
                acquire = semaphore.tryAcquire(timeout, unit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (acquire) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void release(String address) {
        if (!this.putRequestLimitSwitch) {
            return;
        }
        Semaphore semaphore = this.addressSemaphoreMap.get(address);
        if (semaphore != null) {
            semaphore.release();
        }
    }

    public boolean removeAddress(String address) {
        Semaphore semaphore = this.addressSemaphoreMap.get(address);
        if (semaphore.availablePermits() == this.poolNum) {
            this.addressSemaphoreMap.remove(address);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.addressSemaphoreMap.toString();
    }
}

