/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.hitsdb.client.util.WKTParser;
import com.aliyun.hitsdb.client.value.request.ComplexValue;
import java.text.ParseException;
import java.util.Objects;

public class GeoPointValue
extends ComplexValue {
    public static final String TypeValue = "geopoint";
    @JSONField(serialize=false)
    private double longitude;
    @JSONField(serialize=false)
    private double latitude;

    public GeoPointValue(String content) {
        super(TypeValue, content);
        try {
            WKTParser strParser = new WKTParser(content);
            strParser.moveToExpect('(');
            this.longitude = strParser.nextDouble();
            this.latitude = strParser.nextDouble();
            strParser.nextExpect(')');
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse the geopoint string literal: " + content);
        }
        if (this.longitude < -180.0 || this.longitude > 180.0 || this.latitude < -90.0 || this.latitude > 90.0) {
            throw new IllegalArgumentException("Longitude or latitude is out of valid range: " + content);
        }
    }

    private GeoPointValue(String content, boolean unused) {
        super(TypeValue, content);
    }

    public static GeoPointValue fromLonLat(double longitude, double latitude) {
        if (longitude < -180.0 || longitude > 180.0 || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Longitude or latitude is out of valid range.");
        }
        GeoPointValue result = new GeoPointValue(String.format("POINT (%f %f)", longitude, latitude), false);
        result.longitude = longitude;
        result.latitude = latitude;
        return result;
    }

    public static GeoPointValue fromWKT(String wkt) {
        return new GeoPointValue(wkt);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GeoPointValue)) {
            return false;
        }
        return Double.compare(this.longitude, ((GeoPointValue)o).longitude) == 0 && Double.compare(this.latitude, ((GeoPointValue)o).latitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude);
    }

    public String toString() {
        return this.content;
    }

    public static boolean isJsonObjectTypeMatch(JSONObject jsonObject) {
        return ComplexValue.isJsonObjectTypeMatch(jsonObject) && jsonObject.get((Object)"type").equals(TypeValue);
    }
}

