/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.aliyun.hitsdb.client.util.Objects;
import com.aliyun.hitsdb.client.value.JSONValue;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class MultiValuedPoint
extends JSONValue {
    private String metric;
    private Map<String, String> tags;
    private Map<String, Object> fields;
    private Long timestamp;
    private String json;

    public static MetricBuilder metric(String name, String value) {
        return new MetricBuilder(name, value);
    }

    public String getMetric() {
        return this.metric;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    @Override
    public String toJSON() {
        return super.toJSON();
    }

    private static boolean checkChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_' || c == '.' || c == ' ' || c == ',' || c == '=' || c == '/' || c == ':' || c == '(' || c == ')' || c == '[' || c == ']' || c == '\'' || c == '/' || c == '#' || Character.isLetter(c);
    }

    public static void checkPoint(MultiValuedPoint multiValuedPoint) {
        if (multiValuedPoint.metric == null || multiValuedPoint.metric.length() == 0) {
            throw new IllegalArgumentException("The measurement metric can't be empty");
        }
        if (multiValuedPoint.timestamp == null) {
            throw new IllegalArgumentException("The timestamp can't be null");
        }
        if (multiValuedPoint.timestamp <= 0L) {
            throw new IllegalArgumentException("The timestamp can't be less than or equal to 0");
        }
        if (multiValuedPoint.fields == null || multiValuedPoint.fields.isEmpty()) {
            throw new IllegalArgumentException("The fields can't be null or empty");
        }
        for (Map.Entry<String, Object> entry : multiValuedPoint.fields.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty()) {
                throw new IllegalArgumentException("The field name can't be null or empty.");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("The field value can't be null or empty.");
            }
            if (entry.getValue() instanceof String && ((String)entry.getValue()).isEmpty()) {
                throw new IllegalArgumentException("The String field value can't be empty");
            }
            if (entry.getValue() instanceof Number && entry.getValue() == Double.valueOf(Double.NaN)) {
                throw new IllegalArgumentException("The Number field value can't be NaN");
            }
            if (entry.getValue() instanceof Number && entry.getValue() == Double.valueOf(Double.POSITIVE_INFINITY)) {
                throw new IllegalArgumentException("The Number field value can't be POSITIVE_INFINITY");
            }
            if (entry.getValue() instanceof Number && entry.getValue() == Double.valueOf(Double.NEGATIVE_INFINITY)) {
                throw new IllegalArgumentException("The Number field value can't be NEGATIVE_INFINITY");
            }
            for (int i = 0; i < entry.getKey().length(); ++i) {
                char c = entry.getKey().charAt(i);
                if (MultiValuedPoint.checkChar(c)) continue;
                throw new IllegalArgumentException("There is an invalid character in metric. the char is '" + c + "'");
            }
        }
        if (multiValuedPoint.tags == null || multiValuedPoint.tags.size() == 0) {
            throw new IllegalArgumentException("At least one tag is needed");
        }
        for (Map.Entry<String, Object> entry : multiValuedPoint.tags.entrySet()) {
            char c;
            int i;
            String tagkey = entry.getKey();
            String tagvalue = (String)entry.getValue();
            for (i = 0; i < tagkey.length(); ++i) {
                c = tagkey.charAt(i);
                if (MultiValuedPoint.checkChar(c)) continue;
                throw new IllegalArgumentException("There is an invalid character in tagkey. the tagkey is + " + tagkey + ", the char is '" + c + "'");
            }
            for (i = 0; i < tagvalue.length(); ++i) {
                c = tagvalue.charAt(i);
                if (MultiValuedPoint.checkChar(c)) continue;
                throw new IllegalArgumentException("There is an invalid character in tagvalue. the tag is + <" + tagkey + ":" + tagvalue + "> , the char is '" + c + "'");
            }
        }
    }

    public static class MetricBuilder {
        private String metric;
        private Map<String, String> tags = new HashMap<String, String>();
        private Map<String, Object> fields = new HashMap<String, Object>();
        private Long timestamp;

        public MetricBuilder(String metricTagKey, String metricTagValue) {
            Objects.requireNonNull(metricTagKey, "metric tag key");
            Objects.requireNonNull(metricTagValue, "metric tag value");
            if (metricTagKey.isEmpty()) {
                throw new IllegalArgumentException("Measurement tag key cannot be empty.");
            }
            if (metricTagValue.isEmpty()) {
                throw new IllegalArgumentException("Measurement tag value cannot be empty.");
            }
            this.tags.put(metricTagKey, metricTagValue);
            this.metric = metricTagValue;
        }

        public MetricBuilder tag(String tagName, String value) {
            Objects.requireNonNull(tagName, "tag key");
            Objects.requireNonNull(value, "tag value");
            if (!tagName.isEmpty() && !value.isEmpty()) {
                this.tags.put(tagName, value);
            }
            return this;
        }

        public MetricBuilder tag(Map<String, String> tags) {
            if (tags != null) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public MetricBuilder timestamp(Long timestamp) {
            Objects.requireNonNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }

        public MetricBuilder timestamp(Date date) {
            Objects.requireNonNull(date, "date timestamp");
            this.timestamp = date.getTime();
            return this;
        }

        public MetricBuilder fields(String fieldName, Object fieldValue) {
            Objects.requireNonNull(fieldName, "field name");
            if (fieldValue != null) {
                this.fields.put(fieldName, fieldValue);
            }
            return this;
        }

        public MetricBuilder fields(Map<String, Object> fields) {
            if (fields != null) {
                this.fields.putAll(fields);
            }
            return this;
        }

        public MultiValuedPoint build() {
            return this.build(true);
        }

        public MultiValuedPoint build(boolean checkPoint) {
            MultiValuedPoint multiValuedPoint = new MultiValuedPoint();
            multiValuedPoint.metric = this.metric;
            multiValuedPoint.tags = this.tags;
            multiValuedPoint.fields = this.fields;
            multiValuedPoint.timestamp = this.timestamp;
            if (checkPoint) {
                MultiValuedPoint.checkPoint(multiValuedPoint);
            }
            return multiValuedPoint;
        }

        private String buildJSON(MultiValuedPoint point) {
            return JSON.toJSONString((Object)point);
        }
    }
}

