/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.aliyun.hitsdb.client.util.Objects;
import com.aliyun.hitsdb.client.value.request.AbstractPoint;
import com.aliyun.hitsdb.client.value.request.PointType;
import com.aliyun.hitsdb.client.value.request.ValueSerializer;
import com.aliyun.hitsdb.client.value.type.Granularity;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JSONType(ignores={"granularityType"})
public class Point
extends AbstractPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(Point.class);
    @JSONField(serializeUsing=ValueSerializer.class, deserializeUsing=ValueSerializer.class)
    private Object value;
    private String granularity;
    private String aggregator;
    private Long version;

    public static MetricBuilder metric(String metric) {
        return new MetricBuilder(metric);
    }

    public Object getValue() {
        return this.value;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public Granularity getGranularityType() {
        if (this.granularity == null) {
            return Granularity.S1;
        }
        return Granularity.getEnum(this.granularity);
    }

    public String getGranularity() {
        return this.granularity;
    }

    @Override
    public PointType getPointType() {
        return PointType.SINGLE_VALUE;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public void setAggregator(String aggregator) {
        this.aggregator = aggregator;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public static void checkPoint(Point point) {
        if (point.metric == null || point.metric.length() == 0) {
            throw new IllegalArgumentException("The metric can't be empty");
        }
        if (point.timestamp == null) {
            throw new IllegalArgumentException("The timestamp can't be null");
        }
        Point.checkTimestamp(point.timestamp);
        if (point.value == null) {
            throw new IllegalArgumentException("The value can't be all null");
        }
        if (point.value instanceof Number && point.value == Double.valueOf(Double.NaN)) {
            throw new IllegalArgumentException("The value can't be NaN");
        }
        if (point.value instanceof Number && point.value == Double.valueOf(Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("The value can't be POSITIVE_INFINITY");
        }
        if (point.value instanceof Number && point.value == Double.valueOf(Double.NEGATIVE_INFINITY)) {
            throw new IllegalArgumentException("The value can't be NEGATIVE_INFINITY");
        }
        for (int i = 0; i < point.metric.length(); ++i) {
            char c = point.metric.charAt(i);
            if (Point.checkChar(c)) continue;
            throw new IllegalArgumentException("There is an invalid character in metric. the char is '" + c + "'");
        }
        if (point.tags == null || point.tags.isEmpty()) {
            return;
        }
        for (Map.Entry entry : point.tags.entrySet()) {
            char c;
            int i;
            String tagkey = (String)entry.getKey();
            String tagvalue = (String)entry.getValue();
            if (tagkey == null || tagkey.length() == 0) {
                throw new IllegalArgumentException("the tag key is null or empty");
            }
            if (tagvalue == null) {
                throw new IllegalArgumentException("the tag value is null");
            }
            for (i = 0; i < tagkey.length(); ++i) {
                c = tagkey.charAt(i);
                if (Point.checkChar(c)) continue;
                throw new IllegalArgumentException("There is an invalid character in tagkey. the tagkey is + " + tagkey + ", the char is '" + c + "'");
            }
            for (i = 0; i < tagvalue.length(); ++i) {
                c = tagvalue.charAt(i);
                if (Point.checkChar(c)) continue;
                throw new IllegalArgumentException("There is an invalid character in tagvalue. the tag is + <" + tagkey + ":" + tagvalue + "> , the char is '" + c + "'");
            }
        }
    }

    public static class MetricBuilder {
        private String metric;
        private Map<String, String> tags = new HashMap<String, String>();
        private Object value;
        private long timestamp;
        private Granularity granularityType;
        private String granularity;
        private String aggregator;
        private Long version;

        public MetricBuilder(String metric) {
            this.metric = metric;
        }

        public MetricBuilder tag(String tagName, String value) {
            Objects.requireNonNull(tagName, "tagName");
            Objects.requireNonNull(value, "value");
            if (!tagName.isEmpty()) {
                this.tags.put(tagName, value);
            } else {
                LOGGER.warn("Warning. Tag name is empty. We will ignore them as we cannot process the empty tag name.");
            }
            return this;
        }

        public MetricBuilder tag(Map<String, String> tags) {
            if (tags != null) {
                this.tags.putAll(tags);
            }
            return this;
        }

        public MetricBuilder aggregator(String aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public MetricBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public MetricBuilder timestamp(Date date) {
            Objects.requireNonNull(date);
            this.timestamp = date.getTime();
            return this;
        }

        public MetricBuilder value(Object value) {
            Objects.requireNonNull(value);
            this.value = value;
            return this;
        }

        public MetricBuilder value(long timestamp, Object value) {
            Objects.requireNonNull(value);
            this.timestamp = timestamp;
            this.value = value;
            return this;
        }

        public MetricBuilder value(Date date, Object value) {
            Objects.requireNonNull(value);
            Objects.requireNonNull(date);
            this.timestamp = date.getTime();
            this.value = value;
            return this;
        }

        public MetricBuilder granularity(Granularity granularity) {
            if (granularity == null) {
                return this;
            }
            if (granularity.equals((Object)Granularity.S1)) {
                return this;
            }
            this.granularityType = granularity;
            this.granularity = this.granularityType.getName();
            return this;
        }

        public MetricBuilder version(Long version) {
            this.version = version;
            return this;
        }

        public Point build() {
            return this.build(true);
        }

        public Point build(boolean checkPoint) {
            Point point = new Point();
            point.metric = this.metric;
            point.tags = this.tags;
            point.timestamp = this.timestamp;
            point.value = this.value;
            point.granularity = this.granularity;
            point.aggregator = this.aggregator;
            point.version = this.version;
            if (checkPoint) {
                Point.checkPoint(point);
            }
            return point;
        }

        private String buildJSON(Point point) {
            return JSON.toJSONString((Object)point);
        }
    }
}

