/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.hitsdb.client.value.request.ByteArrayValue;
import com.aliyun.hitsdb.client.value.request.ComplexValue;
import com.aliyun.hitsdb.client.value.request.GeoPointValue;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSerializer
implements ObjectSerializer,
ObjectDeserializer {
    private static final Logger log = LoggerFactory.getLogger(ValueSerializer.class);

    public void write(JSONSerializer jsonSerializer, Object o, Object o1, Type type, int i) throws IOException {
        if (o instanceof byte[]) {
            ByteArrayValue bv = new ByteArrayValue((byte[])o);
            jsonSerializer.write((Object)bv);
            return;
        }
        jsonSerializer.write(o);
    }

    public Object deserialze(DefaultJSONParser parser, Type type, Object o) {
        JSONObject jsonObject;
        Object parse = parser.parse();
        if (parse == null) {
            return null;
        }
        if (parse instanceof JSONObject && ComplexValue.isJsonObjectTypeMatch(jsonObject = (JSONObject)parse)) {
            String valueType = jsonObject.getString("type");
            if ("bytes".equals(valueType)) {
                ByteArrayValue bv = (ByteArrayValue)JSON.parseObject((String)jsonObject.toJSONString(), ByteArrayValue.class);
                return bv.decode();
            }
            if ("geopoint".equals(valueType)) {
                GeoPointValue gp = (GeoPointValue)JSON.parseObject((String)jsonObject.toJSONString(), GeoPointValue.class);
                return gp;
            }
            log.error("Illegal value type {}", (Object)valueType);
            throw new IllegalArgumentException("Illegal value type " + valueType);
        }
        return parse;
    }

    public int getFastMatchToken() {
        return 0;
    }
}

