/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.ServiceException;
import com.aliyun.mq.http.common.auth.ServiceCredentials;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.model.AsyncCallback;
import com.aliyun.mq.http.model.AsyncResult;
import com.aliyun.mq.http.model.TopicMessage;
import com.aliyun.mq.http.model.action.PublishMessageAction;
import com.aliyun.mq.http.model.request.PublishMessageRequest;
import java.net.URI;

public class MQProducer {
    protected ServiceClient serviceClient;
    protected String topicURL;
    protected String topicName;
    protected ServiceCredentials credentials;
    protected URI endpoint;
    protected String instanceId;

    protected MQProducer(String instanceId, String topicName, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.instanceId = instanceId;
        this.serviceClient = client;
        this.credentials = credentials;
        this.endpoint = endpoint;
        String uri = endpoint.toString();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        this.topicURL = uri = uri + "topics/" + topicName;
        this.topicName = topicName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    protected void checkMessage(TopicMessage msg) throws ClientException {
        String prop = msg.getProperties().get("__TransCheckT");
        if (prop == null || prop.length() <= 0) {
            return;
        }
        try {
            Integer.valueOf(prop);
        }
        catch (Throwable e) {
            throw new ClientException("Should setTransCheckImmunityTime Integer!", "LocalClientError");
        }
        prop = msg.getProperties().get("__STARTDELIVERTIME");
        if (prop == null || prop.length() <= 0) {
            return;
        }
        try {
            Long.valueOf(prop);
        }
        catch (Throwable e) {
            throw new ClientException("Should setStartDeliverTime Long!", "LocalClientError");
        }
    }

    public TopicMessage publishMessage(TopicMessage msg) throws ServiceException, ClientException {
        this.checkMessage(msg);
        PublishMessageRequest request = new PublishMessageRequest();
        request.setMessage(msg);
        request.setInstanceId(this.instanceId);
        PublishMessageAction action = new PublishMessageAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return (TopicMessage)action.executeWithCustomHeaders(request, null);
    }

    public AsyncResult<TopicMessage> asyncPublishMessage(TopicMessage msg, AsyncCallback<TopicMessage> callback) {
        this.checkMessage(msg);
        PublishMessageRequest request = new PublishMessageRequest();
        request.setMessage(msg);
        request.setInstanceId(this.instanceId);
        PublishMessageAction action = new PublishMessageAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return action.executeWithCustomHeaders(request, callback, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MQProducer{");
        sb.append("topicName='").append(this.topicName).append('\'');
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", instanceId='").append(this.instanceId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

