/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.common.http;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.HttpMethod;
import com.aliyun.mq.http.common.comm.ExecutionContext;
import com.aliyun.mq.http.common.comm.RepeatableInputStreamEntity;
import com.aliyun.mq.http.common.http.ClientConfiguration;
import com.aliyun.mq.http.common.http.HttpDeleteWrapper;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.common.utils.VersionInfoUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.auth.AuthScope;
import shaded.org.apache.http.auth.NTCredentials;
import shaded.org.apache.http.client.config.RequestConfig;
import shaded.org.apache.http.client.methods.HttpGet;
import shaded.org.apache.http.client.methods.HttpHead;
import shaded.org.apache.http.client.methods.HttpOptions;
import shaded.org.apache.http.client.methods.HttpPost;
import shaded.org.apache.http.client.methods.HttpPut;
import shaded.org.apache.http.client.methods.HttpRequestBase;
import shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import shaded.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import shaded.org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import shaded.org.apache.http.impl.nio.client.HttpAsyncClients;
import shaded.org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import shaded.org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import shaded.org.apache.http.impl.nio.reactor.IOReactorConfig;
import shaded.org.apache.http.nio.conn.NHttpClientConnectionManager;
import shaded.org.apache.http.nio.reactor.IOReactorException;

public class HttpFactory {
    private static SSLConnectionSocketFactory getSSLSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, null);
            SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return ssf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PoolingNHttpClientConnectionManager createConnectionManager(ClientConfiguration config) {
        DefaultConnectingIOReactor ioReactor;
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(config.getIoReactorThreadCount()).setConnectTimeout(config.getConnectionTimeout()).setSoTimeout(config.getSocketTimeout()).setSoKeepAlive(config.isSoKeepAlive()).build();
        try {
            ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        }
        catch (IOReactorException e) {
            throw new RuntimeException(e);
        }
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager(ioReactor);
        connManager.setDefaultMaxPerRoute(config.getMaxConnectionsPerRoute());
        connManager.setMaxTotal(config.getMaxConnections());
        return connManager;
    }

    public static CloseableHttpAsyncClient createHttpAsyncClient(PoolingNHttpClientConnectionManager connManager, ClientConfiguration config) {
        HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom().setConnectionManager(connManager);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            httpClientBuilder.setProxy(proxy);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            if (proxyUsername != null && proxyPassword != null) {
                String proxyDomain = config.getProxyDomain();
                String proxyWorkstation = config.getProxyWorkstation();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(proxy), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
                httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("best-match").setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Arrays.asList("Basic")).setConnectTimeout(config.getConnectionTimeout()).setSocketTimeout(config.getSocketTimeout()).setExpectContinueEnabled(config.isExceptContinue()).build();
        httpClientBuilder.setDefaultRequestConfig(defaultRequestConfig);
        httpClientBuilder.setMaxConnPerRoute(config.getMaxConnectionsPerRoute());
        httpClientBuilder.setMaxConnTotal(config.getMaxConnections());
        httpClientBuilder.setUserAgent(VersionInfoUtils.getDefaultUserAgent());
        CloseableHttpAsyncClient httpclient = httpClientBuilder.build();
        return httpclient;
    }

    public static HttpRequestBase createHttpRequest(ServiceClient.Request request, ExecutionContext context) {
        HttpRequestBase httpRequest;
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() != null) {
                postMethod.setEntity(new RepeatableInputStreamEntity(request));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request.getContent() != null) {
                putMethod.setEntity(new RepeatableInputStreamEntity(request));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            HttpDeleteWrapper deleteMethod = new HttpDeleteWrapper(uri);
            if (request.getContent() != null) {
                deleteMethod.setEntity(new RepeatableInputStreamEntity(request));
            }
            httpRequest = deleteMethod;
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported HTTP method: %s.", request.getMethod().toString()));
        }
        HttpFactory.configureRequestHeaders(request, context, httpRequest);
        return httpRequest;
    }

    private static void configureRequestHeaders(ServiceClient.Request request, ExecutionContext context, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public static class IdleConnectionMonitor
    extends Thread {
        private static final IdleConnectionMonitor instance = new IdleConnectionMonitor();
        private final List<NHttpClientConnectionManager> connMgrs = new ArrayList<NHttpClientConnectionManager>();
        private volatile boolean shutdown = false;
        private int CONNECTION_MANAGER_LIMIT = 50;

        private IdleConnectionMonitor() {
            this.setName("IdleConnectionMonitorThread");
            this.setDaemon(true);
            this.start();
        }

        public static IdleConnectionMonitor getInstance() {
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addConnMgr(NHttpClientConnectionManager connMgr) {
            List<NHttpClientConnectionManager> list = this.connMgrs;
            synchronized (list) {
                if (this.CONNECTION_MANAGER_LIMIT > 0 && this.connMgrs.size() > this.CONNECTION_MANAGER_LIMIT) {
                    throw new ClientException("Too Many ServiceClient created.", null);
                }
                this.connMgrs.add(connMgr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeConnMgr(NHttpClientConnectionManager connMgr) {
            List<NHttpClientConnectionManager> list = this.connMgrs;
            synchronized (list) {
                this.connMgrs.remove(connMgr);
            }
        }

        public void set_CONNECTION_MANAGER_LIMIT(int limit) {
            this.CONNECTION_MANAGER_LIMIT = limit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    ArrayList<NHttpClientConnectionManager> tmpConnMgrs;
                    IdleConnectionMonitor.sleep(15000L);
                    List<NHttpClientConnectionManager> list = this.connMgrs;
                    synchronized (list) {
                        tmpConnMgrs = new ArrayList<NHttpClientConnectionManager>(this.connMgrs);
                    }
                    for (NHttpClientConnectionManager connMgr : tmpConnMgrs) {
                        connMgr.closeExpiredConnections();
                        connMgr.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void shutdown() {
            this.shutdown = true;
        }
    }
}

