/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.common.utils;

import java.net.URI;
import java.net.URISyntaxException;
import shaded.org.apache.commons.logging.Log;
import shaded.org.apache.commons.logging.LogFactory;

public class Utils {
    public static Log logger = LogFactory.getLog(Utils.class);

    public static URI getHttpURI(String endpoint) {
        if (endpoint == null) {
            logger.warn("Endpoint is null");
            throw new NullPointerException("Endpoint is null");
        }
        try {
            if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
                logger.warn("Only support http or https protocol.Endpoint must be started by http:// or https://.");
                throw new IllegalArgumentException("Only support http or https protocol\u3002Endpoint must be started by http:// or https://.");
            }
            while (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            if (endpoint.length() < "http://".length()) {
                logger.warn("Invalid endpoint.");
                throw new IllegalArgumentException("Invalid endpoint.");
            }
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            logger.warn("uri syntax error");
            throw new IllegalArgumentException(e);
        }
    }
}

