/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jcl;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.jcl.LogAdapter;
import org.apache.logging.log4j.spi.LoggerAdapter;
import shaded.org.apache.commons.logging.Log;
import shaded.org.apache.commons.logging.LogConfigurationException;
import shaded.org.apache.commons.logging.LogFactory;

public class LogFactoryImpl
extends LogFactory {
    private final LoggerAdapter<Log> adapter = new LogAdapter();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    @Override
    public Log getInstance(String name) throws LogConfigurationException {
        return this.adapter.getLogger(name);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    @Override
    public void release() {
        try {
            this.adapter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }
}

