/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.sample;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.Histogram;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.log.response.GetHistogramsResponse;
import com.aliyun.openservices.log.response.GetLogsResponse;
import com.aliyun.openservices.log.response.ListTopicsResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class SlsSample {
    public static void main(String[] args) throws LogException, InterruptedException {
        String accessId = "your_access_id";
        String accessKey = "your_access_key";
        String project = "your_project_name";
        String host = "";
        String logStore = "your_logstore";
        String topic = "TestTopic_2";
        int shardId = 0;
        Client client = new Client(host, accessId, accessKey);
        String cursor = client.GetCursor(project, logStore, shardId, Consts.CursorMode.END).GetCursor();
        System.out.println("cursor = " + cursor);
        try {
            while (true) {
                BatchGetLogResponse r_res = client.BatchGetLog(project, logStore, shardId, 1000, cursor);
                System.out.println(r_res.GetCount());
                System.out.println("cursor = " + cursor + " next_cursor = " + r_res.GetNextCursor());
                cursor = r_res.GetNextCursor();
                Thread.sleep(200L);
            }
        }
        catch (LogException e) {
            int to;
            int from;
            String query;
            System.out.println(e.GetRequestId() + e.GetErrorMessage());
            if (shardId > 0) {
                return;
            }
            int from_t = (int)(new Date().getTime() / 1000L) - 36000;
            int to_t = (int)(new Date().getTime() / 1000L) - 100;
            GetLogsResponse res = client.GetLogs(project, logStore, from_t, to_t, topic, "", 10, 0, false);
            System.out.println("Returned log data count:" + res.GetCount());
            for (QueriedLog log : res.GetLogs()) {
                System.out.println("source : " + log.GetSource());
                LogItem item = log.GetLogItem();
                System.out.println("time : " + item.mLogTime);
                for (LogContent content : item.mContents) {
                    System.out.println(content.mKey + ":" + content.mValue);
                }
            }
            int log_group_num = 10;
            for (int i = 0; i < log_group_num; ++i) {
                Vector<LogItem> logGroup = new Vector<LogItem>();
                LogItem logItem = new LogItem((int)(new Date().getTime() / 1000L));
                logItem.PushBack("level", "info");
                logItem.PushBack("name", String.valueOf(i));
                logItem.PushBack("message", "it's a test message");
                logGroup.add(logItem);
                LogItem logItem2 = new LogItem((int)(new Date().getTime() / 1000L));
                logItem2.PushBack("level", "error");
                logItem2.PushBack("name", String.valueOf(i));
                logItem2.PushBack("message", "it's a test message");
                logGroup.add(logItem2);
                try {
                    client.PutLogs(project, logStore, topic, logGroup, "");
                    continue;
                }
                catch (LogException e2) {
                    System.out.println("error code :" + e2.GetErrorCode());
                    System.out.println("error message :" + e2.GetErrorMessage());
                    System.out.println("error requestId :" + e2.GetRequestId());
                    throw e2;
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            try {
                ArrayList<String> logStores = client.ListLogStores(project, 0, 500, "").GetLogStores();
                System.out.println("ListLogs:" + logStores.toString() + "\n");
            }
            catch (LogException e3) {
                System.out.print(e3.getCause());
                System.out.println("error code :" + e3.GetErrorCode());
                System.out.println("error message :" + e3.GetErrorMessage());
                System.out.println("error requestId :" + e3.GetRequestId());
                throw e3;
            }
            try {
                String token = "";
                ListTopicsResponse listTopicResponse = client.ListTopics(project, logStore, token, 10);
                ArrayList<String> topics = listTopicResponse.GetTopics();
                System.out.println("ListTopics:" + topics.toString());
                System.out.println("NextTopic:" + listTopicResponse.GetNextToken() + "\n");
            }
            catch (LogException e4) {
                System.out.println("error code :" + e4.GetErrorCode());
                System.out.println("error message :" + e4.GetErrorMessage());
                System.out.println("error requestId :" + e4.GetRequestId());
                throw e4;
            }
            try {
                query = "";
                from = (int)(new Date().getTime() / 1000L - 10000L);
                to = (int)(new Date().getTime() / 1000L + 10L);
                GetHistogramsResponse histogramsResponse = client.GetHistograms(project, logStore, from, to, topic, query);
                System.out.println("histogram result: " + histogramsResponse.GetTotalCount());
                System.out.println("is_completed : " + histogramsResponse.IsCompleted());
                for (Histogram histogram : histogramsResponse.GetHistograms()) {
                    System.out.println("beginTime:" + histogram.mFromTime + " endTime:" + histogram.mToTime + " logCount:" + histogram.mCount + " is_completed:" + histogram.mIsCompleted);
                }
                System.out.println("");
            }
            catch (LogException e5) {
                System.out.println("error code :" + e5.GetErrorCode());
                System.out.println("error message :" + e5.GetErrorMessage());
                System.out.println("error requestId :" + e5.GetRequestId());
                throw e5;
            }
            try {
                query = "error";
                from = (int)(new Date().getTime() / 1000L - 10000L);
                to = (int)(new Date().getTime() / 1000L + 10L);
                GetLogsResponse logsResponse = client.GetLogs(project, logStore, from, to, topic, query, 10, 0, false);
                System.out.println("Returned log data count:" + logsResponse.GetCount());
                for (QueriedLog log : logsResponse.GetLogs()) {
                    System.out.println("source : " + log.GetSource());
                    LogItem item = log.GetLogItem();
                    System.out.println("time : " + item.mLogTime);
                    for (LogContent content : item.mContents) {
                        System.out.println(content.mKey + ":" + content.mValue);
                    }
                }
            }
            catch (LogException e6) {
                System.out.println("error code :" + e6.GetErrorCode());
                System.out.println("error message :" + e6.GetErrorMessage());
                throw e6;
            }
            return;
        }
    }
}

