/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.internal.model.OSSErrorResult;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = "ConnectionRefused";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonRepeatableRequestException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(requestId, errorCode, cause.getMessage(), cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }

    public static ClientException createInvalidResponseException(String requestId, String message, Throwable cause) {
        return new ClientException(message, "InvalidResponse", requestId, cause);
    }

    public static OSSException createOSSException(OSSErrorResult errorResult) {
        return new OSSException(errorResult.Message != null ? errorResult.Message : null, errorResult.Code != null ? errorResult.Code : null, errorResult.RequestId != null ? errorResult.RequestId : null, errorResult.HostId != null ? errorResult.HostId : null, errorResult.Header != null ? errorResult.Header : null, errorResult.ResourceType != null ? errorResult.ResourceType : null, errorResult.Method != null ? errorResult.Method : null);
    }

    public static OSSException createOSSException(String requestId, String errorCode, String message) {
        return new OSSException(message, errorCode, requestId, null, null, null, null);
    }
}

