/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.parser;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.io.FixedLengthInputStream;
import com.aliyun.oss.common.parser.Marshaller;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.model.AddBucketCnameRequest;
import com.aliyun.oss.model.AddBucketReplicationRequest;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.DeleteBucketCnameRequest;
import com.aliyun.oss.model.DeleteBucketReplicationRequest;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutBucketImageRequest;
import com.aliyun.oss.model.PutImageStyleRequest;
import com.aliyun.oss.model.RoutingRule;
import com.aliyun.oss.model.SetBucketCORSRequest;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketTaggingRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.UserQos;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public final class RequestMarshallers {
    public static final StringMarshaller stringMarshaller = new StringMarshaller();
    public static final DeleteObjectsRequestMarshaller deleteObjectsRequestMarshaller = new DeleteObjectsRequestMarshaller();
    public static final CreateBucketRequestMarshaller createBucketRequestMarshaller = new CreateBucketRequestMarshaller();
    public static final BucketRefererMarshaller bucketRefererMarshaller = new BucketRefererMarshaller();
    public static final SetBucketLoggingRequestMarshaller setBucketLoggingRequestMarshaller = new SetBucketLoggingRequestMarshaller();
    public static final SetBucketWebsiteRequestMarshaller setBucketWebsiteRequestMarshaller = new SetBucketWebsiteRequestMarshaller();
    public static final SetBucketLifecycleRequestMarshaller setBucketLifecycleRequestMarshaller = new SetBucketLifecycleRequestMarshaller();
    public static final PutBucketImageRequestMarshaller putBucketImageRequestMarshaller = new PutBucketImageRequestMarshaller();
    public static final PutImageStyleRequestMarshaller putImageStyleRequestMarshaller = new PutImageStyleRequestMarshaller();
    public static final SetBucketCORSRequestMarshaller setBucketCORSRequestMarshaller = new SetBucketCORSRequestMarshaller();
    public static final SetBucketTaggingRequestMarshaller setBucketTaggingRequestMarshaller = new SetBucketTaggingRequestMarshaller();
    public static final AddBucketReplicationRequestMarshaller addBucketReplicationRequestMarshaller = new AddBucketReplicationRequestMarshaller();
    public static final DeleteBucketReplicationRequestMarshaller deleteBucketReplicationRequestMarshaller = new DeleteBucketReplicationRequestMarshaller();
    public static final AddBucketCnameRequestMarshaller addBucketCnameRequestMarshaller = new AddBucketCnameRequestMarshaller();
    public static final DeleteBucketCnameRequestMarshaller deleteBucketCnameRequestMarshaller = new DeleteBucketCnameRequestMarshaller();
    public static final SetBucketQosRequestMarshaller setBucketQosRequestMarshaller = new SetBucketQosRequestMarshaller();
    public static final CompleteMultipartUploadRequestMarshaller completeMultipartUploadRequestMarshaller = new CompleteMultipartUploadRequestMarshaller();

    private static String escapeKey(String key) {
        if (key == null) {
            return "";
        }
        int len = key.length();
        StringBuilder builder = new StringBuilder();
        for (int pos = 0; pos < len; ++pos) {
            EscapedChar escapedChar;
            char ch = key.charAt(pos);
            switch (ch) {
                case '\t': {
                    escapedChar = EscapedChar.TAB;
                    break;
                }
                case '\n': {
                    escapedChar = EscapedChar.NEWLINE;
                    break;
                }
                case '\r': {
                    escapedChar = EscapedChar.RETURN;
                    break;
                }
                case '&': {
                    escapedChar = EscapedChar.AMP;
                    break;
                }
                case '\"': {
                    escapedChar = EscapedChar.QUOT;
                    break;
                }
                case '<': {
                    escapedChar = EscapedChar.LT;
                    break;
                }
                case '>': {
                    escapedChar = EscapedChar.GT;
                    break;
                }
                default: {
                    escapedChar = null;
                }
            }
            if (escapedChar != null) {
                builder.append(escapedChar.toString());
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static enum EscapedChar {
        RETURN("&#x000D;"),
        NEWLINE("&#x000A;"),
        SPACE("&#x0020;"),
        TAB("&#x0009;"),
        QUOT("&quot;"),
        AMP("&amp;"),
        LT("&lt;"),
        GT("&gt;");

        private final String escapedChar;

        private EscapedChar(String escapedChar) {
            this.escapedChar = escapedChar;
        }

        public String toString() {
            return this.escapedChar;
        }
    }

    public static final class SetBucketQosRequestMarshaller
    implements RequestMarshaller2<UserQos> {
        @Override
        public byte[] marshall(UserQos userQos) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<BucketUserQos>");
            if (userQos.hasStorageCapacity()) {
                xmlBody.append("<StorageCapacity>" + userQos.getStorageCapacity() + "</StorageCapacity>");
            }
            xmlBody.append("</BucketUserQos>");
            byte[] rawData = null;
            try {
                rawData = xmlBody.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unsupported encoding " + e.getMessage(), e);
            }
            return rawData;
        }
    }

    public static final class DeleteBucketCnameRequestMarshaller
    implements RequestMarshaller2<DeleteBucketCnameRequest> {
        @Override
        public byte[] marshall(DeleteBucketCnameRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<BucketCnameConfiguration>");
            xmlBody.append("<Cname>");
            xmlBody.append("<Domain>" + request.getDomain() + "</Domain>");
            xmlBody.append("</Cname>");
            xmlBody.append("</BucketCnameConfiguration>");
            byte[] rawData = null;
            try {
                rawData = xmlBody.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unsupported encoding " + e.getMessage(), e);
            }
            return rawData;
        }
    }

    public static final class AddBucketCnameRequestMarshaller
    implements RequestMarshaller2<AddBucketCnameRequest> {
        @Override
        public byte[] marshall(AddBucketCnameRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<BucketCnameConfiguration>");
            xmlBody.append("<Cname>");
            xmlBody.append("<Domain>" + request.getDomain() + "</Domain>");
            xmlBody.append("</Cname>");
            xmlBody.append("</BucketCnameConfiguration>");
            byte[] rawData = null;
            try {
                rawData = xmlBody.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unsupported encoding " + e.getMessage(), e);
            }
            return rawData;
        }
    }

    public static final class DeleteBucketReplicationRequestMarshaller
    implements RequestMarshaller2<DeleteBucketReplicationRequest> {
        @Override
        public byte[] marshall(DeleteBucketReplicationRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<ReplicationRules>");
            xmlBody.append("<ID>" + RequestMarshallers.escapeKey(request.getReplicationRuleID()) + "</ID>");
            xmlBody.append("</ReplicationRules>");
            byte[] rawData = null;
            try {
                rawData = xmlBody.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unsupported encoding " + e.getMessage(), e);
            }
            return rawData;
        }
    }

    public static final class AddBucketReplicationRequestMarshaller
    implements RequestMarshaller<AddBucketReplicationRequest> {
        @Override
        public FixedLengthInputStream marshall(AddBucketReplicationRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<ReplicationConfiguration>");
            xmlBody.append("<Rule>");
            xmlBody.append("<ID>" + RequestMarshallers.escapeKey(request.getReplicationRuleID()) + "</ID>");
            xmlBody.append("<Destination>");
            xmlBody.append("<Bucket>" + request.getTargetBucketName() + "</Bucket>");
            xmlBody.append("<Location>" + request.getTargetBucketLocation() + "</Location>");
            xmlBody.append("</Destination>");
            if (request.isEnableHistoricalObjectReplication()) {
                xmlBody.append("<HistoricalObjectReplication>enabled</HistoricalObjectReplication>");
            } else {
                xmlBody.append("<HistoricalObjectReplication>disabled</HistoricalObjectReplication>");
            }
            xmlBody.append("</Rule>");
            xmlBody.append("</ReplicationConfiguration>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class SetBucketTaggingRequestMarshaller
    implements RequestMarshaller<SetBucketTaggingRequest> {
        @Override
        public FixedLengthInputStream marshall(SetBucketTaggingRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            TagSet tagSet = request.getTagSet();
            xmlBody.append("<Tagging><TagSet>");
            Map<String, String> tags = tagSet.getAllTags();
            if (!tags.isEmpty()) {
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    xmlBody.append("<Tag>");
                    xmlBody.append("<Key>" + tag.getKey() + "</Key>");
                    xmlBody.append("<Value>" + tag.getValue() + "</Value>");
                    xmlBody.append("</Tag>");
                }
            }
            xmlBody.append("</TagSet></Tagging>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class DeleteObjectsRequestMarshaller
    implements RequestMarshaller2<DeleteObjectsRequest> {
        @Override
        public byte[] marshall(DeleteObjectsRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            boolean quiet = request.isQuiet();
            List<String> keysToDelete = request.getKeys();
            xmlBody.append("<Delete>");
            xmlBody.append("<Quiet>" + quiet + "</Quiet>");
            for (int i = 0; i < keysToDelete.size(); ++i) {
                String key = keysToDelete.get(i);
                xmlBody.append("<Object>");
                xmlBody.append("<Key>" + RequestMarshallers.escapeKey(key) + "</Key>");
                xmlBody.append("</Object>");
            }
            xmlBody.append("</Delete>");
            byte[] rawData = null;
            try {
                rawData = xmlBody.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unsupported encoding " + e.getMessage(), e);
            }
            return rawData;
        }
    }

    public static final class CompleteMultipartUploadRequestMarshaller
    implements RequestMarshaller<CompleteMultipartUploadRequest> {
        @Override
        public FixedLengthInputStream marshall(CompleteMultipartUploadRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            List<PartETag> eTags = request.getPartETags();
            xmlBody.append("<CompleteMultipartUpload>");
            for (int i = 0; i < eTags.size(); ++i) {
                PartETag part = eTags.get(i);
                String eTag = (Object)((Object)EscapedChar.QUOT) + part.getETag().replace("\"", "") + (Object)((Object)EscapedChar.QUOT);
                xmlBody.append("<Part>");
                xmlBody.append("<PartNumber>" + part.getPartNumber() + "</PartNumber>");
                xmlBody.append("<ETag>" + eTag + "</ETag>");
                xmlBody.append("</Part>");
            }
            xmlBody.append("</CompleteMultipartUpload>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class SetBucketCORSRequestMarshaller
    implements RequestMarshaller<SetBucketCORSRequest> {
        @Override
        public FixedLengthInputStream marshall(SetBucketCORSRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<CORSConfiguration>");
            for (SetBucketCORSRequest.CORSRule rule : request.getCorsRules()) {
                xmlBody.append("<CORSRule>");
                for (String allowedOrigin : rule.getAllowedOrigins()) {
                    xmlBody.append("<AllowedOrigin>" + allowedOrigin + "</AllowedOrigin>");
                }
                for (String allowedMethod : rule.getAllowedMethods()) {
                    xmlBody.append("<AllowedMethod>" + allowedMethod + "</AllowedMethod>");
                }
                if (rule.getAllowedHeaders().size() > 0) {
                    for (String allowedHeader : rule.getAllowedHeaders()) {
                        xmlBody.append("<AllowedHeader>" + allowedHeader + "</AllowedHeader>");
                    }
                }
                if (rule.getExposeHeaders().size() > 0) {
                    for (String exposeHeader : rule.getExposeHeaders()) {
                        xmlBody.append("<ExposeHeader>" + exposeHeader + "</ExposeHeader>");
                    }
                }
                if (null != rule.getMaxAgeSeconds()) {
                    xmlBody.append("<MaxAgeSeconds>" + rule.getMaxAgeSeconds() + "</MaxAgeSeconds>");
                }
                xmlBody.append("</CORSRule>");
            }
            xmlBody.append("</CORSConfiguration>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class SetBucketLifecycleRequestMarshaller
    implements RequestMarshaller<SetBucketLifecycleRequest> {
        @Override
        public FixedLengthInputStream marshall(SetBucketLifecycleRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<LifecycleConfiguration>");
            for (LifecycleRule rule : request.getLifecycleRules()) {
                String formatDate;
                xmlBody.append("<Rule>");
                if (rule.getId() != null) {
                    xmlBody.append("<ID>" + rule.getId() + "</ID>");
                }
                if (rule.getPrefix() != null) {
                    xmlBody.append("<Prefix>" + rule.getPrefix() + "</Prefix>");
                } else {
                    xmlBody.append("<Prefix></Prefix>");
                }
                if (rule.getStatus() == LifecycleRule.RuleStatus.Enabled) {
                    xmlBody.append("<Status>Enabled</Status>");
                } else {
                    xmlBody.append("<Status>Disabled</Status>");
                }
                if (rule.getExpirationTime() != null) {
                    formatDate = DateUtil.formatIso8601Date(rule.getExpirationTime());
                    xmlBody.append("<Expiration><Date>" + formatDate + "</Date></Expiration>");
                } else if (rule.getExpirationDays() != 0) {
                    xmlBody.append("<Expiration><Days>" + rule.getExpirationDays() + "</Days></Expiration>");
                } else {
                    formatDate = DateUtil.formatIso8601Date(rule.getCreatedBeforeDate());
                    xmlBody.append("<Expiration><CreatedBeforeDate>" + formatDate + "</CreatedBeforeDate></Expiration>");
                }
                if (rule.getAbortMultipartUpload() != null) {
                    LifecycleRule.AbortMultipartUpload abortMultipartUpload = rule.getAbortMultipartUpload();
                    if (abortMultipartUpload.getExpirationDays() != 0) {
                        xmlBody.append("<AbortMultipartUpload><Days>" + rule.getExpirationDays() + "</Days></AbortMultipartUpload>");
                    } else {
                        String formatDate2 = DateUtil.formatIso8601Date(abortMultipartUpload.getCreatedBeforeDate());
                        xmlBody.append("<AbortMultipartUpload><CreatedBeforeDate>" + formatDate2 + "</CreatedBeforeDate></AbortMultipartUpload>");
                    }
                }
                xmlBody.append("</Rule>");
            }
            xmlBody.append("</LifecycleConfiguration>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class SetBucketWebsiteRequestMarshaller
    implements RequestMarshaller<SetBucketWebsiteRequest> {
        @Override
        public FixedLengthInputStream marshall(SetBucketWebsiteRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<WebsiteConfiguration>");
            if (request.getIndexDocument() != null) {
                xmlBody.append("<IndexDocument>");
                xmlBody.append("<Suffix>" + request.getIndexDocument() + "</Suffix>");
                xmlBody.append("</IndexDocument>");
            }
            if (request.getErrorDocument() != null) {
                xmlBody.append("<ErrorDocument>");
                xmlBody.append("<Key>" + request.getErrorDocument() + "</Key>");
                xmlBody.append("</ErrorDocument>");
            }
            if (request.getRoutingRules().size() > 0) {
                xmlBody.append("<RoutingRules>");
                for (RoutingRule routingRule : request.getRoutingRules()) {
                    xmlBody.append("<RoutingRule>");
                    xmlBody.append("<RuleNumber>" + routingRule.getNumber() + "</RuleNumber>");
                    RoutingRule.Condition condition = routingRule.getCondition();
                    if (condition.getKeyPrefixEquals() != null || condition.getHttpErrorCodeReturnedEquals() > 0) {
                        xmlBody.append("<Condition>");
                        if (condition.getKeyPrefixEquals() != null) {
                            xmlBody.append("<KeyPrefixEquals>" + RequestMarshallers.escapeKey(condition.getKeyPrefixEquals()) + "</KeyPrefixEquals>");
                        }
                        if (condition.getHttpErrorCodeReturnedEquals() > 0) {
                            xmlBody.append("<HttpErrorCodeReturnedEquals>" + condition.getHttpErrorCodeReturnedEquals() + "</HttpErrorCodeReturnedEquals>");
                        }
                        xmlBody.append("</Condition>");
                    }
                    RoutingRule.Redirect redirect = routingRule.getRedirect();
                    xmlBody.append("<Redirect>");
                    if (redirect.getRedirectType() != null) {
                        xmlBody.append("<RedirectType>" + redirect.getRedirectType().toString() + "</RedirectType>");
                    }
                    if (redirect.getHostName() != null) {
                        xmlBody.append("<HostName>" + redirect.getHostName() + "</HostName>");
                    }
                    if (redirect.getProtocol() != null) {
                        xmlBody.append("<Protocol>" + redirect.getProtocol().toString() + "</Protocol>");
                    }
                    if (redirect.getReplaceKeyPrefixWith() != null) {
                        xmlBody.append("<ReplaceKeyPrefixWith>" + RequestMarshallers.escapeKey(redirect.getReplaceKeyPrefixWith()) + "</ReplaceKeyPrefixWith>");
                    }
                    if (redirect.getReplaceKeyWith() != null) {
                        xmlBody.append("<ReplaceKeyWith>" + RequestMarshallers.escapeKey(redirect.getReplaceKeyWith()) + "</ReplaceKeyWith>");
                    }
                    if (redirect.getHttpRedirectCode() > 0) {
                        xmlBody.append("<HttpRedirectCode>" + redirect.getHttpRedirectCode() + "</HttpRedirectCode>");
                    }
                    if (redirect.getMirrorURL() != null) {
                        xmlBody.append("<MirrorURL>" + redirect.getMirrorURL() + "</MirrorURL>");
                    }
                    xmlBody.append("</Redirect>");
                    xmlBody.append("</RoutingRule>");
                }
                xmlBody.append("</RoutingRules>");
            }
            xmlBody.append("</WebsiteConfiguration>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class SetBucketLoggingRequestMarshaller
    implements RequestMarshaller<SetBucketLoggingRequest> {
        @Override
        public FixedLengthInputStream marshall(SetBucketLoggingRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<BucketLoggingStatus>");
            if (request.getTargetBucket() != null) {
                xmlBody.append("<LoggingEnabled>");
                xmlBody.append("<TargetBucket>" + request.getTargetBucket() + "</TargetBucket>");
                if (request.getTargetPrefix() != null) {
                    xmlBody.append("<TargetPrefix>" + request.getTargetPrefix() + "</TargetPrefix>");
                }
                xmlBody.append("</LoggingEnabled>");
            }
            xmlBody.append("</BucketLoggingStatus>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class BucketRefererMarshaller
    implements RequestMarshaller<BucketReferer> {
        @Override
        public FixedLengthInputStream marshall(BucketReferer br) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<RefererConfiguration>");
            xmlBody.append("<AllowEmptyReferer>" + br.isAllowEmptyReferer() + "</AllowEmptyReferer>");
            if (!br.getRefererList().isEmpty()) {
                xmlBody.append("<RefererList>");
                for (String referer : br.getRefererList()) {
                    xmlBody.append("<Referer>" + referer + "</Referer>");
                }
                xmlBody.append("</RefererList>");
            } else {
                xmlBody.append("<RefererList/>");
            }
            xmlBody.append("</RefererConfiguration>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class CreateBucketRequestMarshaller
    implements RequestMarshaller<CreateBucketRequest> {
        @Override
        public FixedLengthInputStream marshall(CreateBucketRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            if (request.getLocationConstraint() != null || request.getStorageClass() != null) {
                xmlBody.append("<CreateBucketConfiguration>");
                if (request.getLocationConstraint() != null) {
                    xmlBody.append("<LocationConstraint>" + request.getLocationConstraint() + "</LocationConstraint>");
                }
                if (request.getStorageClass() != null) {
                    xmlBody.append("<StorageClass>" + request.getStorageClass().toString() + "</StorageClass>");
                }
                xmlBody.append("</CreateBucketConfiguration>");
            }
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class PutBucketImageRequestMarshaller
    implements RequestMarshaller<PutBucketImageRequest> {
        @Override
        public FixedLengthInputStream marshall(PutBucketImageRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<Channel>");
            if (request.GetIsForbidOrigPicAccess()) {
                xmlBody.append("<OrigPicForbidden>true</OrigPicForbidden>");
            } else {
                xmlBody.append("<OrigPicForbidden>false</OrigPicForbidden>");
            }
            if (request.GetIsUseStyleOnly()) {
                xmlBody.append("<UseStyleOnly>true</UseStyleOnly>");
            } else {
                xmlBody.append("<UseStyleOnly>false</UseStyleOnly>");
            }
            if (request.GetIsAutoSetContentType()) {
                xmlBody.append("<AutoSetContentType>true</AutoSetContentType>");
            } else {
                xmlBody.append("<AutoSetContentType>false</AutoSetContentType>");
            }
            if (request.GetIsUseSrcFormat()) {
                xmlBody.append("<UseSrcFormat>true</UseSrcFormat>");
            } else {
                xmlBody.append("<UseSrcFormat>false</UseSrcFormat>");
            }
            if (request.GetIsSetAttachName()) {
                xmlBody.append("<SetAttachName>true</SetAttachName>");
            } else {
                xmlBody.append("<SetAttachName>false</SetAttachName>");
            }
            xmlBody.append("<Default404Pic>" + request.GetDefault404Pic() + "</Default404Pic>");
            xmlBody.append("<StyleDelimiters>" + request.GetStyleDelimiters() + "</StyleDelimiters>");
            xmlBody.append("</Channel>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class PutImageStyleRequestMarshaller
    implements RequestMarshaller<PutImageStyleRequest> {
        @Override
        public FixedLengthInputStream marshall(PutImageStyleRequest request) {
            StringBuffer xmlBody = new StringBuffer();
            xmlBody.append("<Style>");
            xmlBody.append("<Content>" + request.GetStyle() + "</Content>");
            xmlBody.append("</Style>");
            return stringMarshaller.marshall(xmlBody.toString());
        }
    }

    public static final class StringMarshaller
    implements Marshaller<FixedLengthInputStream, String> {
        @Override
        public FixedLengthInputStream marshall(String input) {
            if (input == null) {
                throw new IllegalArgumentException("The input should not be null.");
            }
            byte[] binaryData = null;
            try {
                binaryData = input.getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unsupported encoding " + e.getMessage(), e);
            }
            long length = binaryData.length;
            ByteArrayInputStream instream = new ByteArrayInputStream(binaryData);
            return new FixedLengthInputStream(instream, length);
        }
    }

    public static interface RequestMarshaller2<R>
    extends Marshaller<byte[], R> {
    }

    public static interface RequestMarshaller<R>
    extends Marshaller<FixedLengthInputStream, R> {
    }
}

