/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.AddBucketCnameRequest;
import com.aliyun.oss.model.AddBucketReplicationRequest;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketInfo;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketMetadata;
import com.aliyun.oss.model.BucketProcess;
import com.aliyun.oss.model.BucketQosInfo;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketReplicationProgress;
import com.aliyun.oss.model.BucketStat;
import com.aliyun.oss.model.BucketVersioningConfiguration;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CnameConfiguration;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.DeleteBucketCnameRequest;
import com.aliyun.oss.model.DeleteBucketReplicationRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetBucketImageResult;
import com.aliyun.oss.model.GetBucketPolicyResult;
import com.aliyun.oss.model.GetBucketReplicationProgressRequest;
import com.aliyun.oss.model.GetBucketRequestPaymentResult;
import com.aliyun.oss.model.GetImageStyleResult;
import com.aliyun.oss.model.ImageProcess;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ListVersionsRequest;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.PutBucketImageRequest;
import com.aliyun.oss.model.PutImageStyleRequest;
import com.aliyun.oss.model.ReplicationRule;
import com.aliyun.oss.model.ServerSideEncryptionConfiguration;
import com.aliyun.oss.model.SetBucketAclRequest;
import com.aliyun.oss.model.SetBucketEncryptionRequest;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketPolicyRequest;
import com.aliyun.oss.model.SetBucketProcessRequest;
import com.aliyun.oss.model.SetBucketQosInfoRequest;
import com.aliyun.oss.model.SetBucketRefererRequest;
import com.aliyun.oss.model.SetBucketRequestPaymentRequest;
import com.aliyun.oss.model.SetBucketStorageCapacityRequest;
import com.aliyun.oss.model.SetBucketTaggingRequest;
import com.aliyun.oss.model.SetBucketVersioningRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import com.aliyun.oss.model.Style;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.UserQos;
import com.aliyun.oss.model.UserQosInfo;
import com.aliyun.oss.model.VersionListing;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OSSBucketOperation
extends OSSOperation {
    public OSSBucketOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createBucketRequest, "createBucketRequest");
        String bucketName = createBucketRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, createBucketRequest.getCannedACL());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setInputStreamWithLength(RequestMarshallers.createBucketRequestMarshaller.marshall(createBucketRequest)).setOriginalRequest(createBucketRequest).build();
        ResponseMessage result = this.doOperation(request, emptyResponseParser, bucketName, null);
        return new Bucket(bucketName, result.getRequestId());
    }

    public void deleteBucket(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<Bucket> listBuckets() throws OSSException, ClientException {
        BucketList bucketList = this.listBuckets(new ListBucketsRequest(null, null, null));
        List<Bucket> buckets = bucketList.getBucketList();
        while (bucketList.isTruncated()) {
            bucketList = this.listBuckets(new ListBucketsRequest(null, bucketList.getNextMarker(), null));
            buckets.addAll(bucketList.getBucketList());
        }
        return buckets;
    }

    public BucketList listBuckets(ListBucketsRequest listBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listBucketRequest, "listBucketRequest");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (listBucketRequest.getPrefix() != null) {
            params.put("prefix", listBucketRequest.getPrefix());
        }
        if (listBucketRequest.getMarker() != null) {
            params.put("marker", listBucketRequest.getMarker());
        }
        if (listBucketRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listBucketRequest.getMaxKeys()));
        }
        if (listBucketRequest.getBid() != null) {
            params.put("bid", listBucketRequest.getBid());
        }
        if (listBucketRequest.getTagKey() != null && listBucketRequest.getTagValue() != null) {
            params.put("tag-key", listBucketRequest.getTagKey());
            params.put("tag-value", listBucketRequest.getTagValue());
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(listBucketRequest).build();
        return this.doOperation(request, ResponseParsers.listBucketResponseParser, null, null, true);
    }

    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketAclRequest, "setBucketAclRequest");
        String bucketName = setBucketAclRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, setBucketAclRequest.getCannedACL());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(setBucketAclRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public AccessControlList getBucketAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketAclResponseParser, bucketName, null, true);
    }

    public BucketMetadata getBucketMetadata(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.HEAD).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new ResponseHandler(){

            @Override
            public void handle(ResponseMessage response) throws ServiceException, ClientException {
                if (response.getStatusCode() == 404) {
                    OSSUtils.safeCloseResponse(response);
                    throw ExceptionFactory.createOSSException(response.getHeaders().get("x-oss-request-id"), "NoSuchBucket", OSSUtils.OSS_RESOURCE_MANAGER.getString("NoSuchBucket"));
                }
            }
        });
        return this.doOperation(request, ResponseParsers.getBucketMetadataResponseParser, bucketName, null, true, null, reponseHandlers);
    }

    public void setBucketReferer(SetBucketRefererRequest setBucketRefererRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketRefererRequest, "setBucketRefererRequest");
        String bucketName = setBucketRefererRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        BucketReferer referer = setBucketRefererRequest.getReferer();
        if (referer == null) {
            referer = new BucketReferer();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.bucketRefererMarshaller.marshall(referer)).setOriginalRequest(setBucketRefererRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketReferer getBucketReferer(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketRefererResponseParser, bucketName, null, true);
    }

    public String getBucketLocation(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("location", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLocationResponseParser, bucketName, null, true);
    }

    public boolean doesBucketExists(GenericRequest genericRequest) throws OSSException, ClientException {
        block2: {
            CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
            String bucketName = genericRequest.getBucketName();
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            try {
                this.getBucketAcl(new GenericRequest(bucketName));
            }
            catch (OSSException oe) {
                if (!oe.getErrorCode().equals("NoSuchBucket")) break block2;
                return false;
            }
        }
        return true;
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listObjectsRequest, "listObjectsRequest");
        String bucketName = listObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListObjectsRequestParameters(listObjectsRequest, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.populateRequestPayerHeader(headers, listObjectsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(listObjectsRequest).build();
        return this.doOperation(request, ResponseParsers.listObjectsReponseParser, bucketName, null, true);
    }

    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listVersionsRequest, "listVersionsRequest");
        String bucketName = listVersionsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListVersionsRequestParameters(listVersionsRequest, params);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.populateRequestPayerHeader(headers, listVersionsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setHeaders(headers).setParameters(params).setOriginalRequest(listVersionsRequest).build();
        return this.doOperation(request, ResponseParsers.listVersionsReponseParser, bucketName, null, true);
    }

    public void setBucketLogging(SetBucketLoggingRequest setBucketLoggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLoggingRequest, "setBucketLoggingRequest");
        String bucketName = setBucketLoggingRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLoggingRequestMarshaller.marshall(setBucketLoggingRequest)).setOriginalRequest(setBucketLoggingRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void putBucketImage(PutBucketImageRequest putBucketImageRequest) {
        CodingUtils.assertParameterNotNull(putBucketImageRequest, "putBucketImageRequest");
        String bucketName = putBucketImageRequest.GetBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("img", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setOriginalRequest(putBucketImageRequest).setInputStreamWithLength(RequestMarshallers.putBucketImageRequestMarshaller.marshall(putBucketImageRequest)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public GetBucketImageResult getBucketImage(String bucketName, GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("img", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketImageResponseParser, bucketName, null, true);
    }

    public void deleteBucketImage(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("img", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void putImageStyle(PutImageStyleRequest putImageStyleRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(putImageStyleRequest, "putImageStyleRequest");
        String bucketName = putImageStyleRequest.GetBucketName();
        String styleName = putImageStyleRequest.GetStyleName();
        CodingUtils.assertParameterNotNull(styleName, "styleName");
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        params.put("styleName", styleName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setOriginalRequest(putImageStyleRequest).setInputStreamWithLength(RequestMarshallers.putImageStyleRequestMarshaller.marshall(putImageStyleRequest)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void deleteImageStyle(String bucketName, String styleName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(styleName, "styleName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        params.put("styleName", styleName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public GetImageStyleResult getImageStyle(String bucketName, String styleName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(styleName, "styleName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        params.put("styleName", styleName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getImageStyleResponseParser, bucketName, null, true);
    }

    public List<Style> listImageStyle(String bucketName, GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("style", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.listImageStyleResponseParser, bucketName, null, true);
    }

    public void setBucketProcess(SetBucketProcessRequest setBucketProcessRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketProcessRequest, "setBucketProcessRequest");
        ImageProcess imageProcessConf = setBucketProcessRequest.getImageProcess();
        CodingUtils.assertParameterNotNull(imageProcessConf, "imageProcessConf");
        String bucketName = setBucketProcessRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processConfiguration", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.bucketImageProcessConfMarshaller.marshall(imageProcessConf)).setOriginalRequest(setBucketProcessRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketProcess getBucketProcess(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processConfiguration", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketImageProcessConfResponseParser, bucketName, null, true);
    }

    public BucketLoggingResult getBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLoggingResponseParser, bucketName, null, true);
    }

    public void deleteBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketWebSiteRequest, "setBucketWebSiteRequest");
        String bucketName = setBucketWebSiteRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (setBucketWebSiteRequest.getIndexDocument() == null && setBucketWebSiteRequest.getErrorDocument() == null && setBucketWebSiteRequest.getRoutingRules().size() == 0) {
            throw new IllegalArgumentException(String.format("IndexDocument/ErrorDocument/RoutingRules must have one", new Object[0]));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketWebsiteRequestMarshaller.marshall(setBucketWebSiteRequest)).setOriginalRequest(setBucketWebSiteRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketWebsiteResult getBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketWebsiteResponseParser, bucketName, null, true);
    }

    public void deleteBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketLifecycle(SetBucketLifecycleRequest setBucketLifecycleRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLifecycleRequest, "setBucketLifecycleRequest");
        String bucketName = setBucketLifecycleRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLifecycleRequestMarshaller.marshall(setBucketLifecycleRequest)).setOriginalRequest(setBucketLifecycleRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<LifecycleRule> getBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLifecycleResponseParser, bucketName, null, true);
    }

    public void deleteBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketTagging(SetBucketTaggingRequest setBucketTaggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketTaggingRequest, "setBucketTaggingRequest");
        String bucketName = setBucketTaggingRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketTaggingRequestMarshaller.marshall(setBucketTaggingRequest)).setOriginalRequest(setBucketTaggingRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public TagSet getBucketTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getTaggingResponseParser, bucketName, null, true);
    }

    public void deleteBucketTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketVersioningConfiguration getBucketVersioning(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("versioning", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketVersioningResponseParser, bucketName, null, true);
    }

    public void setBucketVersioning(SetBucketVersioningRequest setBucketVersioningRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketVersioningRequest, "setBucketVersioningRequest");
        CodingUtils.assertParameterNotNull(setBucketVersioningRequest.getVersioningConfiguration(), "versioningConfiguration");
        String bucketName = setBucketVersioningRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("versioning", null);
        byte[] rawContent = RequestMarshallers.setBucketVersioningRequestMarshaller.marshall(setBucketVersioningRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketVersioningRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void addBucketReplication(AddBucketReplicationRequest addBucketReplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(addBucketReplicationRequest, "addBucketReplicationRequest");
        CodingUtils.assertParameterNotNull(addBucketReplicationRequest.getTargetBucketName(), "targetBucketName");
        CodingUtils.assertParameterNotNull(addBucketReplicationRequest.getTargetBucketLocation(), "targetBucketLocation");
        String bucketName = addBucketReplicationRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("replication", null);
        params.put("comp", "add");
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.addBucketReplicationRequestMarshaller.marshall(addBucketReplicationRequest)).setOriginalRequest(addBucketReplicationRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<ReplicationRule> getBucketReplication(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("replication", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketReplicationResponseParser, bucketName, null, true);
    }

    public void deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteBucketReplicationRequest, "deleteBucketReplicationRequest");
        CodingUtils.assertParameterNotNull(deleteBucketReplicationRequest.getReplicationRuleID(), "replicationRuleID");
        String bucketName = deleteBucketReplicationRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("replication", null);
        params.put("comp", "delete");
        byte[] rawContent = RequestMarshallers.deleteBucketReplicationRequestMarshaller.marshall(deleteBucketReplicationRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteBucketReplicationRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    private static void addRequestRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        headers.put("Content-Length", String.valueOf(rawContent.length));
        byte[] md5 = BinaryUtil.calculateMd5(rawContent);
        String md5Base64 = BinaryUtil.toBase64String(md5);
        headers.put("Content-MD5", md5Base64);
    }

    public BucketReplicationProgress getBucketReplicationProgress(GetBucketReplicationProgressRequest getBucketReplicationProgressRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getBucketReplicationProgressRequest, "getBucketReplicationProgressRequest");
        CodingUtils.assertParameterNotNull(getBucketReplicationProgressRequest.getReplicationRuleID(), "replicationRuleID");
        String bucketName = getBucketReplicationProgressRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("replicationProgress", null);
        params.put("rule-id", getBucketReplicationProgressRequest.getReplicationRuleID());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(getBucketReplicationProgressRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketReplicationProgressResponseParser, bucketName, null, true);
    }

    public List<String> getBucketReplicationLocation(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("replicationLocation", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketReplicationLocationResponseParser, bucketName, null, true);
    }

    public void addBucketCname(AddBucketCnameRequest addBucketCnameRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(addBucketCnameRequest, "addBucketCnameRequest");
        CodingUtils.assertParameterNotNull(addBucketCnameRequest.getDomain(), "addBucketCnameRequest.domain");
        String bucketName = addBucketCnameRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        params.put("comp", "add");
        byte[] rawContent = RequestMarshallers.addBucketCnameRequestMarshaller.marshall(addBucketCnameRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(addBucketCnameRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<CnameConfiguration> getBucketCname(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketCnameResponseParser, bucketName, null, true);
    }

    public void deleteBucketCname(DeleteBucketCnameRequest deleteBucketCnameRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteBucketCnameRequest, "deleteBucketCnameRequest");
        CodingUtils.assertParameterNotNull(deleteBucketCnameRequest.getDomain(), "deleteBucketCnameRequest.domain");
        String bucketName = deleteBucketCnameRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", null);
        params.put("comp", "delete");
        byte[] rawContent = RequestMarshallers.deleteBucketCnameRequestMarshaller.marshall(deleteBucketCnameRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteBucketCnameRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketInfo getBucketInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bucketInfo", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketInfoResponseParser, bucketName, null, true);
    }

    public BucketStat getBucketStat(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("stat", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketStatResponseParser, bucketName, null, true);
    }

    public void setBucketStorageCapacity(SetBucketStorageCapacityRequest setBucketStorageCapacityRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketStorageCapacityRequest, "setBucketStorageCapacityRequest");
        CodingUtils.assertParameterNotNull(setBucketStorageCapacityRequest.getUserQos(), "setBucketStorageCapacityRequest.userQos");
        String bucketName = setBucketStorageCapacityRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        UserQos userQos = setBucketStorageCapacityRequest.getUserQos();
        CodingUtils.assertParameterNotNull(userQos.getStorageCapacity(), "StorageCapacity");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qos", null);
        byte[] rawContent = RequestMarshallers.setBucketQosRequestMarshaller.marshall(userQos);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketStorageCapacityRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public UserQos getBucketStorageCapacity(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qos", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketQosResponseParser, bucketName, null, true);
    }

    public void setBucketEncryption(SetBucketEncryptionRequest setBucketEncryptionRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketEncryptionRequest, "setBucketEncryptionRequest");
        String bucketName = setBucketEncryptionRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("encryption", null);
        byte[] rawContent = RequestMarshallers.setBucketEncryptionRequestMarshaller.marshall(setBucketEncryptionRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketEncryptionRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public ServerSideEncryptionConfiguration getBucketEncryption(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("encryption", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketEncryptionResponseParser, bucketName, null, true);
    }

    public void deleteBucketEncryption(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("encryption", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketPolicyRequest, "setBucketPolicyRequest");
        String bucketName = setBucketPolicyRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        byte[] rawContent = RequestMarshallers.setBucketPolicyRequestMarshaller.marshall(setBucketPolicyRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketPolicyRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public GetBucketPolicyResult getBucketPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketPolicyResponseParser, bucketName, null, true);
    }

    public void deleteBucketPolicy(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("policy", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketRequestPayment(SetBucketRequestPaymentRequest setBucketRequestPaymentRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketRequestPaymentRequest, "setBucketRequestPaymentRequest");
        CodingUtils.assertParameterNotNull((Object)setBucketRequestPaymentRequest.getPayer(), "setBucketRequestPaymentRequest.payer");
        String bucketName = setBucketRequestPaymentRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requestPayment", null);
        Payer payer = setBucketRequestPaymentRequest.getPayer();
        byte[] rawContent = RequestMarshallers.setBucketRequestPaymentRequestMarshaller.marshall(payer.toString());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketRequestPaymentRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public GetBucketRequestPaymentResult getBucketRequestPayment(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("requestPayment", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketRequestPaymentResponseParser, bucketName, null, true);
    }

    public void setBucketQosInfo(SetBucketQosInfoRequest setBucketQosInfoRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketQosInfoRequest, "setBucketQosInfoRequest");
        CodingUtils.assertParameterNotNull(setBucketQosInfoRequest.getBucketQosInfo(), "setBucketQosInfoRequest.getBucketQosInfo");
        String bucketName = setBucketQosInfoRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        byte[] rawContent = RequestMarshallers.setBucketQosInfoRequestMarshaller.marshall(setBucketQosInfoRequest.getBucketQosInfo());
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addRequestRequiredHeaders(headers, rawContent);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(setBucketQosInfoRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketQosInfo getBucketQosInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketQosInfoResponseParser, bucketName, null, true);
    }

    public void deleteBucketQosInfo(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public UserQosInfo getUserQosInfo() throws OSSException, ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("qosInfo", null);
        GenericRequest gGenericRequest = new GenericRequest();
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(gGenericRequest).build();
        return this.doOperation(request, ResponseParsers.getUSerQosInfoResponseParser, null, null, true);
    }

    private static void populateListObjectsRequestParameters(ListObjectsRequest listObjectsRequest, Map<String, String> params) {
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
    }

    private static void populateListVersionsRequestParameters(ListVersionsRequest listVersionsRequest, Map<String, String> params) {
        params.put("versions", null);
        if (listVersionsRequest.getPrefix() != null) {
            params.put("prefix", listVersionsRequest.getPrefix());
        }
        if (listVersionsRequest.getKeyMarker() != null) {
            params.put("key-marker", listVersionsRequest.getKeyMarker());
        }
        if (listVersionsRequest.getDelimiter() != null) {
            params.put("delimiter", listVersionsRequest.getDelimiter());
        }
        if (listVersionsRequest.getMaxResults() != null) {
            params.put("max-keys", Integer.toString(listVersionsRequest.getMaxResults()));
        }
        if (listVersionsRequest.getVersionIdMarker() != null) {
            params.put("version-id-marker", listVersionsRequest.getVersionIdMarker());
        }
        if (listVersionsRequest.getEncodingType() != null) {
            params.put("encoding-type", listVersionsRequest.getEncodingType());
        }
    }

    private static void addOptionalACLHeader(Map<String, String> headers, CannedAccessControlList cannedAcl) {
        if (cannedAcl != null) {
            headers.put("x-oss-acl", cannedAcl.toString());
        }
    }

    private static void populateRequestPayerHeader(Map<String, String> headers, Payer payer) {
        if (payer != null && payer.equals((Object)Payer.Requester)) {
            headers.put("x-oss-request-payer", payer.toString().toLowerCase());
        }
    }
}

