/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateDomainNameRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateDomainNameRequestMarshaller
implements Marshaller<Request<CreateDomainNameRequest>, CreateDomainNameRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateDomainNameRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateDomainNameRequest> marshall(CreateDomainNameRequest createDomainNameRequest) {
        if (createDomainNameRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDomainNameRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/domainnames";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDomainNameRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("domainName").writeValue(createDomainNameRequest.getDomainName());
            }
            if (createDomainNameRequest.getCertificateName() != null) {
                jsonGenerator.writeFieldName("certificateName").writeValue(createDomainNameRequest.getCertificateName());
            }
            if (createDomainNameRequest.getCertificateBody() != null) {
                jsonGenerator.writeFieldName("certificateBody").writeValue(createDomainNameRequest.getCertificateBody());
            }
            if (createDomainNameRequest.getCertificatePrivateKey() != null) {
                jsonGenerator.writeFieldName("certificatePrivateKey").writeValue(createDomainNameRequest.getCertificatePrivateKey());
            }
            if (createDomainNameRequest.getCertificateChain() != null) {
                jsonGenerator.writeFieldName("certificateChain").writeValue(createDomainNameRequest.getCertificateChain());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

