/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apprunner.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apprunner.model.CodeConfigurationValues;
import java.util.Map;

@SdkInternalApi
public class CodeConfigurationValuesMarshaller {
    private static final MarshallingInfo<String> RUNTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Runtime").build();
    private static final MarshallingInfo<String> BUILDCOMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BuildCommand").build();
    private static final MarshallingInfo<String> STARTCOMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartCommand").build();
    private static final MarshallingInfo<String> PORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Port").build();
    private static final MarshallingInfo<Map> RUNTIMEENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RuntimeEnvironmentVariables").build();
    private static final CodeConfigurationValuesMarshaller instance = new CodeConfigurationValuesMarshaller();

    public static CodeConfigurationValuesMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeConfigurationValues codeConfigurationValues, ProtocolMarshaller protocolMarshaller) {
        if (codeConfigurationValues == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeConfigurationValues.getRuntime(), RUNTIME_BINDING);
            protocolMarshaller.marshall((Object)codeConfigurationValues.getBuildCommand(), BUILDCOMMAND_BINDING);
            protocolMarshaller.marshall((Object)codeConfigurationValues.getStartCommand(), STARTCOMMAND_BINDING);
            protocolMarshaller.marshall((Object)codeConfigurationValues.getPort(), PORT_BINDING);
            protocolMarshaller.marshall(codeConfigurationValues.getRuntimeEnvironmentVariables(), RUNTIMEENVIRONMENTVARIABLES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

