/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.ResultSetMetadata;
import com.amazonaws.services.athena.model.Row;
import com.amazonaws.services.athena.model.transform.ResultSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResultSet
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Row> rows;
    private ResultSetMetadata resultSetMetadata;

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(Collection<Row> rows) {
        if (rows == null) {
            this.rows = null;
            return;
        }
        this.rows = new ArrayList<Row>(rows);
    }

    public ResultSet withRows(Row ... rows) {
        if (this.rows == null) {
            this.setRows(new ArrayList<Row>(rows.length));
        }
        for (Row ele : rows) {
            this.rows.add(ele);
        }
        return this;
    }

    public ResultSet withRows(Collection<Row> rows) {
        this.setRows(rows);
        return this;
    }

    public void setResultSetMetadata(ResultSetMetadata resultSetMetadata) {
        this.resultSetMetadata = resultSetMetadata;
    }

    public ResultSetMetadata getResultSetMetadata() {
        return this.resultSetMetadata;
    }

    public ResultSet withResultSetMetadata(ResultSetMetadata resultSetMetadata) {
        this.setResultSetMetadata(resultSetMetadata);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRows() != null) {
            sb.append("Rows: ").append(this.getRows()).append(",");
        }
        if (this.getResultSetMetadata() != null) {
            sb.append("ResultSetMetadata: ").append(this.getResultSetMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSet)) {
            return false;
        }
        ResultSet other = (ResultSet)obj;
        if (other.getRows() == null ^ this.getRows() == null) {
            return false;
        }
        if (other.getRows() != null && !other.getRows().equals(this.getRows())) {
            return false;
        }
        if (other.getResultSetMetadata() == null ^ this.getResultSetMetadata() == null) {
            return false;
        }
        return other.getResultSetMetadata() == null || other.getResultSetMetadata().equals(this.getResultSetMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRows() == null ? 0 : this.getRows().hashCode());
        hashCode = 31 * hashCode + (this.getResultSetMetadata() == null ? 0 : this.getResultSetMetadata().hashCode());
        return hashCode;
    }

    public ResultSet clone() {
        try {
            return (ResultSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

