/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.AllowedMethods;
import com.amazonaws.services.cloudfront.model.transform.CachedMethodsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class AllowedMethodsStaxUnmarshaller
implements Unmarshaller<AllowedMethods, StaxUnmarshallerContext> {
    private static AllowedMethodsStaxUnmarshaller instance;

    public AllowedMethods unmarshall(StaxUnmarshallerContext context) throws Exception {
        AllowedMethods allowedMethods = new AllowedMethods();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return allowedMethods;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    allowedMethods.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    allowedMethods.withItems(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Items/Method", targetDepth)) {
                    allowedMethods.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CachedMethods", targetDepth)) continue;
                allowedMethods.setCachedMethods(CachedMethodsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return allowedMethods;
    }

    public static AllowedMethodsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AllowedMethodsStaxUnmarshaller();
        }
        return instance;
    }
}

