/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClientBuilder;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DeleteDashboardsRequest;
import com.amazonaws.services.cloudwatch.model.DeleteDashboardsResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricResult;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsResult;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsResult;
import com.amazonaws.services.cloudwatch.model.GetDashboardRequest;
import com.amazonaws.services.cloudwatch.model.GetDashboardResult;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListDashboardsRequest;
import com.amazonaws.services.cloudwatch.model.ListDashboardsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.ListMetricsResult;
import com.amazonaws.services.cloudwatch.model.PutDashboardRequest;
import com.amazonaws.services.cloudwatch.model.PutDashboardResult;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmResult;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest;
import com.amazonaws.services.cloudwatch.model.SetAlarmStateResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCloudWatchAsyncClient
extends AmazonCloudWatchClient
implements AmazonCloudWatchAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonCloudWatchAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonCloudWatchAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonCloudWatchAsyncClientBuilder asyncBuilder() {
        return AmazonCloudWatchAsyncClientBuilder.standard();
    }

    AmazonCloudWatchAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteAlarmsResult> deleteAlarmsAsync(DeleteAlarmsRequest request) {
        return this.deleteAlarmsAsync(request, null);
    }

    @Override
    public Future<DeleteAlarmsResult> deleteAlarmsAsync(DeleteAlarmsRequest request, final AsyncHandler<DeleteAlarmsRequest, DeleteAlarmsResult> asyncHandler) {
        final DeleteAlarmsRequest finalRequest = (DeleteAlarmsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAlarmsResult>(){

            @Override
            public DeleteAlarmsResult call() throws Exception {
                DeleteAlarmsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteAlarms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDashboardsResult> deleteDashboardsAsync(DeleteDashboardsRequest request) {
        return this.deleteDashboardsAsync(request, null);
    }

    @Override
    public Future<DeleteDashboardsResult> deleteDashboardsAsync(DeleteDashboardsRequest request, final AsyncHandler<DeleteDashboardsRequest, DeleteDashboardsResult> asyncHandler) {
        final DeleteDashboardsRequest finalRequest = (DeleteDashboardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDashboardsResult>(){

            @Override
            public DeleteDashboardsResult call() throws Exception {
                DeleteDashboardsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDeleteDashboards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(DescribeAlarmHistoryRequest request) {
        return this.describeAlarmHistoryAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(DescribeAlarmHistoryRequest request, final AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        final DescribeAlarmHistoryRequest finalRequest = (DescribeAlarmHistoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmHistoryResult>(){

            @Override
            public DescribeAlarmHistoryResult call() throws Exception {
                DescribeAlarmHistoryResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAlarmHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync() {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest());
    }

    @Override
    public Future<DescribeAlarmHistoryResult> describeAlarmHistoryAsync(AsyncHandler<DescribeAlarmHistoryRequest, DescribeAlarmHistoryResult> asyncHandler) {
        return this.describeAlarmHistoryAsync(new DescribeAlarmHistoryRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(DescribeAlarmsRequest request) {
        return this.describeAlarmsAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(DescribeAlarmsRequest request, final AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        final DescribeAlarmsRequest finalRequest = (DescribeAlarmsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmsResult>(){

            @Override
            public DescribeAlarmsResult call() throws Exception {
                DescribeAlarmsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAlarms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync() {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest());
    }

    @Override
    public Future<DescribeAlarmsResult> describeAlarmsAsync(AsyncHandler<DescribeAlarmsRequest, DescribeAlarmsResult> asyncHandler) {
        return this.describeAlarmsAsync(new DescribeAlarmsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(DescribeAlarmsForMetricRequest request) {
        return this.describeAlarmsForMetricAsync(request, null);
    }

    @Override
    public Future<DescribeAlarmsForMetricResult> describeAlarmsForMetricAsync(DescribeAlarmsForMetricRequest request, final AsyncHandler<DescribeAlarmsForMetricRequest, DescribeAlarmsForMetricResult> asyncHandler) {
        final DescribeAlarmsForMetricRequest finalRequest = (DescribeAlarmsForMetricRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAlarmsForMetricResult>(){

            @Override
            public DescribeAlarmsForMetricResult call() throws Exception {
                DescribeAlarmsForMetricResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDescribeAlarmsForMetric(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableAlarmActionsResult> disableAlarmActionsAsync(DisableAlarmActionsRequest request) {
        return this.disableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<DisableAlarmActionsResult> disableAlarmActionsAsync(DisableAlarmActionsRequest request, final AsyncHandler<DisableAlarmActionsRequest, DisableAlarmActionsResult> asyncHandler) {
        final DisableAlarmActionsRequest finalRequest = (DisableAlarmActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableAlarmActionsResult>(){

            @Override
            public DisableAlarmActionsResult call() throws Exception {
                DisableAlarmActionsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeDisableAlarmActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableAlarmActionsResult> enableAlarmActionsAsync(EnableAlarmActionsRequest request) {
        return this.enableAlarmActionsAsync(request, null);
    }

    @Override
    public Future<EnableAlarmActionsResult> enableAlarmActionsAsync(EnableAlarmActionsRequest request, final AsyncHandler<EnableAlarmActionsRequest, EnableAlarmActionsResult> asyncHandler) {
        final EnableAlarmActionsRequest finalRequest = (EnableAlarmActionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableAlarmActionsResult>(){

            @Override
            public EnableAlarmActionsResult call() throws Exception {
                EnableAlarmActionsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeEnableAlarmActions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDashboardResult> getDashboardAsync(GetDashboardRequest request) {
        return this.getDashboardAsync(request, null);
    }

    @Override
    public Future<GetDashboardResult> getDashboardAsync(GetDashboardRequest request, final AsyncHandler<GetDashboardRequest, GetDashboardResult> asyncHandler) {
        final GetDashboardRequest finalRequest = (GetDashboardRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDashboardResult>(){

            @Override
            public GetDashboardResult call() throws Exception {
                GetDashboardResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetDashboard(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(GetMetricStatisticsRequest request) {
        return this.getMetricStatisticsAsync(request, null);
    }

    @Override
    public Future<GetMetricStatisticsResult> getMetricStatisticsAsync(GetMetricStatisticsRequest request, final AsyncHandler<GetMetricStatisticsRequest, GetMetricStatisticsResult> asyncHandler) {
        final GetMetricStatisticsRequest finalRequest = (GetMetricStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMetricStatisticsResult>(){

            @Override
            public GetMetricStatisticsResult call() throws Exception {
                GetMetricStatisticsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeGetMetricStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDashboardsResult> listDashboardsAsync(ListDashboardsRequest request) {
        return this.listDashboardsAsync(request, null);
    }

    @Override
    public Future<ListDashboardsResult> listDashboardsAsync(ListDashboardsRequest request, final AsyncHandler<ListDashboardsRequest, ListDashboardsResult> asyncHandler) {
        final ListDashboardsRequest finalRequest = (ListDashboardsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDashboardsResult>(){

            @Override
            public ListDashboardsResult call() throws Exception {
                ListDashboardsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeListDashboards(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(ListMetricsRequest request) {
        return this.listMetricsAsync(request, null);
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(ListMetricsRequest request, final AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        final ListMetricsRequest finalRequest = (ListMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMetricsResult>(){

            @Override
            public ListMetricsResult call() throws Exception {
                ListMetricsResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeListMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync() {
        return this.listMetricsAsync(new ListMetricsRequest());
    }

    @Override
    public Future<ListMetricsResult> listMetricsAsync(AsyncHandler<ListMetricsRequest, ListMetricsResult> asyncHandler) {
        return this.listMetricsAsync(new ListMetricsRequest(), asyncHandler);
    }

    @Override
    public Future<PutDashboardResult> putDashboardAsync(PutDashboardRequest request) {
        return this.putDashboardAsync(request, null);
    }

    @Override
    public Future<PutDashboardResult> putDashboardAsync(PutDashboardRequest request, final AsyncHandler<PutDashboardRequest, PutDashboardResult> asyncHandler) {
        final PutDashboardRequest finalRequest = (PutDashboardRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDashboardResult>(){

            @Override
            public PutDashboardResult call() throws Exception {
                PutDashboardResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutDashboard(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricAlarmResult> putMetricAlarmAsync(PutMetricAlarmRequest request) {
        return this.putMetricAlarmAsync(request, null);
    }

    @Override
    public Future<PutMetricAlarmResult> putMetricAlarmAsync(PutMetricAlarmRequest request, final AsyncHandler<PutMetricAlarmRequest, PutMetricAlarmResult> asyncHandler) {
        final PutMetricAlarmRequest finalRequest = (PutMetricAlarmRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetricAlarmResult>(){

            @Override
            public PutMetricAlarmResult call() throws Exception {
                PutMetricAlarmResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutMetricAlarm(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutMetricDataResult> putMetricDataAsync(PutMetricDataRequest request) {
        return this.putMetricDataAsync(request, null);
    }

    @Override
    public Future<PutMetricDataResult> putMetricDataAsync(PutMetricDataRequest request, final AsyncHandler<PutMetricDataRequest, PutMetricDataResult> asyncHandler) {
        final PutMetricDataRequest finalRequest = (PutMetricDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutMetricDataResult>(){

            @Override
            public PutMetricDataResult call() throws Exception {
                PutMetricDataResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executePutMetricData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetAlarmStateResult> setAlarmStateAsync(SetAlarmStateRequest request) {
        return this.setAlarmStateAsync(request, null);
    }

    @Override
    public Future<SetAlarmStateResult> setAlarmStateAsync(SetAlarmStateRequest request, final AsyncHandler<SetAlarmStateRequest, SetAlarmStateResult> asyncHandler) {
        final SetAlarmStateRequest finalRequest = (SetAlarmStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SetAlarmStateResult>(){

            @Override
            public SetAlarmStateResult call() throws Exception {
                SetAlarmStateResult result = null;
                try {
                    result = AmazonCloudWatchAsyncClient.this.executeSetAlarmState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

