/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.computeoptimizer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.computeoptimizer.model.VolumeRecommendation;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class VolumeRecommendationMarshaller {
    private static final MarshallingInfo<String> VOLUMEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumeArn").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountId").build();
    private static final MarshallingInfo<StructuredPojo> CURRENTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentConfiguration").build();
    private static final MarshallingInfo<String> FINDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("finding").build();
    private static final MarshallingInfo<List> UTILIZATIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("utilizationMetrics").build();
    private static final MarshallingInfo<Double> LOOKBACKPERIODINDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lookBackPeriodInDays").build();
    private static final MarshallingInfo<List> VOLUMERECOMMENDATIONOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("volumeRecommendationOptions").build();
    private static final MarshallingInfo<Date> LASTREFRESHTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastRefreshTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CURRENTPERFORMANCERISK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentPerformanceRisk").build();
    private static final MarshallingInfo<StructuredPojo> EFFECTIVERECOMMENDATIONPREFERENCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("effectiveRecommendationPreferences").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final VolumeRecommendationMarshaller instance = new VolumeRecommendationMarshaller();

    public static VolumeRecommendationMarshaller getInstance() {
        return instance;
    }

    public void marshall(VolumeRecommendation volumeRecommendation, ProtocolMarshaller protocolMarshaller) {
        if (volumeRecommendation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)volumeRecommendation.getVolumeArn(), VOLUMEARN_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getCurrentConfiguration(), CURRENTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getFinding(), FINDING_BINDING);
            protocolMarshaller.marshall(volumeRecommendation.getUtilizationMetrics(), UTILIZATIONMETRICS_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getLookBackPeriodInDays(), LOOKBACKPERIODINDAYS_BINDING);
            protocolMarshaller.marshall(volumeRecommendation.getVolumeRecommendationOptions(), VOLUMERECOMMENDATIONOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getLastRefreshTimestamp(), LASTREFRESHTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getCurrentPerformanceRisk(), CURRENTPERFORMANCERISK_BINDING);
            protocolMarshaller.marshall((Object)volumeRecommendation.getEffectiveRecommendationPreferences(), EFFECTIVERECOMMENDATIONPREFERENCES_BINDING);
            protocolMarshaller.marshall(volumeRecommendation.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

