/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.CapacityProviderStrategyItem;
import com.amazonaws.services.ecs.model.DeploymentConfiguration;
import com.amazonaws.services.ecs.model.DeploymentController;
import com.amazonaws.services.ecs.model.LaunchType;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.NetworkConfiguration;
import com.amazonaws.services.ecs.model.PlacementConstraint;
import com.amazonaws.services.ecs.model.PlacementStrategy;
import com.amazonaws.services.ecs.model.PropagateTags;
import com.amazonaws.services.ecs.model.SchedulingStrategy;
import com.amazonaws.services.ecs.model.ServiceRegistry;
import com.amazonaws.services.ecs.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateServiceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String serviceName;
    private String taskDefinition;
    private SdkInternalList<LoadBalancer> loadBalancers;
    private SdkInternalList<ServiceRegistry> serviceRegistries;
    private Integer desiredCount;
    private String clientToken;
    private String launchType;
    private SdkInternalList<CapacityProviderStrategyItem> capacityProviderStrategy;
    private String platformVersion;
    private String role;
    private DeploymentConfiguration deploymentConfiguration;
    private SdkInternalList<PlacementConstraint> placementConstraints;
    private SdkInternalList<PlacementStrategy> placementStrategy;
    private NetworkConfiguration networkConfiguration;
    private Integer healthCheckGracePeriodSeconds;
    private String schedulingStrategy;
    private DeploymentController deploymentController;
    private SdkInternalList<Tag> tags;
    private Boolean enableECSManagedTags;
    private String propagateTags;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CreateServiceRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public CreateServiceRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public CreateServiceRequest withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new SdkInternalList();
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        this.loadBalancers = new SdkInternalList(loadBalancers);
    }

    public CreateServiceRequest withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.loadBalancers == null) {
            this.setLoadBalancers((Collection<LoadBalancer>)new SdkInternalList(loadBalancers.length));
        }
        for (LoadBalancer ele : loadBalancers) {
            this.loadBalancers.add((Object)ele);
        }
        return this;
    }

    public CreateServiceRequest withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        this.setLoadBalancers(loadBalancers);
        return this;
    }

    public List<ServiceRegistry> getServiceRegistries() {
        if (this.serviceRegistries == null) {
            this.serviceRegistries = new SdkInternalList();
        }
        return this.serviceRegistries;
    }

    public void setServiceRegistries(Collection<ServiceRegistry> serviceRegistries) {
        if (serviceRegistries == null) {
            this.serviceRegistries = null;
            return;
        }
        this.serviceRegistries = new SdkInternalList(serviceRegistries);
    }

    public CreateServiceRequest withServiceRegistries(ServiceRegistry ... serviceRegistries) {
        if (this.serviceRegistries == null) {
            this.setServiceRegistries((Collection<ServiceRegistry>)new SdkInternalList(serviceRegistries.length));
        }
        for (ServiceRegistry ele : serviceRegistries) {
            this.serviceRegistries.add((Object)ele);
        }
        return this;
    }

    public CreateServiceRequest withServiceRegistries(Collection<ServiceRegistry> serviceRegistries) {
        this.setServiceRegistries(serviceRegistries);
        return this;
    }

    public void setDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
    }

    public Integer getDesiredCount() {
        return this.desiredCount;
    }

    public CreateServiceRequest withDesiredCount(Integer desiredCount) {
        this.setDesiredCount(desiredCount);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateServiceRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    public CreateServiceRequest withLaunchType(String launchType) {
        this.setLaunchType(launchType);
        return this;
    }

    public CreateServiceRequest withLaunchType(LaunchType launchType) {
        this.launchType = launchType.toString();
        return this;
    }

    public List<CapacityProviderStrategyItem> getCapacityProviderStrategy() {
        if (this.capacityProviderStrategy == null) {
            this.capacityProviderStrategy = new SdkInternalList();
        }
        return this.capacityProviderStrategy;
    }

    public void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
        if (capacityProviderStrategy == null) {
            this.capacityProviderStrategy = null;
            return;
        }
        this.capacityProviderStrategy = new SdkInternalList(capacityProviderStrategy);
    }

    public CreateServiceRequest withCapacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
        if (this.capacityProviderStrategy == null) {
            this.setCapacityProviderStrategy((Collection<CapacityProviderStrategyItem>)new SdkInternalList(capacityProviderStrategy.length));
        }
        for (CapacityProviderStrategyItem ele : capacityProviderStrategy) {
            this.capacityProviderStrategy.add((Object)ele);
        }
        return this;
    }

    public CreateServiceRequest withCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
        this.setCapacityProviderStrategy(capacityProviderStrategy);
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public CreateServiceRequest withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public CreateServiceRequest withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public CreateServiceRequest withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.setDeploymentConfiguration(deploymentConfiguration);
        return this;
    }

    public List<PlacementConstraint> getPlacementConstraints() {
        if (this.placementConstraints == null) {
            this.placementConstraints = new SdkInternalList();
        }
        return this.placementConstraints;
    }

    public void setPlacementConstraints(Collection<PlacementConstraint> placementConstraints) {
        if (placementConstraints == null) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = new SdkInternalList(placementConstraints);
    }

    public CreateServiceRequest withPlacementConstraints(PlacementConstraint ... placementConstraints) {
        if (this.placementConstraints == null) {
            this.setPlacementConstraints((Collection<PlacementConstraint>)new SdkInternalList(placementConstraints.length));
        }
        for (PlacementConstraint ele : placementConstraints) {
            this.placementConstraints.add((Object)ele);
        }
        return this;
    }

    public CreateServiceRequest withPlacementConstraints(Collection<PlacementConstraint> placementConstraints) {
        this.setPlacementConstraints(placementConstraints);
        return this;
    }

    public List<PlacementStrategy> getPlacementStrategy() {
        if (this.placementStrategy == null) {
            this.placementStrategy = new SdkInternalList();
        }
        return this.placementStrategy;
    }

    public void setPlacementStrategy(Collection<PlacementStrategy> placementStrategy) {
        if (placementStrategy == null) {
            this.placementStrategy = null;
            return;
        }
        this.placementStrategy = new SdkInternalList(placementStrategy);
    }

    public CreateServiceRequest withPlacementStrategy(PlacementStrategy ... placementStrategy) {
        if (this.placementStrategy == null) {
            this.setPlacementStrategy((Collection<PlacementStrategy>)new SdkInternalList(placementStrategy.length));
        }
        for (PlacementStrategy ele : placementStrategy) {
            this.placementStrategy.add((Object)ele);
        }
        return this;
    }

    public CreateServiceRequest withPlacementStrategy(Collection<PlacementStrategy> placementStrategy) {
        this.setPlacementStrategy(placementStrategy);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public CreateServiceRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
        this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
    }

    public Integer getHealthCheckGracePeriodSeconds() {
        return this.healthCheckGracePeriodSeconds;
    }

    public CreateServiceRequest withHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
        this.setHealthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds);
        return this;
    }

    public void setSchedulingStrategy(String schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy;
    }

    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public CreateServiceRequest withSchedulingStrategy(String schedulingStrategy) {
        this.setSchedulingStrategy(schedulingStrategy);
        return this;
    }

    public CreateServiceRequest withSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.schedulingStrategy = schedulingStrategy.toString();
        return this;
    }

    public void setDeploymentController(DeploymentController deploymentController) {
        this.deploymentController = deploymentController;
    }

    public DeploymentController getDeploymentController() {
        return this.deploymentController;
    }

    public CreateServiceRequest withDeploymentController(DeploymentController deploymentController) {
        this.setDeploymentController(deploymentController);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateServiceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateServiceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setEnableECSManagedTags(Boolean enableECSManagedTags) {
        this.enableECSManagedTags = enableECSManagedTags;
    }

    public Boolean getEnableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public CreateServiceRequest withEnableECSManagedTags(Boolean enableECSManagedTags) {
        this.setEnableECSManagedTags(enableECSManagedTags);
        return this;
    }

    public Boolean isEnableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public void setPropagateTags(String propagateTags) {
        this.propagateTags = propagateTags;
    }

    public String getPropagateTags() {
        return this.propagateTags;
    }

    public CreateServiceRequest withPropagateTags(String propagateTags) {
        this.setPropagateTags(propagateTags);
        return this;
    }

    public CreateServiceRequest withPropagateTags(PropagateTags propagateTags) {
        this.propagateTags = propagateTags.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: ").append(this.getTaskDefinition()).append(",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.getLoadBalancers()).append(",");
        }
        if (this.getServiceRegistries() != null) {
            sb.append("ServiceRegistries: ").append(this.getServiceRegistries()).append(",");
        }
        if (this.getDesiredCount() != null) {
            sb.append("DesiredCount: ").append(this.getDesiredCount()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getLaunchType() != null) {
            sb.append("LaunchType: ").append(this.getLaunchType()).append(",");
        }
        if (this.getCapacityProviderStrategy() != null) {
            sb.append("CapacityProviderStrategy: ").append(this.getCapacityProviderStrategy()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getDeploymentConfiguration() != null) {
            sb.append("DeploymentConfiguration: ").append(this.getDeploymentConfiguration()).append(",");
        }
        if (this.getPlacementConstraints() != null) {
            sb.append("PlacementConstraints: ").append(this.getPlacementConstraints()).append(",");
        }
        if (this.getPlacementStrategy() != null) {
            sb.append("PlacementStrategy: ").append(this.getPlacementStrategy()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getHealthCheckGracePeriodSeconds() != null) {
            sb.append("HealthCheckGracePeriodSeconds: ").append(this.getHealthCheckGracePeriodSeconds()).append(",");
        }
        if (this.getSchedulingStrategy() != null) {
            sb.append("SchedulingStrategy: ").append(this.getSchedulingStrategy()).append(",");
        }
        if (this.getDeploymentController() != null) {
            sb.append("DeploymentController: ").append(this.getDeploymentController()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEnableECSManagedTags() != null) {
            sb.append("EnableECSManagedTags: ").append(this.getEnableECSManagedTags()).append(",");
        }
        if (this.getPropagateTags() != null) {
            sb.append("PropagateTags: ").append(this.getPropagateTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getServiceRegistries() == null ^ this.getServiceRegistries() == null) {
            return false;
        }
        if (other.getServiceRegistries() != null && !other.getServiceRegistries().equals(this.getServiceRegistries())) {
            return false;
        }
        if (other.getDesiredCount() == null ^ this.getDesiredCount() == null) {
            return false;
        }
        if (other.getDesiredCount() != null && !other.getDesiredCount().equals(this.getDesiredCount())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getLaunchType() == null ^ this.getLaunchType() == null) {
            return false;
        }
        if (other.getLaunchType() != null && !other.getLaunchType().equals(this.getLaunchType())) {
            return false;
        }
        if (other.getCapacityProviderStrategy() == null ^ this.getCapacityProviderStrategy() == null) {
            return false;
        }
        if (other.getCapacityProviderStrategy() != null && !other.getCapacityProviderStrategy().equals(this.getCapacityProviderStrategy())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getDeploymentConfiguration() == null ^ this.getDeploymentConfiguration() == null) {
            return false;
        }
        if (other.getDeploymentConfiguration() != null && !other.getDeploymentConfiguration().equals(this.getDeploymentConfiguration())) {
            return false;
        }
        if (other.getPlacementConstraints() == null ^ this.getPlacementConstraints() == null) {
            return false;
        }
        if (other.getPlacementConstraints() != null && !other.getPlacementConstraints().equals(this.getPlacementConstraints())) {
            return false;
        }
        if (other.getPlacementStrategy() == null ^ this.getPlacementStrategy() == null) {
            return false;
        }
        if (other.getPlacementStrategy() != null && !other.getPlacementStrategy().equals(this.getPlacementStrategy())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getHealthCheckGracePeriodSeconds() == null ^ this.getHealthCheckGracePeriodSeconds() == null) {
            return false;
        }
        if (other.getHealthCheckGracePeriodSeconds() != null && !other.getHealthCheckGracePeriodSeconds().equals(this.getHealthCheckGracePeriodSeconds())) {
            return false;
        }
        if (other.getSchedulingStrategy() == null ^ this.getSchedulingStrategy() == null) {
            return false;
        }
        if (other.getSchedulingStrategy() != null && !other.getSchedulingStrategy().equals(this.getSchedulingStrategy())) {
            return false;
        }
        if (other.getDeploymentController() == null ^ this.getDeploymentController() == null) {
            return false;
        }
        if (other.getDeploymentController() != null && !other.getDeploymentController().equals(this.getDeploymentController())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEnableECSManagedTags() == null ^ this.getEnableECSManagedTags() == null) {
            return false;
        }
        if (other.getEnableECSManagedTags() != null && !other.getEnableECSManagedTags().equals(this.getEnableECSManagedTags())) {
            return false;
        }
        if (other.getPropagateTags() == null ^ this.getPropagateTags() == null) {
            return false;
        }
        return other.getPropagateTags() == null || other.getPropagateTags().equals(this.getPropagateTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRegistries() == null ? 0 : this.getServiceRegistries().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCount() == null ? 0 : this.getDesiredCount().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchType() == null ? 0 : this.getLaunchType().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityProviderStrategy() == null ? 0 : this.getCapacityProviderStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfiguration() == null ? 0 : this.getDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementConstraints() == null ? 0 : this.getPlacementConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementStrategy() == null ? 0 : this.getPlacementStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckGracePeriodSeconds() == null ? 0 : this.getHealthCheckGracePeriodSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getSchedulingStrategy() == null ? 0 : this.getSchedulingStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentController() == null ? 0 : this.getDeploymentController().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEnableECSManagedTags() == null ? 0 : this.getEnableECSManagedTags().hashCode());
        hashCode = 31 * hashCode + (this.getPropagateTags() == null ? 0 : this.getPropagateTags().hashCode());
        return hashCode;
    }

    public CreateServiceRequest clone() {
        return (CreateServiceRequest)super.clone();
    }
}

