/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.CPUUtilization;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SystemStatus
implements Serializable,
Cloneable {
    private CPUUtilization cPUUtilization;
    private SdkInternalList<Double> loadAverage;

    public void setCPUUtilization(CPUUtilization cPUUtilization) {
        this.cPUUtilization = cPUUtilization;
    }

    public CPUUtilization getCPUUtilization() {
        return this.cPUUtilization;
    }

    public SystemStatus withCPUUtilization(CPUUtilization cPUUtilization) {
        this.setCPUUtilization(cPUUtilization);
        return this;
    }

    public List<Double> getLoadAverage() {
        if (this.loadAverage == null) {
            this.loadAverage = new SdkInternalList();
        }
        return this.loadAverage;
    }

    public void setLoadAverage(Collection<Double> loadAverage) {
        if (loadAverage == null) {
            this.loadAverage = null;
            return;
        }
        this.loadAverage = new SdkInternalList(loadAverage);
    }

    public SystemStatus withLoadAverage(Double ... loadAverage) {
        if (this.loadAverage == null) {
            this.setLoadAverage((Collection<Double>)new SdkInternalList(loadAverage.length));
        }
        for (Double ele : loadAverage) {
            this.loadAverage.add((Object)ele);
        }
        return this;
    }

    public SystemStatus withLoadAverage(Collection<Double> loadAverage) {
        this.setLoadAverage(loadAverage);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCPUUtilization() != null) {
            sb.append("CPUUtilization: ").append(this.getCPUUtilization()).append(",");
        }
        if (this.getLoadAverage() != null) {
            sb.append("LoadAverage: ").append(this.getLoadAverage());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemStatus)) {
            return false;
        }
        SystemStatus other = (SystemStatus)obj;
        if (other.getCPUUtilization() == null ^ this.getCPUUtilization() == null) {
            return false;
        }
        if (other.getCPUUtilization() != null && !other.getCPUUtilization().equals(this.getCPUUtilization())) {
            return false;
        }
        if (other.getLoadAverage() == null ^ this.getLoadAverage() == null) {
            return false;
        }
        return other.getLoadAverage() == null || other.getLoadAverage().equals(this.getLoadAverage());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCPUUtilization() == null ? 0 : this.getCPUUtilization().hashCode());
        hashCode = 31 * hashCode + (this.getLoadAverage() == null ? 0 : this.getLoadAverage().hashCode());
        return hashCode;
    }

    public SystemStatus clone() {
        try {
            return (SystemStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

