/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.fms.model.ResourceSet;
import com.amazonaws.services.fms.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutResourceSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ResourceSet resourceSet;
    private List<Tag> tagList;

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public PutResourceSetRequest withResourceSet(ResourceSet resourceSet) {
        this.setResourceSet(resourceSet);
        return this;
    }

    public List<Tag> getTagList() {
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new ArrayList<Tag>(tagList);
    }

    public PutResourceSetRequest withTagList(Tag ... tagList) {
        if (this.tagList == null) {
            this.setTagList(new ArrayList<Tag>(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add(ele);
        }
        return this;
    }

    public PutResourceSetRequest withTagList(Collection<Tag> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSet() != null) {
            sb.append("ResourceSet: ").append(this.getResourceSet()).append(",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: ").append(this.getTagList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourceSetRequest)) {
            return false;
        }
        PutResourceSetRequest other = (PutResourceSetRequest)obj;
        if (other.getResourceSet() == null ^ this.getResourceSet() == null) {
            return false;
        }
        if (other.getResourceSet() != null && !other.getResourceSet().equals(this.getResourceSet())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        return other.getTagList() == null || other.getTagList().equals(this.getTagList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSet() == null ? 0 : this.getResourceSet().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        return hashCode;
    }

    public PutResourceSetRequest clone() {
        return (PutResourceSetRequest)super.clone();
    }
}

