/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.imagebuilder.model.OutputResources;
import java.util.List;

@SdkInternalApi
public class OutputResourcesMarshaller {
    private static final MarshallingInfo<List> AMIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amis").build();
    private static final MarshallingInfo<List> CONTAINERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containers").build();
    private static final OutputResourcesMarshaller instance = new OutputResourcesMarshaller();

    public static OutputResourcesMarshaller getInstance() {
        return instance;
    }

    public void marshall(OutputResources outputResources, ProtocolMarshaller protocolMarshaller) {
        if (outputResources == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(outputResources.getAmis(), AMIS_BINDING);
            protocolMarshaller.marshall(outputResources.getContainers(), CONTAINERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

