/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lakeformation.AWSLakeFormationAsync;
import com.amazonaws.services.lakeformation.AWSLakeFormationAsyncClientBuilder;
import com.amazonaws.services.lakeformation.AWSLakeFormationClient;
import com.amazonaws.services.lakeformation.model.AddLFTagsToResourceRequest;
import com.amazonaws.services.lakeformation.model.AddLFTagsToResourceResult;
import com.amazonaws.services.lakeformation.model.AssumeDecoratedRoleWithSAMLRequest;
import com.amazonaws.services.lakeformation.model.AssumeDecoratedRoleWithSAMLResult;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.CancelTransactionRequest;
import com.amazonaws.services.lakeformation.model.CancelTransactionResult;
import com.amazonaws.services.lakeformation.model.CommitTransactionRequest;
import com.amazonaws.services.lakeformation.model.CommitTransactionResult;
import com.amazonaws.services.lakeformation.model.CreateDataCellsFilterRequest;
import com.amazonaws.services.lakeformation.model.CreateDataCellsFilterResult;
import com.amazonaws.services.lakeformation.model.CreateLFTagRequest;
import com.amazonaws.services.lakeformation.model.CreateLFTagResult;
import com.amazonaws.services.lakeformation.model.CreateLakeFormationOptInRequest;
import com.amazonaws.services.lakeformation.model.CreateLakeFormationOptInResult;
import com.amazonaws.services.lakeformation.model.DeleteDataCellsFilterRequest;
import com.amazonaws.services.lakeformation.model.DeleteDataCellsFilterResult;
import com.amazonaws.services.lakeformation.model.DeleteLFTagRequest;
import com.amazonaws.services.lakeformation.model.DeleteLFTagResult;
import com.amazonaws.services.lakeformation.model.DeleteLakeFormationOptInRequest;
import com.amazonaws.services.lakeformation.model.DeleteLakeFormationOptInResult;
import com.amazonaws.services.lakeformation.model.DeleteObjectsOnCancelRequest;
import com.amazonaws.services.lakeformation.model.DeleteObjectsOnCancelResult;
import com.amazonaws.services.lakeformation.model.DeregisterResourceRequest;
import com.amazonaws.services.lakeformation.model.DeregisterResourceResult;
import com.amazonaws.services.lakeformation.model.DescribeResourceRequest;
import com.amazonaws.services.lakeformation.model.DescribeResourceResult;
import com.amazonaws.services.lakeformation.model.DescribeTransactionRequest;
import com.amazonaws.services.lakeformation.model.DescribeTransactionResult;
import com.amazonaws.services.lakeformation.model.ExtendTransactionRequest;
import com.amazonaws.services.lakeformation.model.ExtendTransactionResult;
import com.amazonaws.services.lakeformation.model.GetDataCellsFilterRequest;
import com.amazonaws.services.lakeformation.model.GetDataCellsFilterResult;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathResult;
import com.amazonaws.services.lakeformation.model.GetLFTagRequest;
import com.amazonaws.services.lakeformation.model.GetLFTagResult;
import com.amazonaws.services.lakeformation.model.GetQueryStateRequest;
import com.amazonaws.services.lakeformation.model.GetQueryStateResult;
import com.amazonaws.services.lakeformation.model.GetQueryStatisticsRequest;
import com.amazonaws.services.lakeformation.model.GetQueryStatisticsResult;
import com.amazonaws.services.lakeformation.model.GetResourceLFTagsRequest;
import com.amazonaws.services.lakeformation.model.GetResourceLFTagsResult;
import com.amazonaws.services.lakeformation.model.GetTableObjectsRequest;
import com.amazonaws.services.lakeformation.model.GetTableObjectsResult;
import com.amazonaws.services.lakeformation.model.GetTemporaryGluePartitionCredentialsRequest;
import com.amazonaws.services.lakeformation.model.GetTemporaryGluePartitionCredentialsResult;
import com.amazonaws.services.lakeformation.model.GetTemporaryGlueTableCredentialsRequest;
import com.amazonaws.services.lakeformation.model.GetTemporaryGlueTableCredentialsResult;
import com.amazonaws.services.lakeformation.model.GetWorkUnitResultsRequest;
import com.amazonaws.services.lakeformation.model.GetWorkUnitResultsResult;
import com.amazonaws.services.lakeformation.model.GetWorkUnitsRequest;
import com.amazonaws.services.lakeformation.model.GetWorkUnitsResult;
import com.amazonaws.services.lakeformation.model.GrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.GrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListDataCellsFilterRequest;
import com.amazonaws.services.lakeformation.model.ListDataCellsFilterResult;
import com.amazonaws.services.lakeformation.model.ListLFTagsRequest;
import com.amazonaws.services.lakeformation.model.ListLFTagsResult;
import com.amazonaws.services.lakeformation.model.ListLakeFormationOptInsRequest;
import com.amazonaws.services.lakeformation.model.ListLakeFormationOptInsResult;
import com.amazonaws.services.lakeformation.model.ListPermissionsRequest;
import com.amazonaws.services.lakeformation.model.ListPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListResourcesRequest;
import com.amazonaws.services.lakeformation.model.ListResourcesResult;
import com.amazonaws.services.lakeformation.model.ListTableStorageOptimizersRequest;
import com.amazonaws.services.lakeformation.model.ListTableStorageOptimizersResult;
import com.amazonaws.services.lakeformation.model.ListTransactionsRequest;
import com.amazonaws.services.lakeformation.model.ListTransactionsResult;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.RegisterResourceRequest;
import com.amazonaws.services.lakeformation.model.RegisterResourceResult;
import com.amazonaws.services.lakeformation.model.RemoveLFTagsFromResourceRequest;
import com.amazonaws.services.lakeformation.model.RemoveLFTagsFromResourceResult;
import com.amazonaws.services.lakeformation.model.RevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.RevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.SearchDatabasesByLFTagsRequest;
import com.amazonaws.services.lakeformation.model.SearchDatabasesByLFTagsResult;
import com.amazonaws.services.lakeformation.model.SearchTablesByLFTagsRequest;
import com.amazonaws.services.lakeformation.model.SearchTablesByLFTagsResult;
import com.amazonaws.services.lakeformation.model.StartQueryPlanningRequest;
import com.amazonaws.services.lakeformation.model.StartQueryPlanningResult;
import com.amazonaws.services.lakeformation.model.StartTransactionRequest;
import com.amazonaws.services.lakeformation.model.StartTransactionResult;
import com.amazonaws.services.lakeformation.model.UpdateDataCellsFilterRequest;
import com.amazonaws.services.lakeformation.model.UpdateDataCellsFilterResult;
import com.amazonaws.services.lakeformation.model.UpdateLFTagRequest;
import com.amazonaws.services.lakeformation.model.UpdateLFTagResult;
import com.amazonaws.services.lakeformation.model.UpdateResourceRequest;
import com.amazonaws.services.lakeformation.model.UpdateResourceResult;
import com.amazonaws.services.lakeformation.model.UpdateTableObjectsRequest;
import com.amazonaws.services.lakeformation.model.UpdateTableObjectsResult;
import com.amazonaws.services.lakeformation.model.UpdateTableStorageOptimizerRequest;
import com.amazonaws.services.lakeformation.model.UpdateTableStorageOptimizerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLakeFormationAsyncClient
extends AWSLakeFormationClient
implements AWSLakeFormationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSLakeFormationAsyncClientBuilder asyncBuilder() {
        return AWSLakeFormationAsyncClientBuilder.standard();
    }

    AWSLakeFormationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSLakeFormationAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddLFTagsToResourceResult> addLFTagsToResourceAsync(AddLFTagsToResourceRequest request) {
        return this.addLFTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddLFTagsToResourceResult> addLFTagsToResourceAsync(AddLFTagsToResourceRequest request, final AsyncHandler<AddLFTagsToResourceRequest, AddLFTagsToResourceResult> asyncHandler) {
        final AddLFTagsToResourceRequest finalRequest = (AddLFTagsToResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddLFTagsToResourceResult>(){

            @Override
            public AddLFTagsToResourceResult call() throws Exception {
                AddLFTagsToResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeAddLFTagsToResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeDecoratedRoleWithSAMLResult> assumeDecoratedRoleWithSAMLAsync(AssumeDecoratedRoleWithSAMLRequest request) {
        return this.assumeDecoratedRoleWithSAMLAsync(request, null);
    }

    @Override
    public Future<AssumeDecoratedRoleWithSAMLResult> assumeDecoratedRoleWithSAMLAsync(AssumeDecoratedRoleWithSAMLRequest request, final AsyncHandler<AssumeDecoratedRoleWithSAMLRequest, AssumeDecoratedRoleWithSAMLResult> asyncHandler) {
        final AssumeDecoratedRoleWithSAMLRequest finalRequest = (AssumeDecoratedRoleWithSAMLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeDecoratedRoleWithSAMLResult>(){

            @Override
            public AssumeDecoratedRoleWithSAMLResult call() throws Exception {
                AssumeDecoratedRoleWithSAMLResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeAssumeDecoratedRoleWithSAML(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGrantPermissionsResult> batchGrantPermissionsAsync(BatchGrantPermissionsRequest request) {
        return this.batchGrantPermissionsAsync(request, null);
    }

    @Override
    public Future<BatchGrantPermissionsResult> batchGrantPermissionsAsync(BatchGrantPermissionsRequest request, final AsyncHandler<BatchGrantPermissionsRequest, BatchGrantPermissionsResult> asyncHandler) {
        final BatchGrantPermissionsRequest finalRequest = (BatchGrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGrantPermissionsResult>(){

            @Override
            public BatchGrantPermissionsResult call() throws Exception {
                BatchGrantPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeBatchGrantPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchRevokePermissionsResult> batchRevokePermissionsAsync(BatchRevokePermissionsRequest request) {
        return this.batchRevokePermissionsAsync(request, null);
    }

    @Override
    public Future<BatchRevokePermissionsResult> batchRevokePermissionsAsync(BatchRevokePermissionsRequest request, final AsyncHandler<BatchRevokePermissionsRequest, BatchRevokePermissionsResult> asyncHandler) {
        final BatchRevokePermissionsRequest finalRequest = (BatchRevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchRevokePermissionsResult>(){

            @Override
            public BatchRevokePermissionsResult call() throws Exception {
                BatchRevokePermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeBatchRevokePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelTransactionResult> cancelTransactionAsync(CancelTransactionRequest request) {
        return this.cancelTransactionAsync(request, null);
    }

    @Override
    public Future<CancelTransactionResult> cancelTransactionAsync(CancelTransactionRequest request, final AsyncHandler<CancelTransactionRequest, CancelTransactionResult> asyncHandler) {
        final CancelTransactionRequest finalRequest = (CancelTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelTransactionResult>(){

            @Override
            public CancelTransactionResult call() throws Exception {
                CancelTransactionResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeCancelTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CommitTransactionResult> commitTransactionAsync(CommitTransactionRequest request) {
        return this.commitTransactionAsync(request, null);
    }

    @Override
    public Future<CommitTransactionResult> commitTransactionAsync(CommitTransactionRequest request, final AsyncHandler<CommitTransactionRequest, CommitTransactionResult> asyncHandler) {
        final CommitTransactionRequest finalRequest = (CommitTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CommitTransactionResult>(){

            @Override
            public CommitTransactionResult call() throws Exception {
                CommitTransactionResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeCommitTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataCellsFilterResult> createDataCellsFilterAsync(CreateDataCellsFilterRequest request) {
        return this.createDataCellsFilterAsync(request, null);
    }

    @Override
    public Future<CreateDataCellsFilterResult> createDataCellsFilterAsync(CreateDataCellsFilterRequest request, final AsyncHandler<CreateDataCellsFilterRequest, CreateDataCellsFilterResult> asyncHandler) {
        final CreateDataCellsFilterRequest finalRequest = (CreateDataCellsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataCellsFilterResult>(){

            @Override
            public CreateDataCellsFilterResult call() throws Exception {
                CreateDataCellsFilterResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeCreateDataCellsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLFTagResult> createLFTagAsync(CreateLFTagRequest request) {
        return this.createLFTagAsync(request, null);
    }

    @Override
    public Future<CreateLFTagResult> createLFTagAsync(CreateLFTagRequest request, final AsyncHandler<CreateLFTagRequest, CreateLFTagResult> asyncHandler) {
        final CreateLFTagRequest finalRequest = (CreateLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLFTagResult>(){

            @Override
            public CreateLFTagResult call() throws Exception {
                CreateLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeCreateLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateLakeFormationOptInResult> createLakeFormationOptInAsync(CreateLakeFormationOptInRequest request) {
        return this.createLakeFormationOptInAsync(request, null);
    }

    @Override
    public Future<CreateLakeFormationOptInResult> createLakeFormationOptInAsync(CreateLakeFormationOptInRequest request, final AsyncHandler<CreateLakeFormationOptInRequest, CreateLakeFormationOptInResult> asyncHandler) {
        final CreateLakeFormationOptInRequest finalRequest = (CreateLakeFormationOptInRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateLakeFormationOptInResult>(){

            @Override
            public CreateLakeFormationOptInResult call() throws Exception {
                CreateLakeFormationOptInResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeCreateLakeFormationOptIn(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataCellsFilterResult> deleteDataCellsFilterAsync(DeleteDataCellsFilterRequest request) {
        return this.deleteDataCellsFilterAsync(request, null);
    }

    @Override
    public Future<DeleteDataCellsFilterResult> deleteDataCellsFilterAsync(DeleteDataCellsFilterRequest request, final AsyncHandler<DeleteDataCellsFilterRequest, DeleteDataCellsFilterResult> asyncHandler) {
        final DeleteDataCellsFilterRequest finalRequest = (DeleteDataCellsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataCellsFilterResult>(){

            @Override
            public DeleteDataCellsFilterResult call() throws Exception {
                DeleteDataCellsFilterResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeleteDataCellsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLFTagResult> deleteLFTagAsync(DeleteLFTagRequest request) {
        return this.deleteLFTagAsync(request, null);
    }

    @Override
    public Future<DeleteLFTagResult> deleteLFTagAsync(DeleteLFTagRequest request, final AsyncHandler<DeleteLFTagRequest, DeleteLFTagResult> asyncHandler) {
        final DeleteLFTagRequest finalRequest = (DeleteLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLFTagResult>(){

            @Override
            public DeleteLFTagResult call() throws Exception {
                DeleteLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeleteLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteLakeFormationOptInResult> deleteLakeFormationOptInAsync(DeleteLakeFormationOptInRequest request) {
        return this.deleteLakeFormationOptInAsync(request, null);
    }

    @Override
    public Future<DeleteLakeFormationOptInResult> deleteLakeFormationOptInAsync(DeleteLakeFormationOptInRequest request, final AsyncHandler<DeleteLakeFormationOptInRequest, DeleteLakeFormationOptInResult> asyncHandler) {
        final DeleteLakeFormationOptInRequest finalRequest = (DeleteLakeFormationOptInRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteLakeFormationOptInResult>(){

            @Override
            public DeleteLakeFormationOptInResult call() throws Exception {
                DeleteLakeFormationOptInResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeleteLakeFormationOptIn(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteObjectsOnCancelResult> deleteObjectsOnCancelAsync(DeleteObjectsOnCancelRequest request) {
        return this.deleteObjectsOnCancelAsync(request, null);
    }

    @Override
    public Future<DeleteObjectsOnCancelResult> deleteObjectsOnCancelAsync(DeleteObjectsOnCancelRequest request, final AsyncHandler<DeleteObjectsOnCancelRequest, DeleteObjectsOnCancelResult> asyncHandler) {
        final DeleteObjectsOnCancelRequest finalRequest = (DeleteObjectsOnCancelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteObjectsOnCancelResult>(){

            @Override
            public DeleteObjectsOnCancelResult call() throws Exception {
                DeleteObjectsOnCancelResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeleteObjectsOnCancel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterResourceResult> deregisterResourceAsync(DeregisterResourceRequest request) {
        return this.deregisterResourceAsync(request, null);
    }

    @Override
    public Future<DeregisterResourceResult> deregisterResourceAsync(DeregisterResourceRequest request, final AsyncHandler<DeregisterResourceRequest, DeregisterResourceResult> asyncHandler) {
        final DeregisterResourceRequest finalRequest = (DeregisterResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterResourceResult>(){

            @Override
            public DeregisterResourceResult call() throws Exception {
                DeregisterResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeregisterResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourceResult> describeResourceAsync(DescribeResourceRequest request) {
        return this.describeResourceAsync(request, null);
    }

    @Override
    public Future<DescribeResourceResult> describeResourceAsync(DescribeResourceRequest request, final AsyncHandler<DescribeResourceRequest, DescribeResourceResult> asyncHandler) {
        final DescribeResourceRequest finalRequest = (DescribeResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeResourceResult>(){

            @Override
            public DescribeResourceResult call() throws Exception {
                DescribeResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDescribeResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTransactionResult> describeTransactionAsync(DescribeTransactionRequest request) {
        return this.describeTransactionAsync(request, null);
    }

    @Override
    public Future<DescribeTransactionResult> describeTransactionAsync(DescribeTransactionRequest request, final AsyncHandler<DescribeTransactionRequest, DescribeTransactionResult> asyncHandler) {
        final DescribeTransactionRequest finalRequest = (DescribeTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTransactionResult>(){

            @Override
            public DescribeTransactionResult call() throws Exception {
                DescribeTransactionResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDescribeTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExtendTransactionResult> extendTransactionAsync(ExtendTransactionRequest request) {
        return this.extendTransactionAsync(request, null);
    }

    @Override
    public Future<ExtendTransactionResult> extendTransactionAsync(ExtendTransactionRequest request, final AsyncHandler<ExtendTransactionRequest, ExtendTransactionResult> asyncHandler) {
        final ExtendTransactionRequest finalRequest = (ExtendTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExtendTransactionResult>(){

            @Override
            public ExtendTransactionResult call() throws Exception {
                ExtendTransactionResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeExtendTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataCellsFilterResult> getDataCellsFilterAsync(GetDataCellsFilterRequest request) {
        return this.getDataCellsFilterAsync(request, null);
    }

    @Override
    public Future<GetDataCellsFilterResult> getDataCellsFilterAsync(GetDataCellsFilterRequest request, final AsyncHandler<GetDataCellsFilterRequest, GetDataCellsFilterResult> asyncHandler) {
        final GetDataCellsFilterRequest finalRequest = (GetDataCellsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataCellsFilterResult>(){

            @Override
            public GetDataCellsFilterResult call() throws Exception {
                GetDataCellsFilterResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetDataCellsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataLakeSettingsResult> getDataLakeSettingsAsync(GetDataLakeSettingsRequest request) {
        return this.getDataLakeSettingsAsync(request, null);
    }

    @Override
    public Future<GetDataLakeSettingsResult> getDataLakeSettingsAsync(GetDataLakeSettingsRequest request, final AsyncHandler<GetDataLakeSettingsRequest, GetDataLakeSettingsResult> asyncHandler) {
        final GetDataLakeSettingsRequest finalRequest = (GetDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataLakeSettingsResult>(){

            @Override
            public GetDataLakeSettingsResult call() throws Exception {
                GetDataLakeSettingsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetDataLakeSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEffectivePermissionsForPathResult> getEffectivePermissionsForPathAsync(GetEffectivePermissionsForPathRequest request) {
        return this.getEffectivePermissionsForPathAsync(request, null);
    }

    @Override
    public Future<GetEffectivePermissionsForPathResult> getEffectivePermissionsForPathAsync(GetEffectivePermissionsForPathRequest request, final AsyncHandler<GetEffectivePermissionsForPathRequest, GetEffectivePermissionsForPathResult> asyncHandler) {
        final GetEffectivePermissionsForPathRequest finalRequest = (GetEffectivePermissionsForPathRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEffectivePermissionsForPathResult>(){

            @Override
            public GetEffectivePermissionsForPathResult call() throws Exception {
                GetEffectivePermissionsForPathResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetEffectivePermissionsForPath(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLFTagResult> getLFTagAsync(GetLFTagRequest request) {
        return this.getLFTagAsync(request, null);
    }

    @Override
    public Future<GetLFTagResult> getLFTagAsync(GetLFTagRequest request, final AsyncHandler<GetLFTagRequest, GetLFTagResult> asyncHandler) {
        final GetLFTagRequest finalRequest = (GetLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLFTagResult>(){

            @Override
            public GetLFTagResult call() throws Exception {
                GetLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryStateResult> getQueryStateAsync(GetQueryStateRequest request) {
        return this.getQueryStateAsync(request, null);
    }

    @Override
    public Future<GetQueryStateResult> getQueryStateAsync(GetQueryStateRequest request, final AsyncHandler<GetQueryStateRequest, GetQueryStateResult> asyncHandler) {
        final GetQueryStateRequest finalRequest = (GetQueryStateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryStateResult>(){

            @Override
            public GetQueryStateResult call() throws Exception {
                GetQueryStateResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetQueryState(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetQueryStatisticsResult> getQueryStatisticsAsync(GetQueryStatisticsRequest request) {
        return this.getQueryStatisticsAsync(request, null);
    }

    @Override
    public Future<GetQueryStatisticsResult> getQueryStatisticsAsync(GetQueryStatisticsRequest request, final AsyncHandler<GetQueryStatisticsRequest, GetQueryStatisticsResult> asyncHandler) {
        final GetQueryStatisticsRequest finalRequest = (GetQueryStatisticsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetQueryStatisticsResult>(){

            @Override
            public GetQueryStatisticsResult call() throws Exception {
                GetQueryStatisticsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetQueryStatistics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourceLFTagsResult> getResourceLFTagsAsync(GetResourceLFTagsRequest request) {
        return this.getResourceLFTagsAsync(request, null);
    }

    @Override
    public Future<GetResourceLFTagsResult> getResourceLFTagsAsync(GetResourceLFTagsRequest request, final AsyncHandler<GetResourceLFTagsRequest, GetResourceLFTagsResult> asyncHandler) {
        final GetResourceLFTagsRequest finalRequest = (GetResourceLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourceLFTagsResult>(){

            @Override
            public GetResourceLFTagsResult call() throws Exception {
                GetResourceLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetResourceLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTableObjectsResult> getTableObjectsAsync(GetTableObjectsRequest request) {
        return this.getTableObjectsAsync(request, null);
    }

    @Override
    public Future<GetTableObjectsResult> getTableObjectsAsync(GetTableObjectsRequest request, final AsyncHandler<GetTableObjectsRequest, GetTableObjectsResult> asyncHandler) {
        final GetTableObjectsRequest finalRequest = (GetTableObjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTableObjectsResult>(){

            @Override
            public GetTableObjectsResult call() throws Exception {
                GetTableObjectsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetTableObjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemporaryGluePartitionCredentialsResult> getTemporaryGluePartitionCredentialsAsync(GetTemporaryGluePartitionCredentialsRequest request) {
        return this.getTemporaryGluePartitionCredentialsAsync(request, null);
    }

    @Override
    public Future<GetTemporaryGluePartitionCredentialsResult> getTemporaryGluePartitionCredentialsAsync(GetTemporaryGluePartitionCredentialsRequest request, final AsyncHandler<GetTemporaryGluePartitionCredentialsRequest, GetTemporaryGluePartitionCredentialsResult> asyncHandler) {
        final GetTemporaryGluePartitionCredentialsRequest finalRequest = (GetTemporaryGluePartitionCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTemporaryGluePartitionCredentialsResult>(){

            @Override
            public GetTemporaryGluePartitionCredentialsResult call() throws Exception {
                GetTemporaryGluePartitionCredentialsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetTemporaryGluePartitionCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTemporaryGlueTableCredentialsResult> getTemporaryGlueTableCredentialsAsync(GetTemporaryGlueTableCredentialsRequest request) {
        return this.getTemporaryGlueTableCredentialsAsync(request, null);
    }

    @Override
    public Future<GetTemporaryGlueTableCredentialsResult> getTemporaryGlueTableCredentialsAsync(GetTemporaryGlueTableCredentialsRequest request, final AsyncHandler<GetTemporaryGlueTableCredentialsRequest, GetTemporaryGlueTableCredentialsResult> asyncHandler) {
        final GetTemporaryGlueTableCredentialsRequest finalRequest = (GetTemporaryGlueTableCredentialsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTemporaryGlueTableCredentialsResult>(){

            @Override
            public GetTemporaryGlueTableCredentialsResult call() throws Exception {
                GetTemporaryGlueTableCredentialsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetTemporaryGlueTableCredentials(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkUnitResultsResult> getWorkUnitResultsAsync(GetWorkUnitResultsRequest request) {
        return this.getWorkUnitResultsAsync(request, null);
    }

    @Override
    public Future<GetWorkUnitResultsResult> getWorkUnitResultsAsync(GetWorkUnitResultsRequest request, final AsyncHandler<GetWorkUnitResultsRequest, GetWorkUnitResultsResult> asyncHandler) {
        final GetWorkUnitResultsRequest finalRequest = (GetWorkUnitResultsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkUnitResultsResult>(){

            @Override
            public GetWorkUnitResultsResult call() throws Exception {
                GetWorkUnitResultsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetWorkUnitResults(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWorkUnitsResult> getWorkUnitsAsync(GetWorkUnitsRequest request) {
        return this.getWorkUnitsAsync(request, null);
    }

    @Override
    public Future<GetWorkUnitsResult> getWorkUnitsAsync(GetWorkUnitsRequest request, final AsyncHandler<GetWorkUnitsRequest, GetWorkUnitsResult> asyncHandler) {
        final GetWorkUnitsRequest finalRequest = (GetWorkUnitsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetWorkUnitsResult>(){

            @Override
            public GetWorkUnitsResult call() throws Exception {
                GetWorkUnitsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetWorkUnits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GrantPermissionsResult> grantPermissionsAsync(GrantPermissionsRequest request) {
        return this.grantPermissionsAsync(request, null);
    }

    @Override
    public Future<GrantPermissionsResult> grantPermissionsAsync(GrantPermissionsRequest request, final AsyncHandler<GrantPermissionsRequest, GrantPermissionsResult> asyncHandler) {
        final GrantPermissionsRequest finalRequest = (GrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GrantPermissionsResult>(){

            @Override
            public GrantPermissionsResult call() throws Exception {
                GrantPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGrantPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataCellsFilterResult> listDataCellsFilterAsync(ListDataCellsFilterRequest request) {
        return this.listDataCellsFilterAsync(request, null);
    }

    @Override
    public Future<ListDataCellsFilterResult> listDataCellsFilterAsync(ListDataCellsFilterRequest request, final AsyncHandler<ListDataCellsFilterRequest, ListDataCellsFilterResult> asyncHandler) {
        final ListDataCellsFilterRequest finalRequest = (ListDataCellsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataCellsFilterResult>(){

            @Override
            public ListDataCellsFilterResult call() throws Exception {
                ListDataCellsFilterResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListDataCellsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLFTagsResult> listLFTagsAsync(ListLFTagsRequest request) {
        return this.listLFTagsAsync(request, null);
    }

    @Override
    public Future<ListLFTagsResult> listLFTagsAsync(ListLFTagsRequest request, final AsyncHandler<ListLFTagsRequest, ListLFTagsResult> asyncHandler) {
        final ListLFTagsRequest finalRequest = (ListLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLFTagsResult>(){

            @Override
            public ListLFTagsResult call() throws Exception {
                ListLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListLakeFormationOptInsResult> listLakeFormationOptInsAsync(ListLakeFormationOptInsRequest request) {
        return this.listLakeFormationOptInsAsync(request, null);
    }

    @Override
    public Future<ListLakeFormationOptInsResult> listLakeFormationOptInsAsync(ListLakeFormationOptInsRequest request, final AsyncHandler<ListLakeFormationOptInsRequest, ListLakeFormationOptInsResult> asyncHandler) {
        final ListLakeFormationOptInsRequest finalRequest = (ListLakeFormationOptInsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListLakeFormationOptInsResult>(){

            @Override
            public ListLakeFormationOptInsResult call() throws Exception {
                ListLakeFormationOptInsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListLakeFormationOptIns(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request) {
        return this.listPermissionsAsync(request, null);
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request, final AsyncHandler<ListPermissionsRequest, ListPermissionsResult> asyncHandler) {
        final ListPermissionsRequest finalRequest = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionsResult>(){

            @Override
            public ListPermissionsResult call() throws Exception {
                ListPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request) {
        return this.listResourcesAsync(request, null);
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request, final AsyncHandler<ListResourcesRequest, ListResourcesResult> asyncHandler) {
        final ListResourcesRequest finalRequest = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesResult>(){

            @Override
            public ListResourcesResult call() throws Exception {
                ListResourcesResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTableStorageOptimizersResult> listTableStorageOptimizersAsync(ListTableStorageOptimizersRequest request) {
        return this.listTableStorageOptimizersAsync(request, null);
    }

    @Override
    public Future<ListTableStorageOptimizersResult> listTableStorageOptimizersAsync(ListTableStorageOptimizersRequest request, final AsyncHandler<ListTableStorageOptimizersRequest, ListTableStorageOptimizersResult> asyncHandler) {
        final ListTableStorageOptimizersRequest finalRequest = (ListTableStorageOptimizersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTableStorageOptimizersResult>(){

            @Override
            public ListTableStorageOptimizersResult call() throws Exception {
                ListTableStorageOptimizersResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListTableStorageOptimizers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTransactionsResult> listTransactionsAsync(ListTransactionsRequest request) {
        return this.listTransactionsAsync(request, null);
    }

    @Override
    public Future<ListTransactionsResult> listTransactionsAsync(ListTransactionsRequest request, final AsyncHandler<ListTransactionsRequest, ListTransactionsResult> asyncHandler) {
        final ListTransactionsRequest finalRequest = (ListTransactionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTransactionsResult>(){

            @Override
            public ListTransactionsResult call() throws Exception {
                ListTransactionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListTransactions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDataLakeSettingsResult> putDataLakeSettingsAsync(PutDataLakeSettingsRequest request) {
        return this.putDataLakeSettingsAsync(request, null);
    }

    @Override
    public Future<PutDataLakeSettingsResult> putDataLakeSettingsAsync(PutDataLakeSettingsRequest request, final AsyncHandler<PutDataLakeSettingsRequest, PutDataLakeSettingsResult> asyncHandler) {
        final PutDataLakeSettingsRequest finalRequest = (PutDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDataLakeSettingsResult>(){

            @Override
            public PutDataLakeSettingsResult call() throws Exception {
                PutDataLakeSettingsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executePutDataLakeSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterResourceResult> registerResourceAsync(RegisterResourceRequest request) {
        return this.registerResourceAsync(request, null);
    }

    @Override
    public Future<RegisterResourceResult> registerResourceAsync(RegisterResourceRequest request, final AsyncHandler<RegisterResourceRequest, RegisterResourceResult> asyncHandler) {
        final RegisterResourceRequest finalRequest = (RegisterResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterResourceResult>(){

            @Override
            public RegisterResourceResult call() throws Exception {
                RegisterResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRegisterResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveLFTagsFromResourceResult> removeLFTagsFromResourceAsync(RemoveLFTagsFromResourceRequest request) {
        return this.removeLFTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveLFTagsFromResourceResult> removeLFTagsFromResourceAsync(RemoveLFTagsFromResourceRequest request, final AsyncHandler<RemoveLFTagsFromResourceRequest, RemoveLFTagsFromResourceResult> asyncHandler) {
        final RemoveLFTagsFromResourceRequest finalRequest = (RemoveLFTagsFromResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveLFTagsFromResourceResult>(){

            @Override
            public RemoveLFTagsFromResourceResult call() throws Exception {
                RemoveLFTagsFromResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRemoveLFTagsFromResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokePermissionsResult> revokePermissionsAsync(RevokePermissionsRequest request) {
        return this.revokePermissionsAsync(request, null);
    }

    @Override
    public Future<RevokePermissionsResult> revokePermissionsAsync(RevokePermissionsRequest request, final AsyncHandler<RevokePermissionsRequest, RevokePermissionsResult> asyncHandler) {
        final RevokePermissionsRequest finalRequest = (RevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokePermissionsResult>(){

            @Override
            public RevokePermissionsResult call() throws Exception {
                RevokePermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRevokePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchDatabasesByLFTagsResult> searchDatabasesByLFTagsAsync(SearchDatabasesByLFTagsRequest request) {
        return this.searchDatabasesByLFTagsAsync(request, null);
    }

    @Override
    public Future<SearchDatabasesByLFTagsResult> searchDatabasesByLFTagsAsync(SearchDatabasesByLFTagsRequest request, final AsyncHandler<SearchDatabasesByLFTagsRequest, SearchDatabasesByLFTagsResult> asyncHandler) {
        final SearchDatabasesByLFTagsRequest finalRequest = (SearchDatabasesByLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchDatabasesByLFTagsResult>(){

            @Override
            public SearchDatabasesByLFTagsResult call() throws Exception {
                SearchDatabasesByLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeSearchDatabasesByLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SearchTablesByLFTagsResult> searchTablesByLFTagsAsync(SearchTablesByLFTagsRequest request) {
        return this.searchTablesByLFTagsAsync(request, null);
    }

    @Override
    public Future<SearchTablesByLFTagsResult> searchTablesByLFTagsAsync(SearchTablesByLFTagsRequest request, final AsyncHandler<SearchTablesByLFTagsRequest, SearchTablesByLFTagsResult> asyncHandler) {
        final SearchTablesByLFTagsRequest finalRequest = (SearchTablesByLFTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SearchTablesByLFTagsResult>(){

            @Override
            public SearchTablesByLFTagsResult call() throws Exception {
                SearchTablesByLFTagsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeSearchTablesByLFTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartQueryPlanningResult> startQueryPlanningAsync(StartQueryPlanningRequest request) {
        return this.startQueryPlanningAsync(request, null);
    }

    @Override
    public Future<StartQueryPlanningResult> startQueryPlanningAsync(StartQueryPlanningRequest request, final AsyncHandler<StartQueryPlanningRequest, StartQueryPlanningResult> asyncHandler) {
        final StartQueryPlanningRequest finalRequest = (StartQueryPlanningRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartQueryPlanningResult>(){

            @Override
            public StartQueryPlanningResult call() throws Exception {
                StartQueryPlanningResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeStartQueryPlanning(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartTransactionResult> startTransactionAsync(StartTransactionRequest request) {
        return this.startTransactionAsync(request, null);
    }

    @Override
    public Future<StartTransactionResult> startTransactionAsync(StartTransactionRequest request, final AsyncHandler<StartTransactionRequest, StartTransactionResult> asyncHandler) {
        final StartTransactionRequest finalRequest = (StartTransactionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartTransactionResult>(){

            @Override
            public StartTransactionResult call() throws Exception {
                StartTransactionResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeStartTransaction(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataCellsFilterResult> updateDataCellsFilterAsync(UpdateDataCellsFilterRequest request) {
        return this.updateDataCellsFilterAsync(request, null);
    }

    @Override
    public Future<UpdateDataCellsFilterResult> updateDataCellsFilterAsync(UpdateDataCellsFilterRequest request, final AsyncHandler<UpdateDataCellsFilterRequest, UpdateDataCellsFilterResult> asyncHandler) {
        final UpdateDataCellsFilterRequest finalRequest = (UpdateDataCellsFilterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataCellsFilterResult>(){

            @Override
            public UpdateDataCellsFilterResult call() throws Exception {
                UpdateDataCellsFilterResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateDataCellsFilter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateLFTagResult> updateLFTagAsync(UpdateLFTagRequest request) {
        return this.updateLFTagAsync(request, null);
    }

    @Override
    public Future<UpdateLFTagResult> updateLFTagAsync(UpdateLFTagRequest request, final AsyncHandler<UpdateLFTagRequest, UpdateLFTagResult> asyncHandler) {
        final UpdateLFTagRequest finalRequest = (UpdateLFTagRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateLFTagResult>(){

            @Override
            public UpdateLFTagResult call() throws Exception {
                UpdateLFTagResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateLFTag(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request) {
        return this.updateResourceAsync(request, null);
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request, final AsyncHandler<UpdateResourceRequest, UpdateResourceResult> asyncHandler) {
        final UpdateResourceRequest finalRequest = (UpdateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResourceResult>(){

            @Override
            public UpdateResourceResult call() throws Exception {
                UpdateResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableObjectsResult> updateTableObjectsAsync(UpdateTableObjectsRequest request) {
        return this.updateTableObjectsAsync(request, null);
    }

    @Override
    public Future<UpdateTableObjectsResult> updateTableObjectsAsync(UpdateTableObjectsRequest request, final AsyncHandler<UpdateTableObjectsRequest, UpdateTableObjectsResult> asyncHandler) {
        final UpdateTableObjectsRequest finalRequest = (UpdateTableObjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableObjectsResult>(){

            @Override
            public UpdateTableObjectsResult call() throws Exception {
                UpdateTableObjectsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateTableObjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableStorageOptimizerResult> updateTableStorageOptimizerAsync(UpdateTableStorageOptimizerRequest request) {
        return this.updateTableStorageOptimizerAsync(request, null);
    }

    @Override
    public Future<UpdateTableStorageOptimizerResult> updateTableStorageOptimizerAsync(UpdateTableStorageOptimizerRequest request, final AsyncHandler<UpdateTableStorageOptimizerRequest, UpdateTableStorageOptimizerResult> asyncHandler) {
        final UpdateTableStorageOptimizerRequest finalRequest = (UpdateTableStorageOptimizerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTableStorageOptimizerResult>(){

            @Override
            public UpdateTableStorageOptimizerResult call() throws Exception {
                UpdateTableStorageOptimizerResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateTableStorageOptimizer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

