/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.OptimizerType;
import com.amazonaws.services.lakeformation.model.transform.StorageOptimizerMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StorageOptimizer
implements Serializable,
Cloneable,
StructuredPojo {
    private String storageOptimizerType;
    private Map<String, String> config;
    private String errorMessage;
    private String warnings;
    private String lastRunDetails;

    public void setStorageOptimizerType(String storageOptimizerType) {
        this.storageOptimizerType = storageOptimizerType;
    }

    public String getStorageOptimizerType() {
        return this.storageOptimizerType;
    }

    public StorageOptimizer withStorageOptimizerType(String storageOptimizerType) {
        this.setStorageOptimizerType(storageOptimizerType);
        return this;
    }

    public StorageOptimizer withStorageOptimizerType(OptimizerType storageOptimizerType) {
        this.storageOptimizerType = storageOptimizerType.toString();
        return this;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public StorageOptimizer withConfig(Map<String, String> config) {
        this.setConfig(config);
        return this;
    }

    public StorageOptimizer addConfigEntry(String key, String value) {
        if (null == this.config) {
            this.config = new HashMap<String, String>();
        }
        if (this.config.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.config.put(key, value);
        return this;
    }

    public StorageOptimizer clearConfigEntries() {
        this.config = null;
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public StorageOptimizer withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public void setWarnings(String warnings) {
        this.warnings = warnings;
    }

    public String getWarnings() {
        return this.warnings;
    }

    public StorageOptimizer withWarnings(String warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public void setLastRunDetails(String lastRunDetails) {
        this.lastRunDetails = lastRunDetails;
    }

    public String getLastRunDetails() {
        return this.lastRunDetails;
    }

    public StorageOptimizer withLastRunDetails(String lastRunDetails) {
        this.setLastRunDetails(lastRunDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStorageOptimizerType() != null) {
            sb.append("StorageOptimizerType: ").append(this.getStorageOptimizerType()).append(",");
        }
        if (this.getConfig() != null) {
            sb.append("Config: ").append(this.getConfig()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: ").append(this.getWarnings()).append(",");
        }
        if (this.getLastRunDetails() != null) {
            sb.append("LastRunDetails: ").append(this.getLastRunDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageOptimizer)) {
            return false;
        }
        StorageOptimizer other = (StorageOptimizer)obj;
        if (other.getStorageOptimizerType() == null ^ this.getStorageOptimizerType() == null) {
            return false;
        }
        if (other.getStorageOptimizerType() != null && !other.getStorageOptimizerType().equals(this.getStorageOptimizerType())) {
            return false;
        }
        if (other.getConfig() == null ^ this.getConfig() == null) {
            return false;
        }
        if (other.getConfig() != null && !other.getConfig().equals(this.getConfig())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        if (other.getWarnings() != null && !other.getWarnings().equals(this.getWarnings())) {
            return false;
        }
        if (other.getLastRunDetails() == null ^ this.getLastRunDetails() == null) {
            return false;
        }
        return other.getLastRunDetails() == null || other.getLastRunDetails().equals(this.getLastRunDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStorageOptimizerType() == null ? 0 : this.getStorageOptimizerType().hashCode());
        hashCode = 31 * hashCode + (this.getConfig() == null ? 0 : this.getConfig().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        hashCode = 31 * hashCode + (this.getLastRunDetails() == null ? 0 : this.getLastRunDetails().hashCode());
        return hashCode;
    }

    public StorageOptimizer clone() {
        try {
            return (StorageOptimizer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StorageOptimizerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

